(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    180828,      14546]*)
(*NotebookOutlinePosition[    181936,      14583]*)
(*  CellTagsIndexPosition[    181892,      14579]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[CellGroupData[{Cell[TextData["Orthogonal Trajectories"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(<< "\<:Graphics:ImplicitPlot.m\>"\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(Information["\<ImplicitPlot\>", LongForm \[Rule] False]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"ImplicitPlot[eqn, {x, a, b}] draws a graph of the set of\n   points that \
satisfy the equation eqn.  The variable x is\n   associated with the \
horizontal axis and ranges from a to\n   b.  The remaining variable in the \
equation is associated\n   with the vertical axis. ImplicitPlot[eqn, {x, a, \
x1, x2,\n   ..., b}] allows the user to specify values of x where\n   special \
care must be exercised.\n   ImplicitPlot[{eqn1,eqn2,..},{x,a,b}] allows more \
than one\n   equation to be plotted, with PlotStyles set as in the\n   Plot \
function. ImplicitPlot[eqn,{x,a,b},{y,a,b}] uses a\n   contour plot method of \
generating the plot.  This form\n   does not allow specification of \
intermediate points."], "Print",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["Example 3.1"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(Lines = Table[y == Tan[\(k\ \[Pi]\)\/7]\ x, {k, 0, 6}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({y == 0, y == x\ Tan[\[Pi]\/7], y == x\ Tan[\(2\ \[Pi]\)\/7], 
      y == x\ Tan[\(3\ \[Pi]\)\/7], y == x\ Tan[\(4\ \[Pi]\)\/7], 
      y == x\ Tan[\(5\ \[Pi]\)\/7], y == x\ Tan[\(6\ \[Pi]\)\/7]}\)], "Output",\

  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(Circles = Table[x\^2 + y\^2 == r\^2, {r, 1\/2, 3, 1\/2}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({x\^2 + y\^2 == 1\/4, x\^2 + y\^2 == 1, x\^2 + y\^2 == 9\/4, 
      x\^2 + y\^2 == 4, x\^2 + y\^2 == 25\/4, x\^2 + y\^2 == 9}\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(curves = Join[Lines, Circles]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({y == 0, y == x\ Tan[\[Pi]\/7], y == x\ Tan[\(2\ \[Pi]\)\/7], 
      y == x\ Tan[\(3\ \[Pi]\)\/7], y == x\ Tan[\(4\ \[Pi]\)\/7], 
      y == x\ Tan[\(5\ \[Pi]\)\/7], y == x\ Tan[\(6\ \[Pi]\)\/7], 
      x\^2 + y\^2 == 1\/4, x\^2 + y\^2 == 1, x\^2 + y\^2 == 9\/4, 
      x\^2 + y\^2 == 4, x\^2 + y\^2 == 25\/4, x\^2 + y\^2 == 9}\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(\(ImplicitPlot[curves, {x, \(-3\), 3}, PlotRange \[Rule] {\(-3\), 3}]; 
    \)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95238 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.47619 0.15873 [
[(-3)] .02381 .47619 0 2 Msboxa
[(-2)] .18254 .47619 0 2 Msboxa
[(-1)] .34127 .47619 0 2 Msboxa
[(1)] .65873 .47619 0 2 Msboxa
[(2)] .81746 .47619 0 2 Msboxa
[(3)] .97619 .47619 0 2 Msboxa
[(-3)] .4875 0 1 0 Msboxa
[(-2)] .4875 .15873 1 0 Msboxa
[(-1)] .4875 .31746 1 0 Msboxa
[(1)] .4875 .63492 1 0 Msboxa
[(2)] .4875 .79365 1 0 Msboxa
[(3)] .4875 .95238 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .95338 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 .47619 m
.02381 .48244 L
s
P
[(-3)] .02381 .47619 0 2 Mshowa
p
.002 w
.18254 .47619 m
.18254 .48244 L
s
P
[(-2)] .18254 .47619 0 2 Mshowa
p
.002 w
.34127 .47619 m
.34127 .48244 L
s
P
[(-1)] .34127 .47619 0 2 Mshowa
p
.002 w
.65873 .47619 m
.65873 .48244 L
s
P
[(1)] .65873 .47619 0 2 Mshowa
p
.002 w
.81746 .47619 m
.81746 .48244 L
s
P
[(2)] .81746 .47619 0 2 Mshowa
p
.002 w
.97619 .47619 m
.97619 .48244 L
s
P
[(3)] .97619 .47619 0 2 Mshowa
p
.001 w
.05556 .47619 m
.05556 .47994 L
s
P
p
.001 w
.0873 .47619 m
.0873 .47994 L
s
P
p
.001 w
.11905 .47619 m
.11905 .47994 L
s
P
p
.001 w
.15079 .47619 m
.15079 .47994 L
s
P
p
.001 w
.21429 .47619 m
.21429 .47994 L
s
P
p
.001 w
.24603 .47619 m
.24603 .47994 L
s
P
p
.001 w
.27778 .47619 m
.27778 .47994 L
s
P
p
.001 w
.30952 .47619 m
.30952 .47994 L
s
P
p
.001 w
.37302 .47619 m
.37302 .47994 L
s
P
p
.001 w
.40476 .47619 m
.40476 .47994 L
s
P
p
.001 w
.43651 .47619 m
.43651 .47994 L
s
P
p
.001 w
.46825 .47619 m
.46825 .47994 L
s
P
p
.001 w
.53175 .47619 m
.53175 .47994 L
s
P
p
.001 w
.56349 .47619 m
.56349 .47994 L
s
P
p
.001 w
.59524 .47619 m
.59524 .47994 L
s
P
p
.001 w
.62698 .47619 m
.62698 .47994 L
s
P
p
.001 w
.69048 .47619 m
.69048 .47994 L
s
P
p
.001 w
.72222 .47619 m
.72222 .47994 L
s
P
p
.001 w
.75397 .47619 m
.75397 .47994 L
s
P
p
.001 w
.78571 .47619 m
.78571 .47994 L
s
P
p
.001 w
.84921 .47619 m
.84921 .47994 L
s
P
p
.001 w
.88095 .47619 m
.88095 .47994 L
s
P
p
.001 w
.9127 .47619 m
.9127 .47994 L
s
P
p
.001 w
.94444 .47619 m
.94444 .47994 L
s
P
p
.002 w
0 .47619 m
1 .47619 L
s
P
p
.002 w
.5 0 m
.50625 0 L
s
P
[(-3)] .4875 0 1 0 Mshowa
p
.002 w
.5 .15873 m
.50625 .15873 L
s
P
[(-2)] .4875 .15873 1 0 Mshowa
p
.002 w
.5 .31746 m
.50625 .31746 L
s
P
[(-1)] .4875 .31746 1 0 Mshowa
p
.002 w
.5 .63492 m
.50625 .63492 L
s
P
[(1)] .4875 .63492 1 0 Mshowa
p
.002 w
.5 .79365 m
.50625 .79365 L
s
P
[(2)] .4875 .79365 1 0 Mshowa
p
.002 w
.5 .95238 m
.50625 .95238 L
s
P
[(3)] .4875 .95238 1 0 Mshowa
p
.001 w
.5 .03175 m
.50375 .03175 L
s
P
p
.001 w
.5 .06349 m
.50375 .06349 L
s
P
p
.001 w
.5 .09524 m
.50375 .09524 L
s
P
p
.001 w
.5 .12698 m
.50375 .12698 L
s
P
p
.001 w
.5 .19048 m
.50375 .19048 L
s
P
p
.001 w
.5 .22222 m
.50375 .22222 L
s
P
p
.001 w
.5 .25397 m
.50375 .25397 L
s
P
p
.001 w
.5 .28571 m
.50375 .28571 L
s
P
p
.001 w
.5 .34921 m
.50375 .34921 L
s
P
p
.001 w
.5 .38095 m
.50375 .38095 L
s
P
p
.001 w
.5 .4127 m
.50375 .4127 L
s
P
p
.001 w
.5 .44444 m
.50375 .44444 L
s
P
p
.001 w
.5 .50794 m
.50375 .50794 L
s
P
p
.001 w
.5 .53968 m
.50375 .53968 L
s
P
p
.001 w
.5 .57143 m
.50375 .57143 L
s
P
p
.001 w
.5 .60317 m
.50375 .60317 L
s
P
p
.001 w
.5 .66667 m
.50375 .66667 L
s
P
p
.001 w
.5 .69841 m
.50375 .69841 L
s
P
p
.001 w
.5 .73016 m
.50375 .73016 L
s
P
p
.001 w
.5 .7619 m
.50375 .7619 L
s
P
p
.001 w
.5 .8254 m
.50375 .8254 L
s
P
p
.001 w
.5 .85714 m
.50375 .85714 L
s
P
p
.001 w
.5 .88889 m
.50375 .88889 L
s
P
p
.001 w
.5 .92063 m
.50375 .92063 L
s
P
p
.002 w
.5 0 m
.5 .95238 L
s
P
P
0 0 m
1 0 L
1 .95238 L
0 .95238 L
closepath
clip
newpath
p
p
p
p
.004 w
.02381 .47619 m
.02788 .47619 L
.04004 .47619 L
.06006 .47619 L
.08761 .47619 L
.12221 .47619 L
.16328 .47619 L
.21011 .47619 L
.2619 .47619 L
.31777 .47619 L
.37675 .47619 L
.43784 .47619 L
.5 .47619 L
.56216 .47619 L
.62325 .47619 L
.68223 .47619 L
.7381 .47619 L
.78989 .47619 L
.83672 .47619 L
.87779 .47619 L
.91239 .47619 L
.93994 .47619 L
.95996 .47619 L
.97212 .47619 L
.97619 .47619 L
s
P
P
P
p
p
p
.004 w
.02381 .24687 m
.02788 .24883 L
.04004 .25468 L
.06006 .26433 L
.08761 .27759 L
.12221 .29426 L
.16328 .31404 L
.21011 .33659 L
.2619 .36153 L
.31777 .38843 L
.37675 .41684 L
.43784 .44626 L
.5 .47619 L
.56216 .50612 L
.62325 .53554 L
.68223 .56395 L
.7381 .59085 L
.78989 .61579 L
.83672 .63835 L
.87779 .65812 L
.91239 .67479 L
.93994 .68806 L
.95996 .6977 L
.97212 .70355 L
.97619 .70551 L
s
P
P
P
p
p
p
.004 w
s
s
s
s
s
.12025 0 m
.12221 .00246 L
s
.12221 .00246 m
.16328 .05396 L
.21011 .11268 L
.2619 .17763 L
.31777 .24768 L
.37675 .32164 L
.43784 .39825 L
.5 .47619 L
.56216 .55413 L
.62325 .63074 L
.68223 .7047 L
.7381 .77475 L
.78989 .8397 L
.83672 .89842 L
.87779 .94992 L
s
.87975 .95238 m
.87779 .94992 L
s
s
s
s
s
s
P
P
P
p
p
p
.004 w
s
s
s
s
s
s
s
s
s
s
s
.39131 0 m
.43784 .20387 L
s
.43784 .20387 m
.5 .47619 L
.56216 .74851 L
s
.60869 .95238 m
.56216 .74851 L
s
s
s
s
s
s
s
s
s
s
s
s
P
P
P
p
p
p
.004 w
s
s
s
s
s
s
s
s
s
s
s
.39131 .95238 m
.43784 .74851 L
s
.43784 .74851 m
.5 .47619 L
.56216 .20387 L
s
.60869 0 m
.56216 .20387 L
s
s
s
s
s
s
s
s
s
s
s
s
P
P
P
p
p
p
.004 w
s
s
s
s
s
.12025 .95238 m
.12221 .94992 L
s
.12221 .94992 m
.16328 .89842 L
.21011 .8397 L
.2619 .77475 L
.31777 .7047 L
.37675 .63074 L
.43784 .55413 L
.5 .47619 L
.56216 .39825 L
.62325 .32164 L
.68223 .24768 L
.7381 .17763 L
.78989 .11268 L
.83672 .05396 L
.87779 .00246 L
s
.87975 0 m
.87779 .00246 L
s
s
s
s
s
s
P
P
P
p
p
p
.004 w
.02381 .70551 m
.02788 .70355 L
.04004 .6977 L
.06006 .68806 L
.08761 .67479 L
.12221 .65812 L
.16328 .63835 L
.21011 .61579 L
.2619 .59085 L
.31777 .56395 L
.37675 .53554 L
.43784 .50612 L
.5 .47619 L
.56216 .44626 L
.62325 .41684 L
.68223 .38843 L
.7381 .36153 L
.78989 .33659 L
.83672 .31404 L
.87779 .29426 L
.91239 .27759 L
.93994 .26433 L
.95996 .25468 L
.97212 .24883 L
.97619 .24687 L
s
P
P
P
p
p
P
p
p
.004 w
.42063 .47615 m
.42131 .46583 L
.42334 .45565 L
.42668 .44582 L
.43127 .43651 L
.43704 .42788 L
.44388 .42007 L
.45169 .41323 L
.46032 .40746 L
.46963 .40287 L
.47946 .39953 L
.48964 .3975 L
.5 .39683 L
.51036 .3975 L
.52054 .39953 L
.53037 .40287 L
.53968 .40746 L
.54831 .41323 L
.55612 .42007 L
.56296 .42788 L
.56873 .43651 L
.57332 .44582 L
.57666 .45565 L
.57869 .46583 L
.57937 .47615 L
s
P
p
.004 w
.42063 .47623 m
.42131 .48655 L
.42334 .49673 L
.42668 .50656 L
.43127 .51587 L
.43704 .5245 L
.44388 .53231 L
.45169 .53916 L
.46032 .54492 L
.46963 .54951 L
.47946 .55285 L
.48964 .55488 L
.5 .55556 L
.51036 .55488 L
.52054 .55285 L
.53037 .54951 L
.53968 .54492 L
.54831 .53916 L
.55612 .53231 L
.56296 .5245 L
.56873 .51587 L
.57332 .50656 L
.57666 .49673 L
.57869 .48655 L
.57937 .47623 L
s
P
P
p
P
P
p
p
P
p
p
.004 w
.34127 .47614 m
.34263 .45547 L
.34668 .43511 L
.35335 .41545 L
.36254 .39683 L
.37407 .37956 L
.38776 .36395 L
.40337 .35026 L
.42063 .33873 L
.43926 .32954 L
.45892 .32287 L
.47928 .31882 L
.5 .31746 L
.52072 .31882 L
.54108 .32287 L
.56074 .32954 L
.57937 .33873 L
.59663 .35026 L
.61224 .36395 L
.62593 .37956 L
.63746 .39683 L
.64665 .41545 L
.65332 .43511 L
.65737 .45547 L
.65873 .47614 L
s
P
p
.004 w
.34127 .47625 m
.34263 .49691 L
.34668 .51727 L
.35335 .53693 L
.36254 .55556 L
.37407 .57282 L
.38776 .58843 L
.40337 .60212 L
.42063 .61365 L
.43926 .62284 L
.45892 .62951 L
.47928 .63356 L
.5 .63492 L
.52072 .63356 L
.54108 .62951 L
.56074 .62284 L
.57937 .61365 L
.59663 .60212 L
.61224 .58843 L
.62593 .57282 L
.63746 .55556 L
.64665 .53693 L
.65332 .51727 L
.65737 .49691 L
.65873 .47625 L
s
P
P
p
P
P
p
p
P
p
p
.004 w
.2619 .47612 m
.26394 .44511 L
.27002 .41457 L
.28003 .38508 L
.2938 .35714 L
.31111 .33125 L
.33164 .30783 L
.35506 .2873 L
.38095 .26999 L
.40888 .25622 L
.43838 .24621 L
.46892 .24013 L
.5 .2381 L
.53108 .24013 L
.56162 .24621 L
.59112 .25622 L
.61905 .26999 L
.64494 .2873 L
.66836 .30783 L
.68889 .33125 L
.7062 .35714 L
.71997 .38508 L
.72998 .41457 L
.73606 .44511 L
.7381 .47612 L
s
P
p
.004 w
.2619 .47626 m
.26394 .50727 L
.27002 .53781 L
.28003 .56731 L
.2938 .59524 L
.31111 .62113 L
.33164 .64455 L
.35506 .66508 L
.38095 .68239 L
.40888 .69616 L
.43838 .70617 L
.46892 .71225 L
.5 .71429 L
.53108 .71225 L
.56162 .70617 L
.59112 .69616 L
.61905 .68239 L
.64494 .66508 L
.66836 .64455 L
.68889 .62113 L
.7062 .59524 L
.71997 .56731 L
.72998 .53781 L
.73606 .50727 L
.7381 .47626 L
s
P
P
p
P
P
p
p
P
p
p
.004 w
.18254 .47611 m
.18526 .43475 L
.19336 .39403 L
.2067 .3547 L
.22507 .31746 L
.24814 .28293 L
.27552 .25171 L
.30674 .22433 L
.34127 .20126 L
.37851 .1829 L
.41784 .16955 L
.45856 .16145 L
.5 .15873 L
.54144 .16145 L
.58216 .16955 L
.62149 .1829 L
.65873 .20126 L
.69326 .22433 L
.72448 .25171 L
.75186 .28293 L
.77493 .31746 L
.7933 .3547 L
.80664 .39403 L
.81474 .43475 L
.81746 .47611 L
s
P
p
.004 w
.18254 .47627 m
.18526 .51763 L
.19336 .55836 L
.2067 .59768 L
.22507 .63492 L
.24814 .66945 L
.27552 .70067 L
.30674 .72805 L
.34127 .75112 L
.37851 .76949 L
.41784 .78283 L
.45856 .79093 L
.5 .79365 L
.54144 .79093 L
.58216 .78283 L
.62149 .76949 L
.65873 .75112 L
.69326 .72805 L
.72448 .70067 L
.75186 .66945 L
.77493 .63492 L
.7933 .59768 L
.80664 .55836 L
.81474 .51763 L
.81746 .47627 L
s
P
P
p
P
P
p
p
P
p
p
.004 w
.10317 .4761 m
.10657 .42439 L
.1167 .37348 L
.13338 .32433 L
.15634 .27778 L
.18518 .23462 L
.2194 .19559 L
.25843 .16137 L
.30159 .13253 L
.34814 .10957 L
.39729 .09289 L
.4482 .08276 L
.5 .07937 L
.5518 .08276 L
.60271 .09289 L
.65186 .10957 L
.69841 .13253 L
.74157 .16137 L
.7806 .19559 L
.81482 .23462 L
.84366 .27778 L
.86662 .32433 L
.8833 .37348 L
.89343 .42439 L
.89683 .4761 L
s
P
p
.004 w
.10317 .47628 m
.10657 .52799 L
.1167 .5789 L
.13338 .62805 L
.15634 .6746 L
.18518 .71776 L
.2194 .75679 L
.25843 .79101 L
.30159 .81985 L
.34814 .84281 L
.39729 .85949 L
.4482 .86962 L
.5 .87302 L
.5518 .86962 L
.60271 .85949 L
.65186 .84281 L
.69841 .81985 L
.74157 .79101 L
.7806 .75679 L
.81482 .71776 L
.84366 .6746 L
.86662 .62805 L
.8833 .5789 L
.89343 .52799 L
.89683 .47628 L
s
P
P
p
P
P
p
p
p
.004 w
.02381 .4761 m
.02788 .41404 L
.04004 .35294 L
.06006 .29396 L
.08761 .2381 L
.12221 .1863 L
.16328 .13947 L
.21011 .0984 L
.2619 .0638 L
.31777 .03625 L
.37675 .01623 L
.43784 .00407 L
.5 0 L
.56216 .00407 L
.62325 .01623 L
.68223 .03625 L
.7381 .0638 L
.78989 .0984 L
.83672 .13947 L
.87779 .1863 L
.91239 .2381 L
.93994 .29396 L
.95996 .35294 L
.97212 .41404 L
.97619 .4761 L
s
P
p
.004 w
.02381 .47629 m
.02788 .53835 L
.04004 .59944 L
.06006 .65842 L
.08761 .71429 L
.12221 .76608 L
.16328 .81291 L
.21011 .85398 L
.2619 .88858 L
.31777 .91613 L
.37675 .93616 L
.43784 .94831 L
.5 .95238 L
.56216 .94831 L
.62325 .93616 L
.68223 .91613 L
.7381 .88858 L
.78989 .85398 L
.83672 .81291 L
.87779 .76608 L
.91239 .71429 L
.93994 .65842 L
.95996 .59944 L
.97212 .53835 L
.97619 .47629 L
s
P
P
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{186, 176},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCacheValid->False]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Example 3.2"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(HT = {x\ y == \(-9\), x\ y == \(-4\), x\ y == \(-1\), x\ y == 1, 
        x\ y == 4, x\ y == 9}\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({x\ y == \(-9\), x\ y == \(-4\), x\ y == \(-1\), x\ y == 1, x\ y == 4, 
      x\ y == 9}\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(\(hp1 = 
      ImplicitPlot[HT, {x, \(-4\), 0, 4}, PlotRange \[Rule] {\(-4\), 4}, 
        PlotPoints \[Rule] 30]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95238 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.47619 0.119048 [
[(-4)] .02381 .47619 0 2 Msboxa
[(-2)] .2619 .47619 0 2 Msboxa
[(2)] .7381 .47619 0 2 Msboxa
[(4)] .97619 .47619 0 2 Msboxa
[(-4)] .4875 0 1 0 Msboxa
[(-3)] .4875 .11905 1 0 Msboxa
[(-2)] .4875 .2381 1 0 Msboxa
[(-1)] .4875 .35714 1 0 Msboxa
[(1)] .4875 .59524 1 0 Msboxa
[(2)] .4875 .71429 1 0 Msboxa
[(3)] .4875 .83333 1 0 Msboxa
[(4)] .4875 .95238 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .95338 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 .47619 m
.02381 .48244 L
s
P
[(-4)] .02381 .47619 0 2 Mshowa
p
.002 w
.2619 .47619 m
.2619 .48244 L
s
P
[(-2)] .2619 .47619 0 2 Mshowa
p
.002 w
.7381 .47619 m
.7381 .48244 L
s
P
[(2)] .7381 .47619 0 2 Mshowa
p
.002 w
.97619 .47619 m
.97619 .48244 L
s
P
[(4)] .97619 .47619 0 2 Mshowa
p
.001 w
.07143 .47619 m
.07143 .47994 L
s
P
p
.001 w
.11905 .47619 m
.11905 .47994 L
s
P
p
.001 w
.16667 .47619 m
.16667 .47994 L
s
P
p
.001 w
.21429 .47619 m
.21429 .47994 L
s
P
p
.001 w
.30952 .47619 m
.30952 .47994 L
s
P
p
.001 w
.35714 .47619 m
.35714 .47994 L
s
P
p
.001 w
.40476 .47619 m
.40476 .47994 L
s
P
p
.001 w
.45238 .47619 m
.45238 .47994 L
s
P
p
.001 w
.54762 .47619 m
.54762 .47994 L
s
P
p
.001 w
.59524 .47619 m
.59524 .47994 L
s
P
p
.001 w
.64286 .47619 m
.64286 .47994 L
s
P
p
.001 w
.69048 .47619 m
.69048 .47994 L
s
P
p
.001 w
.78571 .47619 m
.78571 .47994 L
s
P
p
.001 w
.83333 .47619 m
.83333 .47994 L
s
P
p
.001 w
.88095 .47619 m
.88095 .47994 L
s
P
p
.001 w
.92857 .47619 m
.92857 .47994 L
s
P
p
.002 w
0 .47619 m
1 .47619 L
s
P
p
.002 w
.5 0 m
.50625 0 L
s
P
[(-4)] .4875 0 1 0 Mshowa
p
.002 w
.5 .11905 m
.50625 .11905 L
s
P
[(-3)] .4875 .11905 1 0 Mshowa
p
.002 w
.5 .2381 m
.50625 .2381 L
s
P
[(-2)] .4875 .2381 1 0 Mshowa
p
.002 w
.5 .35714 m
.50625 .35714 L
s
P
[(-1)] .4875 .35714 1 0 Mshowa
p
.002 w
.5 .59524 m
.50625 .59524 L
s
P
[(1)] .4875 .59524 1 0 Mshowa
p
.002 w
.5 .71429 m
.50625 .71429 L
s
P
[(2)] .4875 .71429 1 0 Mshowa
p
.002 w
.5 .83333 m
.50625 .83333 L
s
P
[(3)] .4875 .83333 1 0 Mshowa
p
.002 w
.5 .95238 m
.50625 .95238 L
s
P
[(4)] .4875 .95238 1 0 Mshowa
p
.001 w
.5 .02381 m
.50375 .02381 L
s
P
p
.001 w
.5 .04762 m
.50375 .04762 L
s
P
p
.001 w
.5 .07143 m
.50375 .07143 L
s
P
p
.001 w
.5 .09524 m
.50375 .09524 L
s
P
p
.001 w
.5 .14286 m
.50375 .14286 L
s
P
p
.001 w
.5 .16667 m
.50375 .16667 L
s
P
p
.001 w
.5 .19048 m
.50375 .19048 L
s
P
p
.001 w
.5 .21429 m
.50375 .21429 L
s
P
p
.001 w
.5 .2619 m
.50375 .2619 L
s
P
p
.001 w
.5 .28571 m
.50375 .28571 L
s
P
p
.001 w
.5 .30952 m
.50375 .30952 L
s
P
p
.001 w
.5 .33333 m
.50375 .33333 L
s
P
p
.001 w
.5 .38095 m
.50375 .38095 L
s
P
p
.001 w
.5 .40476 m
.50375 .40476 L
s
P
p
.001 w
.5 .42857 m
.50375 .42857 L
s
P
p
.001 w
.5 .45238 m
.50375 .45238 L
s
P
p
.001 w
.5 .5 m
.50375 .5 L
s
P
p
.001 w
.5 .52381 m
.50375 .52381 L
s
P
p
.001 w
.5 .54762 m
.50375 .54762 L
s
P
p
.001 w
.5 .57143 m
.50375 .57143 L
s
P
p
.001 w
.5 .61905 m
.50375 .61905 L
s
P
p
.001 w
.5 .64286 m
.50375 .64286 L
s
P
p
.001 w
.5 .66667 m
.50375 .66667 L
s
P
p
.001 w
.5 .69048 m
.50375 .69048 L
s
P
p
.001 w
.5 .7381 m
.50375 .7381 L
s
P
p
.001 w
.5 .7619 m
.50375 .7619 L
s
P
p
.001 w
.5 .78571 m
.50375 .78571 L
s
P
p
.001 w
.5 .80952 m
.50375 .80952 L
s
P
p
.001 w
.5 .85714 m
.50375 .85714 L
s
P
p
.001 w
.5 .88095 m
.50375 .88095 L
s
P
p
.001 w
.5 .90476 m
.50375 .90476 L
s
P
p
.001 w
.5 .92857 m
.50375 .92857 L
s
P
p
.002 w
.5 0 m
.5 .95238 L
s
P
P
0 0 m
1 0 L
1 .95238 L
0 .95238 L
closepath
clip
newpath
p
p
p
p
.004 w
.02381 .74405 m
.02521 .74484 L
.02938 .74722 L
.03627 .75125 L
.04582 .75703 L
.05789 .7647 L
.07236 .77446 L
.08905 .78657 L
.10777 .80138 L
.12829 .81934 L
.15038 .84102 L
.17378 .86718 L
.19821 .89884 L
.22339 .9373 L
s
.23159 .95238 m
.22339 .9373 L
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
P
P
p
p
.004 w
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
.76841 0 m
.77661 .01508 L
s
.77661 .01508 m
.80179 .05355 L
.82622 .0852 L
.84962 .11136 L
.87171 .13304 L
.89223 .151 L
.91095 .16581 L
.92764 .17792 L
.94211 .18768 L
.95418 .19536 L
.96373 .20113 L
.97062 .20517 L
.97479 .20755 L
.97619 .20833 L
s
P
P
P
p
p
p
.004 w
.02381 .59524 m
.02521 .59559 L
.02938 .59665 L
.03627 .59844 L
.04582 .60101 L
.05789 .60442 L
.07236 .60875 L
.08905 .61414 L
.10777 .62072 L
.12829 .6287 L
.15038 .63834 L
.17378 .64997 L
.19821 .66403 L
.22339 .68113 L
.24901 .70206 L
.27479 .72791 L
.30042 .76024 L
.3256 .80125 L
.35003 .8542 L
.37343 .92408 L
s
.38003 .95238 m
.37343 .92408 L
s
s
s
s
s
s
s
s
s
s
s
P
P
p
p
.004 w
s
s
s
s
s
s
s
s
s
s
.61997 0 m
.62657 .0283 L
s
.62657 .0283 m
.64997 .09818 L
.6744 .15113 L
.69958 .19214 L
.72521 .22447 L
.75099 .25032 L
.77661 .27125 L
.80179 .28835 L
.82622 .30242 L
.84962 .31405 L
.87171 .32368 L
.89223 .33166 L
.91095 .33824 L
.92764 .34363 L
.94211 .34797 L
.95418 .35137 L
.96373 .35394 L
.97062 .35573 L
.97479 .35679 L
.97619 .35714 L
s
P
P
P
p
p
p
.004 w
.02381 .50595 m
.02521 .50604 L
.02938 .5063 L
.03627 .50675 L
.04582 .50739 L
.05789 .50825 L
.07236 .50933 L
.08905 .51068 L
.10777 .51232 L
.12829 .51432 L
.15038 .51673 L
.17378 .51963 L
.19821 .52315 L
.22339 .52743 L
.24901 .53266 L
.27479 .53912 L
.30042 .5472 L
.3256 .55745 L
.35003 .57069 L
.37343 .58816 L
.39552 .61184 L
.41604 .645 L
.43476 .69343 L
.45145 .76811 L
.46592 .89203 L
s
.46911 .95238 m
.46592 .89203 L
s
s
s
s
s
s
P
P
p
p
.004 w
s
s
s
s
s
.53089 0 m
.53408 .06036 L
s
.53408 .06036 m
.54855 .18427 L
.56524 .25895 L
.58396 .30738 L
.60448 .34054 L
.62657 .36422 L
.64997 .38169 L
.6744 .39493 L
.69958 .40518 L
.72521 .41326 L
.75099 .41972 L
.77661 .42496 L
.80179 .42923 L
.82622 .43275 L
.84962 .43565 L
.87171 .43806 L
.89223 .44006 L
.91095 .4417 L
.92764 .44305 L
.94211 .44413 L
.95418 .44499 L
.96373 .44563 L
.97062 .44608 L
.97479 .44634 L
.97619 .44643 L
s
P
P
P
p
p
p
.004 w
.02381 .44643 m
.02521 .44634 L
.02938 .44608 L
.03627 .44563 L
.04582 .44499 L
.05789 .44413 L
.07236 .44305 L
.08905 .4417 L
.10777 .44006 L
.12829 .43806 L
.15038 .43565 L
.17378 .43275 L
.19821 .42923 L
.22339 .42496 L
.24901 .41972 L
.27479 .41326 L
.30042 .40518 L
.3256 .39493 L
.35003 .38169 L
.37343 .36422 L
.39552 .34054 L
.41604 .30738 L
.43476 .25895 L
.45145 .18427 L
.46592 .06036 L
s
.46911 0 m
.46592 .06036 L
s
s
s
s
s
s
P
P
p
p
.004 w
s
s
s
s
s
.53089 .95238 m
.53408 .89203 L
s
.53408 .89203 m
.54855 .76811 L
.56524 .69343 L
.58396 .645 L
.60448 .61184 L
.62657 .58816 L
.64997 .57069 L
.6744 .55745 L
.69958 .5472 L
.72521 .53912 L
.75099 .53266 L
.77661 .52743 L
.80179 .52315 L
.82622 .51963 L
.84962 .51673 L
.87171 .51432 L
.89223 .51232 L
.91095 .51068 L
.92764 .50933 L
.94211 .50825 L
.95418 .50739 L
.96373 .50675 L
.97062 .5063 L
.97479 .50604 L
.97619 .50595 L
s
P
P
P
p
p
p
.004 w
.02381 .35714 m
.02521 .35679 L
.02938 .35573 L
.03627 .35394 L
.04582 .35137 L
.05789 .34797 L
.07236 .34363 L
.08905 .33824 L
.10777 .33166 L
.12829 .32368 L
.15038 .31405 L
.17378 .30242 L
.19821 .28835 L
.22339 .27125 L
.24901 .25032 L
.27479 .22447 L
.30042 .19214 L
.3256 .15113 L
.35003 .09818 L
.37343 .0283 L
s
.38003 0 m
.37343 .0283 L
s
s
s
s
s
s
s
s
s
s
s
P
P
p
p
.004 w
s
s
s
s
s
s
s
s
s
s
.61997 .95238 m
.62657 .92408 L
s
.62657 .92408 m
.64997 .8542 L
.6744 .80125 L
.69958 .76024 L
.72521 .72791 L
.75099 .70206 L
.77661 .68113 L
.80179 .66403 L
.82622 .64997 L
.84962 .63834 L
.87171 .6287 L
.89223 .62072 L
.91095 .61414 L
.92764 .60875 L
.94211 .60442 L
.95418 .60101 L
.96373 .59844 L
.97062 .59665 L
.97479 .59559 L
.97619 .59524 L
s
P
P
P
p
p
p
.004 w
.02381 .20833 m
.02521 .20755 L
.02938 .20517 L
.03627 .20113 L
.04582 .19536 L
.05789 .18768 L
.07236 .17792 L
.08905 .16581 L
.10777 .151 L
.12829 .13304 L
.15038 .11136 L
.17378 .0852 L
.19821 .05355 L
.22339 .01508 L
s
.23159 0 m
.22339 .01508 L
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
P
P
p
p
.004 w
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
.76841 .95238 m
.77661 .9373 L
s
.77661 .9373 m
.80179 .89884 L
.82622 .86718 L
.84962 .84102 L
.87171 .81934 L
.89223 .80138 L
.91095 .78657 L
.92764 .77446 L
.94211 .7647 L
.95418 .75703 L
.96373 .75125 L
.97062 .74722 L
.97479 .74484 L
.97619 .74405 L
s
P
P
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 268},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCacheValid->False],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(H1 = Table[x\^2 - y\^2 == r\^2, {r, 0, 3}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({x\^2 - y\^2 == 0, x\^2 - y\^2 == 1, x\^2 - y\^2 == 4, x\^2 - y\^2 == 9}
      \)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(H2 = Table[y\^2 - x\^2 == r\^2, {r, 1, 3}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({\(-x\^2\) + y\^2 == 1, \(-x\^2\) + y\^2 == 4, \(-x\^2\) + y\^2 == 9}
      \)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(Hyperbolas = Join[H1, H2]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({x\^2 - y\^2 == 0, x\^2 - y\^2 == 1, x\^2 - y\^2 == 4, 
      x\^2 - y\^2 == 9, \(-x\^2\) + y\^2 == 1, \(-x\^2\) + y\^2 == 4, 
      \(-x\^2\) + y\^2 == 9}\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(\(hp2 = 
      ImplicitPlot[Hyperbolas, {x, \(-4\), 4}, PlotRange \[Rule] {\(-4\), 4}, 
        PlotPoints \[Rule] 30]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95238 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.47619 0.119048 [
[(-4)] .02381 .47619 0 2 Msboxa
[(-2)] .2619 .47619 0 2 Msboxa
[(2)] .7381 .47619 0 2 Msboxa
[(4)] .97619 .47619 0 2 Msboxa
[(-4)] .4875 0 1 0 Msboxa
[(-3)] .4875 .11905 1 0 Msboxa
[(-2)] .4875 .2381 1 0 Msboxa
[(-1)] .4875 .35714 1 0 Msboxa
[(1)] .4875 .59524 1 0 Msboxa
[(2)] .4875 .71429 1 0 Msboxa
[(3)] .4875 .83333 1 0 Msboxa
[(4)] .4875 .95238 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .95338 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 .47619 m
.02381 .48244 L
s
P
[(-4)] .02381 .47619 0 2 Mshowa
p
.002 w
.2619 .47619 m
.2619 .48244 L
s
P
[(-2)] .2619 .47619 0 2 Mshowa
p
.002 w
.7381 .47619 m
.7381 .48244 L
s
P
[(2)] .7381 .47619 0 2 Mshowa
p
.002 w
.97619 .47619 m
.97619 .48244 L
s
P
[(4)] .97619 .47619 0 2 Mshowa
p
.001 w
.07143 .47619 m
.07143 .47994 L
s
P
p
.001 w
.11905 .47619 m
.11905 .47994 L
s
P
p
.001 w
.16667 .47619 m
.16667 .47994 L
s
P
p
.001 w
.21429 .47619 m
.21429 .47994 L
s
P
p
.001 w
.30952 .47619 m
.30952 .47994 L
s
P
p
.001 w
.35714 .47619 m
.35714 .47994 L
s
P
p
.001 w
.40476 .47619 m
.40476 .47994 L
s
P
p
.001 w
.45238 .47619 m
.45238 .47994 L
s
P
p
.001 w
.54762 .47619 m
.54762 .47994 L
s
P
p
.001 w
.59524 .47619 m
.59524 .47994 L
s
P
p
.001 w
.64286 .47619 m
.64286 .47994 L
s
P
p
.001 w
.69048 .47619 m
.69048 .47994 L
s
P
p
.001 w
.78571 .47619 m
.78571 .47994 L
s
P
p
.001 w
.83333 .47619 m
.83333 .47994 L
s
P
p
.001 w
.88095 .47619 m
.88095 .47994 L
s
P
p
.001 w
.92857 .47619 m
.92857 .47994 L
s
P
p
.002 w
0 .47619 m
1 .47619 L
s
P
p
.002 w
.5 0 m
.50625 0 L
s
P
[(-4)] .4875 0 1 0 Mshowa
p
.002 w
.5 .11905 m
.50625 .11905 L
s
P
[(-3)] .4875 .11905 1 0 Mshowa
p
.002 w
.5 .2381 m
.50625 .2381 L
s
P
[(-2)] .4875 .2381 1 0 Mshowa
p
.002 w
.5 .35714 m
.50625 .35714 L
s
P
[(-1)] .4875 .35714 1 0 Mshowa
p
.002 w
.5 .59524 m
.50625 .59524 L
s
P
[(1)] .4875 .59524 1 0 Mshowa
p
.002 w
.5 .71429 m
.50625 .71429 L
s
P
[(2)] .4875 .71429 1 0 Mshowa
p
.002 w
.5 .83333 m
.50625 .83333 L
s
P
[(3)] .4875 .83333 1 0 Mshowa
p
.002 w
.5 .95238 m
.50625 .95238 L
s
P
[(4)] .4875 .95238 1 0 Mshowa
p
.001 w
.5 .02381 m
.50375 .02381 L
s
P
p
.001 w
.5 .04762 m
.50375 .04762 L
s
P
p
.001 w
.5 .07143 m
.50375 .07143 L
s
P
p
.001 w
.5 .09524 m
.50375 .09524 L
s
P
p
.001 w
.5 .14286 m
.50375 .14286 L
s
P
p
.001 w
.5 .16667 m
.50375 .16667 L
s
P
p
.001 w
.5 .19048 m
.50375 .19048 L
s
P
p
.001 w
.5 .21429 m
.50375 .21429 L
s
P
p
.001 w
.5 .2619 m
.50375 .2619 L
s
P
p
.001 w
.5 .28571 m
.50375 .28571 L
s
P
p
.001 w
.5 .30952 m
.50375 .30952 L
s
P
p
.001 w
.5 .33333 m
.50375 .33333 L
s
P
p
.001 w
.5 .38095 m
.50375 .38095 L
s
P
p
.001 w
.5 .40476 m
.50375 .40476 L
s
P
p
.001 w
.5 .42857 m
.50375 .42857 L
s
P
p
.001 w
.5 .45238 m
.50375 .45238 L
s
P
p
.001 w
.5 .5 m
.50375 .5 L
s
P
p
.001 w
.5 .52381 m
.50375 .52381 L
s
P
p
.001 w
.5 .54762 m
.50375 .54762 L
s
P
p
.001 w
.5 .57143 m
.50375 .57143 L
s
P
p
.001 w
.5 .61905 m
.50375 .61905 L
s
P
p
.001 w
.5 .64286 m
.50375 .64286 L
s
P
p
.001 w
.5 .66667 m
.50375 .66667 L
s
P
p
.001 w
.5 .69048 m
.50375 .69048 L
s
P
p
.001 w
.5 .7381 m
.50375 .7381 L
s
P
p
.001 w
.5 .7619 m
.50375 .7619 L
s
P
p
.001 w
.5 .78571 m
.50375 .78571 L
s
P
p
.001 w
.5 .80952 m
.50375 .80952 L
s
P
p
.001 w
.5 .85714 m
.50375 .85714 L
s
P
p
.001 w
.5 .88095 m
.50375 .88095 L
s
P
p
.001 w
.5 .90476 m
.50375 .90476 L
s
P
p
.001 w
.5 .92857 m
.50375 .92857 L
s
P
p
.002 w
.5 0 m
.5 .95238 L
s
P
P
0 0 m
1 0 L
1 .95238 L
0 .95238 L
closepath
clip
newpath
p
p
p
p
.004 w
.02381 0 m
.02521 .0014 L
.02938 .00557 L
.03627 .01246 L
.04582 .02201 L
.05789 .03408 L
.07236 .04855 L
.08905 .06524 L
.10777 .08396 L
.12829 .10448 L
.15038 .12657 L
.17378 .14997 L
.19821 .1744 L
.22339 .19958 L
.24901 .22521 L
.27479 .25099 L
.30042 .27661 L
.3256 .30179 L
.35003 .32622 L
.37343 .34962 L
.39552 .37171 L
.41604 .39223 L
.43476 .41095 L
.45145 .42764 L
.46592 .44211 L
.47799 .45418 L
.48754 .46373 L
.49443 .47062 L
.4986 .47479 L
.5 .47619 L
s
P
p
.004 w
.02381 .95238 m
.02521 .95099 L
.02938 .94681 L
.03627 .93992 L
.04582 .93038 L
.05789 .9183 L
.07236 .90383 L
.08905 .88714 L
.10777 .86843 L
.12829 .8479 L
.15038 .82581 L
.17378 .80241 L
.19821 .77798 L
.22339 .75281 L
.24901 .72718 L
.27479 .7014 L
.30042 .67577 L
.3256 .65059 L
.35003 .62616 L
.37343 .60276 L
.39552 .58067 L
.41604 .56015 L
.43476 .54143 L
.45145 .52474 L
.46592 .51027 L
.47799 .4982 L
.48754 .48865 L
.49443 .48176 L
.4986 .47759 L
.5 .47619 L
s
P
P
p
p
.004 w
.5 .47619 m
.5014 .47479 L
.50557 .47062 L
.51246 .46373 L
.52201 .45418 L
.53408 .44211 L
.54855 .42764 L
.56524 .41095 L
.58396 .39223 L
.60448 .37171 L
.62657 .34962 L
.64997 .32622 L
.6744 .30179 L
.69958 .27661 L
.72521 .25099 L
.75099 .22521 L
.77661 .19958 L
.80179 .1744 L
.82622 .14997 L
.84962 .12657 L
.87171 .10448 L
.89223 .08396 L
.91095 .06524 L
.92764 .04855 L
.94211 .03408 L
.95418 .02201 L
.96373 .01246 L
.97062 .00557 L
.97479 .0014 L
.97619 0 L
s
P
p
.004 w
.5 .47619 m
.5014 .47759 L
.50557 .48176 L
.51246 .48865 L
.52201 .4982 L
.53408 .51027 L
.54855 .52474 L
.56524 .54143 L
.58396 .56015 L
.60448 .58067 L
.62657 .60276 L
.64997 .62616 L
.6744 .65059 L
.69958 .67577 L
.72521 .7014 L
.75099 .72718 L
.77661 .75281 L
.80179 .77798 L
.82622 .80241 L
.84962 .82581 L
.87171 .8479 L
.89223 .86843 L
.91095 .88714 L
.92764 .90383 L
.94211 .9183 L
.95418 .93038 L
.96373 .93992 L
.97062 .94681 L
.97479 .95099 L
.97619 .95238 L
s
P
P
P
p
p
p
.004 w
.02381 .01512 m
.02486 .0162 L
.02798 .01943 L
.03316 .02478 L
.04031 .03219 L
.04937 .04157 L
.06022 .05283 L
.07274 .06585 L
.08678 .08049 L
.10217 .09659 L
.11874 .11399 L
.13628 .13251 L
.15461 .15196 L
.17349 .17216 L
.19271 .1929 L
.21205 .214 L
.23127 .23527 L
.25015 .25653 L
.26848 .27762 L
.28603 .29839 L
.30259 .31872 L
.31799 .33851 L
.33202 .35768 L
.34454 .37621 L
.35539 .3941 L
.36445 .41137 L
.3716 .4281 L
.37678 .44439 L
.37991 .46037 L
.38095 .47614 L
s
P
p
.004 w
.02381 .93726 m
.02486 .93618 L
.02798 .93295 L
.03316 .9276 L
.04031 .92019 L
.04937 .91081 L
.06022 .89955 L
.07274 .88653 L
.08678 .87189 L
.10217 .85579 L
.11874 .83839 L
.13628 .81987 L
.15461 .80042 L
.17349 .78022 L
.19271 .75948 L
.21205 .73838 L
.23127 .71711 L
.25015 .69585 L
.26848 .67476 L
.28603 .65399 L
.30259 .63366 L
.31799 .61387 L
.33202 .5947 L
.34454 .57617 L
.35539 .55828 L
.36445 .54101 L
.3716 .52428 L
.37678 .50799 L
.37991 .49201 L
.38095 .47624 L
s
P
P
p
P
p
p
.004 w
.61905 .47614 m
.62009 .46037 L
.62322 .44439 L
.6284 .4281 L
.63555 .41137 L
.64461 .3941 L
.65546 .37621 L
.66798 .35768 L
.68201 .33851 L
.69741 .31872 L
.71397 .29839 L
.73152 .27762 L
.74985 .25653 L
.76873 .23527 L
.78795 .214 L
.80729 .1929 L
.82651 .17216 L
.84539 .15196 L
.86372 .13251 L
.88126 .11399 L
.89783 .09659 L
.91322 .08049 L
.92726 .06585 L
.93978 .05283 L
.95063 .04157 L
.95969 .03219 L
.96684 .02478 L
.97202 .01943 L
.97514 .0162 L
.97619 .01512 L
s
P
p
.004 w
.61905 .47624 m
.62009 .49201 L
.62322 .50799 L
.6284 .52428 L
.63555 .54101 L
.64461 .55828 L
.65546 .57617 L
.66798 .5947 L
.68201 .61387 L
.69741 .63366 L
.71397 .65399 L
.73152 .67476 L
.74985 .69585 L
.76873 .71711 L
.78795 .73838 L
.80729 .75948 L
.82651 .78022 L
.84539 .80042 L
.86372 .81987 L
.88126 .83839 L
.89783 .85579 L
.91322 .87189 L
.92726 .88653 L
.93978 .89955 L
.95063 .91081 L
.95969 .92019 L
.96684 .9276 L
.97202 .93295 L
.97514 .93618 L
.97619 .93726 L
s
P
P
P
p
p
p
.004 w
.02381 .0638 m
.02451 .0646 L
.02659 .06701 L
.03004 .07101 L
.03481 .07655 L
.04085 .0836 L
.04808 .09208 L
.05643 .10194 L
.06579 .11308 L
.07605 .12541 L
.08709 .13885 L
.09879 .15327 L
.11101 .16858 L
.1236 .18466 L
.13641 .20141 L
.1493 .2187 L
.16212 .23645 L
.17471 .25454 L
.18692 .2729 L
.19862 .29142 L
.20967 .31004 L
.21993 .32871 L
.22929 .34736 L
.23763 .36597 L
.24486 .38451 L
.2509 .40297 L
.25567 .42136 L
.25912 .43968 L
.26121 .45795 L
.2619 .47612 L
s
P
p
.004 w
.02381 .88858 m
.02451 .88778 L
.02659 .88537 L
.03004 .88137 L
.03481 .87583 L
.04085 .86878 L
.04808 .8603 L
.05643 .85044 L
.06579 .8393 L
.07605 .82697 L
.08709 .81354 L
.09879 .79911 L
.11101 .7838 L
.1236 .76772 L
.13641 .75098 L
.1493 .73368 L
.16212 .71593 L
.17471 .69784 L
.18692 .67949 L
.19862 .66096 L
.20967 .64234 L
.21993 .62367 L
.22929 .60502 L
.23763 .58641 L
.24486 .56787 L
.2509 .54941 L
.25567 .53102 L
.25912 .5127 L
.26121 .49443 L
.2619 .47626 L
s
P
P
p
P
p
p
.004 w
.7381 .47612 m
.73879 .45795 L
.74088 .43968 L
.74433 .42136 L
.7491 .40297 L
.75514 .38451 L
.76237 .36597 L
.77071 .34736 L
.78007 .32871 L
.79033 .31004 L
.80138 .29142 L
.81308 .2729 L
.82529 .25454 L
.83788 .23645 L
.8507 .2187 L
.86359 .20141 L
.8764 .18466 L
.88899 .16858 L
.90121 .15327 L
.91291 .13885 L
.92395 .12541 L
.93421 .11308 L
.94357 .10194 L
.95192 .09208 L
.95915 .0836 L
.96519 .07655 L
.96996 .07101 L
.97341 .06701 L
.97549 .0646 L
.97619 .0638 L
s
P
p
.004 w
.7381 .47626 m
.73879 .49443 L
.74088 .5127 L
.74433 .53102 L
.7491 .54941 L
.75514 .56787 L
.76237 .58641 L
.77071 .60502 L
.78007 .62367 L
.79033 .64234 L
.80138 .66096 L
.81308 .67949 L
.82529 .69784 L
.83788 .71593 L
.8507 .73368 L
.86359 .75098 L
.8764 .76772 L
.88899 .7838 L
.90121 .79911 L
.91291 .81354 L
.92395 .82697 L
.93421 .8393 L
.94357 .85044 L
.95192 .8603 L
.95915 .86878 L
.96519 .87583 L
.96996 .88137 L
.97341 .88537 L
.97549 .88778 L
.97619 .88858 L
s
P
P
P
p
p
p
.004 w
.02381 .16122 m
.02416 .16175 L
.0252 .16333 L
.02693 .16595 L
.02931 .1696 L
.03233 .17426 L
.03595 .17989 L
.04012 .18647 L
.0448 .19395 L
.04993 .20231 L
.05545 .21148 L
.0613 .22142 L
.06741 .23209 L
.0737 .24343 L
.08011 .25538 L
.08656 .2679 L
.09296 .28093 L
.09926 .29441 L
.10537 .30831 L
.11121 .32256 L
.11674 .33712 L
.12187 .35196 L
.12655 .36703 L
.13072 .38229 L
.13434 .39771 L
.13736 .41326 L
.13974 .42891 L
.14147 .44463 L
.14251 .4604 L
.14286 .47611 L
s
P
p
.004 w
.02381 .79116 m
.02416 .79063 L
.0252 .78905 L
.02693 .78643 L
.02931 .78278 L
.03233 .77812 L
.03595 .77249 L
.04012 .76591 L
.0448 .75843 L
.04993 .75007 L
.05545 .7409 L
.0613 .73096 L
.06741 .72029 L
.0737 .70895 L
.08011 .697 L
.08656 .68448 L
.09296 .67145 L
.09926 .65797 L
.10537 .64408 L
.11121 .62982 L
.11674 .61526 L
.12187 .60042 L
.12655 .58535 L
.13072 .57009 L
.13434 .55467 L
.13736 .53912 L
.13974 .52347 L
.14147 .50775 L
.14251 .49198 L
.14286 .47627 L
s
P
P
p
P
p
p
.004 w
.85714 .47611 m
.85749 .4604 L
.85853 .44463 L
.86026 .42891 L
.86264 .41326 L
.86566 .39771 L
.86928 .38229 L
.87345 .36703 L
.87813 .35196 L
.88326 .33712 L
.88879 .32256 L
.89463 .30831 L
.90074 .29441 L
.90704 .28093 L
.91344 .2679 L
.91989 .25538 L
.9263 .24343 L
.93259 .23209 L
.9387 .22142 L
.94455 .21148 L
.95007 .20231 L
.9552 .19395 L
.95988 .18647 L
.96405 .17989 L
.96767 .17426 L
.97069 .1696 L
.97307 .16595 L
.9748 .16333 L
.97584 .16175 L
.97619 .16122 L
s
P
p
.004 w
.85714 .47627 m
.85749 .49198 L
.85853 .50775 L
.86026 .52347 L
.86264 .53912 L
.86566 .55467 L
.86928 .57009 L
.87345 .58535 L
.87813 .60042 L
.88326 .61526 L
.88879 .62982 L
.89463 .64408 L
.90074 .65797 L
.90704 .67145 L
.91344 .68448 L
.91989 .697 L
.9263 .70895 L
.93259 .72029 L
.9387 .73096 L
.94455 .7409 L
.95007 .75007 L
.9552 .75843 L
.95988 .76591 L
.96405 .77249 L
.96767 .77812 L
.97069 .78278 L
.97307 .78643 L
.9748 .78905 L
.97584 .79063 L
.97619 .79116 L
s
P
P
P
p
p
p
.004 w
s
s
s
.03893 0 m
.04874 .00949 L
s
.04874 .00949 m
.06782 .02792 L
.09197 .05115 L
.12091 .07885 L
.15429 .11056 L
.19172 .14572 L
.23277 .18364 L
.27695 .22336 L
.32374 .2635 L
.37261 .30183 L
.42296 .33439 L
.47422 .35438 L
.52578 .35438 L
.57704 .33439 L
.62739 .30183 L
.67626 .2635 L
.72305 .22336 L
.76723 .18364 L
.80828 .14572 L
.84571 .11056 L
.87909 .07885 L
.90803 .05115 L
.93218 .02792 L
.95126 .00949 L
s
.96107 0 m
.95126 .00949 L
s
s
s
s
P
p
.004 w
s
s
s
.03893 .95238 m
.04874 .94289 L
s
.04874 .94289 m
.06782 .92447 L
.09197 .90123 L
.12091 .87354 L
.15429 .84183 L
.19172 .80666 L
.23277 .76874 L
.27695 .72902 L
.32374 .68888 L
.37261 .65055 L
.42296 .61799 L
.47422 .598 L
.52578 .598 L
.57704 .61799 L
.62739 .65055 L
.67626 .68888 L
.72305 .72902 L
.76723 .76874 L
.80828 .80666 L
.84571 .84183 L
.87909 .87354 L
.90803 .90123 L
.93218 .92447 L
.95126 .94289 L
s
.96107 .95238 m
.95126 .94289 L
s
s
s
s
P
P
P
p
p
p
.004 w
s
s
s
s
s
.08763 0 m
.09197 .00378 L
s
.09197 .00378 m
.12091 .02853 L
.15429 .05642 L
.19172 .08667 L
.23277 .11828 L
.27695 .14994 L
.32374 .17995 L
.37261 .20616 L
.42296 .22594 L
.47422 .2367 L
.52578 .2367 L
.57704 .22594 L
.62739 .20616 L
.67626 .17995 L
.72305 .14994 L
.76723 .11828 L
.80828 .08667 L
.84571 .05642 L
.87909 .02853 L
.90803 .00378 L
s
.91237 0 m
.90803 .00378 L
s
s
s
s
s
s
P
p
.004 w
s
s
s
s
s
.08763 .95238 m
.09197 .94861 L
s
.09197 .94861 m
.12091 .92385 L
.15429 .89596 L
.19172 .86571 L
.23277 .8341 L
.27695 .80244 L
.32374 .77243 L
.37261 .74623 L
.42296 .72644 L
.47422 .71568 L
.52578 .71568 L
.57704 .72644 L
.62739 .74623 L
.67626 .77243 L
.72305 .80244 L
.76723 .8341 L
.80828 .86571 L
.84571 .89596 L
.87909 .92385 L
.90803 .94861 L
s
.91237 .95238 m
.90803 .94861 L
s
s
s
s
s
s
P
P
P
p
p
p
.004 w
s
s
s
s
s
s
s
s
.1852 0 m
.19172 .0044 L
s
.19172 .0044 m
.23277 .03014 L
.27695 .05512 L
.32374 .07792 L
.37261 .09701 L
.42296 .11083 L
.47422 .11812 L
.52578 .11812 L
.57704 .11083 L
.62739 .09701 L
.67626 .07792 L
.72305 .05512 L
.76723 .03014 L
.80828 .0044 L
s
.8148 0 m
.80828 .0044 L
s
s
s
s
s
s
s
s
s
P
p
.004 w
s
s
s
s
s
s
s
s
.1852 .95238 m
.19172 .94798 L
s
.19172 .94798 m
.23277 .92224 L
.27695 .89726 L
.32374 .87446 L
.37261 .85537 L
.42296 .84155 L
.47422 .83426 L
.52578 .83426 L
.57704 .84155 L
.62739 .85537 L
.67626 .87446 L
.72305 .89726 L
.76723 .92224 L
.80828 .94798 L
s
.8148 .95238 m
.80828 .94798 L
s
s
s
s
s
s
s
s
s
P
P
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{223, 211},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCacheValid->False]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(\(Show[hp1, hp2]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95238 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.47619 0.119048 [
[(-4)] .02381 .47619 0 2 Msboxa
[(-2)] .2619 .47619 0 2 Msboxa
[(2)] .7381 .47619 0 2 Msboxa
[(4)] .97619 .47619 0 2 Msboxa
[(-4)] .4875 0 1 0 Msboxa
[(-3)] .4875 .11905 1 0 Msboxa
[(-2)] .4875 .2381 1 0 Msboxa
[(-1)] .4875 .35714 1 0 Msboxa
[(1)] .4875 .59524 1 0 Msboxa
[(2)] .4875 .71429 1 0 Msboxa
[(3)] .4875 .83333 1 0 Msboxa
[(4)] .4875 .95238 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .95338 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 .47619 m
.02381 .48244 L
s
P
[(-4)] .02381 .47619 0 2 Mshowa
p
.002 w
.2619 .47619 m
.2619 .48244 L
s
P
[(-2)] .2619 .47619 0 2 Mshowa
p
.002 w
.7381 .47619 m
.7381 .48244 L
s
P
[(2)] .7381 .47619 0 2 Mshowa
p
.002 w
.97619 .47619 m
.97619 .48244 L
s
P
[(4)] .97619 .47619 0 2 Mshowa
p
.001 w
.07143 .47619 m
.07143 .47994 L
s
P
p
.001 w
.11905 .47619 m
.11905 .47994 L
s
P
p
.001 w
.16667 .47619 m
.16667 .47994 L
s
P
p
.001 w
.21429 .47619 m
.21429 .47994 L
s
P
p
.001 w
.30952 .47619 m
.30952 .47994 L
s
P
p
.001 w
.35714 .47619 m
.35714 .47994 L
s
P
p
.001 w
.40476 .47619 m
.40476 .47994 L
s
P
p
.001 w
.45238 .47619 m
.45238 .47994 L
s
P
p
.001 w
.54762 .47619 m
.54762 .47994 L
s
P
p
.001 w
.59524 .47619 m
.59524 .47994 L
s
P
p
.001 w
.64286 .47619 m
.64286 .47994 L
s
P
p
.001 w
.69048 .47619 m
.69048 .47994 L
s
P
p
.001 w
.78571 .47619 m
.78571 .47994 L
s
P
p
.001 w
.83333 .47619 m
.83333 .47994 L
s
P
p
.001 w
.88095 .47619 m
.88095 .47994 L
s
P
p
.001 w
.92857 .47619 m
.92857 .47994 L
s
P
p
.002 w
0 .47619 m
1 .47619 L
s
P
p
.002 w
.5 0 m
.50625 0 L
s
P
[(-4)] .4875 0 1 0 Mshowa
p
.002 w
.5 .11905 m
.50625 .11905 L
s
P
[(-3)] .4875 .11905 1 0 Mshowa
p
.002 w
.5 .2381 m
.50625 .2381 L
s
P
[(-2)] .4875 .2381 1 0 Mshowa
p
.002 w
.5 .35714 m
.50625 .35714 L
s
P
[(-1)] .4875 .35714 1 0 Mshowa
p
.002 w
.5 .59524 m
.50625 .59524 L
s
P
[(1)] .4875 .59524 1 0 Mshowa
p
.002 w
.5 .71429 m
.50625 .71429 L
s
P
[(2)] .4875 .71429 1 0 Mshowa
p
.002 w
.5 .83333 m
.50625 .83333 L
s
P
[(3)] .4875 .83333 1 0 Mshowa
p
.002 w
.5 .95238 m
.50625 .95238 L
s
P
[(4)] .4875 .95238 1 0 Mshowa
p
.001 w
.5 .02381 m
.50375 .02381 L
s
P
p
.001 w
.5 .04762 m
.50375 .04762 L
s
P
p
.001 w
.5 .07143 m
.50375 .07143 L
s
P
p
.001 w
.5 .09524 m
.50375 .09524 L
s
P
p
.001 w
.5 .14286 m
.50375 .14286 L
s
P
p
.001 w
.5 .16667 m
.50375 .16667 L
s
P
p
.001 w
.5 .19048 m
.50375 .19048 L
s
P
p
.001 w
.5 .21429 m
.50375 .21429 L
s
P
p
.001 w
.5 .2619 m
.50375 .2619 L
s
P
p
.001 w
.5 .28571 m
.50375 .28571 L
s
P
p
.001 w
.5 .30952 m
.50375 .30952 L
s
P
p
.001 w
.5 .33333 m
.50375 .33333 L
s
P
p
.001 w
.5 .38095 m
.50375 .38095 L
s
P
p
.001 w
.5 .40476 m
.50375 .40476 L
s
P
p
.001 w
.5 .42857 m
.50375 .42857 L
s
P
p
.001 w
.5 .45238 m
.50375 .45238 L
s
P
p
.001 w
.5 .5 m
.50375 .5 L
s
P
p
.001 w
.5 .52381 m
.50375 .52381 L
s
P
p
.001 w
.5 .54762 m
.50375 .54762 L
s
P
p
.001 w
.5 .57143 m
.50375 .57143 L
s
P
p
.001 w
.5 .61905 m
.50375 .61905 L
s
P
p
.001 w
.5 .64286 m
.50375 .64286 L
s
P
p
.001 w
.5 .66667 m
.50375 .66667 L
s
P
p
.001 w
.5 .69048 m
.50375 .69048 L
s
P
p
.001 w
.5 .7381 m
.50375 .7381 L
s
P
p
.001 w
.5 .7619 m
.50375 .7619 L
s
P
p
.001 w
.5 .78571 m
.50375 .78571 L
s
P
p
.001 w
.5 .80952 m
.50375 .80952 L
s
P
p
.001 w
.5 .85714 m
.50375 .85714 L
s
P
p
.001 w
.5 .88095 m
.50375 .88095 L
s
P
p
.001 w
.5 .90476 m
.50375 .90476 L
s
P
p
.001 w
.5 .92857 m
.50375 .92857 L
s
P
p
.002 w
.5 0 m
.5 .95238 L
s
P
P
0 0 m
1 0 L
1 .95238 L
0 .95238 L
closepath
clip
newpath
p
p
p
p
p
.004 w
.02381 .74405 m
.02521 .74484 L
.02938 .74722 L
.03627 .75125 L
.04582 .75703 L
.05789 .7647 L
.07236 .77446 L
.08905 .78657 L
.10777 .80138 L
.12829 .81934 L
.15038 .84102 L
.17378 .86718 L
.19821 .89884 L
.22339 .9373 L
s
.23159 .95238 m
.22339 .9373 L
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
P
P
p
p
.004 w
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
.76841 0 m
.77661 .01508 L
s
.77661 .01508 m
.80179 .05355 L
.82622 .0852 L
.84962 .11136 L
.87171 .13304 L
.89223 .151 L
.91095 .16581 L
.92764 .17792 L
.94211 .18768 L
.95418 .19536 L
.96373 .20113 L
.97062 .20517 L
.97479 .20755 L
.97619 .20833 L
s
P
P
P
p
p
p
.004 w
.02381 .59524 m
.02521 .59559 L
.02938 .59665 L
.03627 .59844 L
.04582 .60101 L
.05789 .60442 L
.07236 .60875 L
.08905 .61414 L
.10777 .62072 L
.12829 .6287 L
.15038 .63834 L
.17378 .64997 L
.19821 .66403 L
.22339 .68113 L
.24901 .70206 L
.27479 .72791 L
.30042 .76024 L
.3256 .80125 L
.35003 .8542 L
.37343 .92408 L
s
.38003 .95238 m
.37343 .92408 L
s
s
s
s
s
s
s
s
s
s
s
P
P
p
p
.004 w
s
s
s
s
s
s
s
s
s
s
.61997 0 m
.62657 .0283 L
s
.62657 .0283 m
.64997 .09818 L
.6744 .15113 L
.69958 .19214 L
.72521 .22447 L
.75099 .25032 L
.77661 .27125 L
.80179 .28835 L
.82622 .30242 L
.84962 .31405 L
.87171 .32368 L
.89223 .33166 L
.91095 .33824 L
.92764 .34363 L
.94211 .34797 L
.95418 .35137 L
.96373 .35394 L
.97062 .35573 L
.97479 .35679 L
.97619 .35714 L
s
P
P
P
p
p
p
.004 w
.02381 .50595 m
.02521 .50604 L
.02938 .5063 L
.03627 .50675 L
.04582 .50739 L
.05789 .50825 L
.07236 .50933 L
.08905 .51068 L
.10777 .51232 L
.12829 .51432 L
.15038 .51673 L
.17378 .51963 L
.19821 .52315 L
.22339 .52743 L
.24901 .53266 L
.27479 .53912 L
.30042 .5472 L
.3256 .55745 L
.35003 .57069 L
.37343 .58816 L
.39552 .61184 L
.41604 .645 L
.43476 .69343 L
.45145 .76811 L
.46592 .89203 L
s
.46911 .95238 m
.46592 .89203 L
s
s
s
s
s
s
P
P
p
p
.004 w
s
s
s
s
s
.53089 0 m
.53408 .06036 L
s
.53408 .06036 m
.54855 .18427 L
.56524 .25895 L
.58396 .30738 L
.60448 .34054 L
.62657 .36422 L
.64997 .38169 L
.6744 .39493 L
.69958 .40518 L
.72521 .41326 L
.75099 .41972 L
.77661 .42496 L
.80179 .42923 L
.82622 .43275 L
.84962 .43565 L
.87171 .43806 L
.89223 .44006 L
.91095 .4417 L
.92764 .44305 L
.94211 .44413 L
.95418 .44499 L
.96373 .44563 L
.97062 .44608 L
.97479 .44634 L
.97619 .44643 L
s
P
P
P
p
p
p
.004 w
.02381 .44643 m
.02521 .44634 L
.02938 .44608 L
.03627 .44563 L
.04582 .44499 L
.05789 .44413 L
.07236 .44305 L
.08905 .4417 L
.10777 .44006 L
.12829 .43806 L
.15038 .43565 L
.17378 .43275 L
.19821 .42923 L
.22339 .42496 L
.24901 .41972 L
.27479 .41326 L
.30042 .40518 L
.3256 .39493 L
.35003 .38169 L
.37343 .36422 L
.39552 .34054 L
.41604 .30738 L
.43476 .25895 L
.45145 .18427 L
.46592 .06036 L
s
.46911 0 m
.46592 .06036 L
s
s
s
s
s
s
P
P
p
p
.004 w
s
s
s
s
s
.53089 .95238 m
.53408 .89203 L
s
.53408 .89203 m
.54855 .76811 L
.56524 .69343 L
.58396 .645 L
.60448 .61184 L
.62657 .58816 L
.64997 .57069 L
.6744 .55745 L
.69958 .5472 L
.72521 .53912 L
.75099 .53266 L
.77661 .52743 L
.80179 .52315 L
.82622 .51963 L
.84962 .51673 L
.87171 .51432 L
.89223 .51232 L
.91095 .51068 L
.92764 .50933 L
.94211 .50825 L
.95418 .50739 L
.96373 .50675 L
.97062 .5063 L
.97479 .50604 L
.97619 .50595 L
s
P
P
P
p
p
p
.004 w
.02381 .35714 m
.02521 .35679 L
.02938 .35573 L
.03627 .35394 L
.04582 .35137 L
.05789 .34797 L
.07236 .34363 L
.08905 .33824 L
.10777 .33166 L
.12829 .32368 L
.15038 .31405 L
.17378 .30242 L
.19821 .28835 L
.22339 .27125 L
.24901 .25032 L
.27479 .22447 L
.30042 .19214 L
.3256 .15113 L
.35003 .09818 L
.37343 .0283 L
s
.38003 0 m
.37343 .0283 L
s
s
s
s
s
s
s
s
s
s
s
P
P
p
p
.004 w
s
s
s
s
s
s
s
s
s
s
.61997 .95238 m
.62657 .92408 L
s
.62657 .92408 m
.64997 .8542 L
.6744 .80125 L
.69958 .76024 L
.72521 .72791 L
.75099 .70206 L
.77661 .68113 L
.80179 .66403 L
.82622 .64997 L
.84962 .63834 L
.87171 .6287 L
.89223 .62072 L
.91095 .61414 L
.92764 .60875 L
.94211 .60442 L
.95418 .60101 L
.96373 .59844 L
.97062 .59665 L
.97479 .59559 L
.97619 .59524 L
s
P
P
P
p
p
p
.004 w
.02381 .20833 m
.02521 .20755 L
.02938 .20517 L
.03627 .20113 L
.04582 .19536 L
.05789 .18768 L
.07236 .17792 L
.08905 .16581 L
.10777 .151 L
.12829 .13304 L
.15038 .11136 L
.17378 .0852 L
.19821 .05355 L
.22339 .01508 L
s
.23159 0 m
.22339 .01508 L
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
P
P
p
p
.004 w
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
.76841 .95238 m
.77661 .9373 L
s
.77661 .9373 m
.80179 .89884 L
.82622 .86718 L
.84962 .84102 L
.87171 .81934 L
.89223 .80138 L
.91095 .78657 L
.92764 .77446 L
.94211 .7647 L
.95418 .75703 L
.96373 .75125 L
.97062 .74722 L
.97479 .74484 L
.97619 .74405 L
s
P
P
P
P
p
p
p
p
.004 w
.02381 0 m
.02521 .0014 L
.02938 .00557 L
.03627 .01246 L
.04582 .02201 L
.05789 .03408 L
.07236 .04855 L
.08905 .06524 L
.10777 .08396 L
.12829 .10448 L
.15038 .12657 L
.17378 .14997 L
.19821 .1744 L
.22339 .19958 L
.24901 .22521 L
.27479 .25099 L
.30042 .27661 L
.3256 .30179 L
.35003 .32622 L
.37343 .34962 L
.39552 .37171 L
.41604 .39223 L
.43476 .41095 L
.45145 .42764 L
.46592 .44211 L
.47799 .45418 L
.48754 .46373 L
.49443 .47062 L
.4986 .47479 L
.5 .47619 L
s
P
p
.004 w
.02381 .95238 m
.02521 .95099 L
.02938 .94681 L
.03627 .93992 L
.04582 .93038 L
.05789 .9183 L
.07236 .90383 L
.08905 .88714 L
.10777 .86843 L
.12829 .8479 L
.15038 .82581 L
.17378 .80241 L
.19821 .77798 L
.22339 .75281 L
.24901 .72718 L
.27479 .7014 L
.30042 .67577 L
.3256 .65059 L
.35003 .62616 L
.37343 .60276 L
.39552 .58067 L
.41604 .56015 L
.43476 .54143 L
.45145 .52474 L
.46592 .51027 L
.47799 .4982 L
.48754 .48865 L
.49443 .48176 L
.4986 .47759 L
.5 .47619 L
s
P
P
p
p
.004 w
.5 .47619 m
.5014 .47479 L
.50557 .47062 L
.51246 .46373 L
.52201 .45418 L
.53408 .44211 L
.54855 .42764 L
.56524 .41095 L
.58396 .39223 L
.60448 .37171 L
.62657 .34962 L
.64997 .32622 L
.6744 .30179 L
.69958 .27661 L
.72521 .25099 L
.75099 .22521 L
.77661 .19958 L
.80179 .1744 L
.82622 .14997 L
.84962 .12657 L
.87171 .10448 L
.89223 .08396 L
.91095 .06524 L
.92764 .04855 L
.94211 .03408 L
.95418 .02201 L
.96373 .01246 L
.97062 .00557 L
.97479 .0014 L
.97619 0 L
s
P
p
.004 w
.5 .47619 m
.5014 .47759 L
.50557 .48176 L
.51246 .48865 L
.52201 .4982 L
.53408 .51027 L
.54855 .52474 L
.56524 .54143 L
.58396 .56015 L
.60448 .58067 L
.62657 .60276 L
.64997 .62616 L
.6744 .65059 L
.69958 .67577 L
.72521 .7014 L
.75099 .72718 L
.77661 .75281 L
.80179 .77798 L
.82622 .80241 L
.84962 .82581 L
.87171 .8479 L
.89223 .86843 L
.91095 .88714 L
.92764 .90383 L
.94211 .9183 L
.95418 .93038 L
.96373 .93992 L
.97062 .94681 L
.97479 .95099 L
.97619 .95238 L
s
P
P
P
p
p
p
.004 w
.02381 .01512 m
.02486 .0162 L
.02798 .01943 L
.03316 .02478 L
.04031 .03219 L
.04937 .04157 L
.06022 .05283 L
.07274 .06585 L
.08678 .08049 L
.10217 .09659 L
.11874 .11399 L
.13628 .13251 L
.15461 .15196 L
.17349 .17216 L
.19271 .1929 L
.21205 .214 L
.23127 .23527 L
.25015 .25653 L
.26848 .27762 L
.28603 .29839 L
.30259 .31872 L
.31799 .33851 L
.33202 .35768 L
.34454 .37621 L
.35539 .3941 L
.36445 .41137 L
.3716 .4281 L
.37678 .44439 L
.37991 .46037 L
.38095 .47614 L
s
P
p
.004 w
.02381 .93726 m
.02486 .93618 L
.02798 .93295 L
.03316 .9276 L
.04031 .92019 L
.04937 .91081 L
.06022 .89955 L
.07274 .88653 L
.08678 .87189 L
.10217 .85579 L
.11874 .83839 L
.13628 .81987 L
.15461 .80042 L
.17349 .78022 L
.19271 .75948 L
.21205 .73838 L
.23127 .71711 L
.25015 .69585 L
.26848 .67476 L
.28603 .65399 L
.30259 .63366 L
.31799 .61387 L
.33202 .5947 L
.34454 .57617 L
.35539 .55828 L
.36445 .54101 L
.3716 .52428 L
.37678 .50799 L
.37991 .49201 L
.38095 .47624 L
s
P
P
p
P
p
p
.004 w
.61905 .47614 m
.62009 .46037 L
.62322 .44439 L
.6284 .4281 L
.63555 .41137 L
.64461 .3941 L
.65546 .37621 L
.66798 .35768 L
.68201 .33851 L
.69741 .31872 L
.71397 .29839 L
.73152 .27762 L
.74985 .25653 L
.76873 .23527 L
.78795 .214 L
.80729 .1929 L
.82651 .17216 L
.84539 .15196 L
.86372 .13251 L
.88126 .11399 L
.89783 .09659 L
.91322 .08049 L
.92726 .06585 L
.93978 .05283 L
.95063 .04157 L
.95969 .03219 L
.96684 .02478 L
.97202 .01943 L
.97514 .0162 L
.97619 .01512 L
s
P
p
.004 w
.61905 .47624 m
.62009 .49201 L
.62322 .50799 L
.6284 .52428 L
.63555 .54101 L
.64461 .55828 L
.65546 .57617 L
.66798 .5947 L
.68201 .61387 L
.69741 .63366 L
.71397 .65399 L
.73152 .67476 L
.74985 .69585 L
.76873 .71711 L
.78795 .73838 L
.80729 .75948 L
.82651 .78022 L
.84539 .80042 L
.86372 .81987 L
.88126 .83839 L
.89783 .85579 L
.91322 .87189 L
.92726 .88653 L
.93978 .89955 L
.95063 .91081 L
.95969 .92019 L
.96684 .9276 L
.97202 .93295 L
.97514 .93618 L
.97619 .93726 L
s
P
P
P
p
p
p
.004 w
.02381 .0638 m
.02451 .0646 L
.02659 .06701 L
.03004 .07101 L
.03481 .07655 L
.04085 .0836 L
.04808 .09208 L
.05643 .10194 L
.06579 .11308 L
.07605 .12541 L
.08709 .13885 L
.09879 .15327 L
.11101 .16858 L
.1236 .18466 L
.13641 .20141 L
.1493 .2187 L
.16212 .23645 L
.17471 .25454 L
.18692 .2729 L
.19862 .29142 L
.20967 .31004 L
.21993 .32871 L
.22929 .34736 L
.23763 .36597 L
.24486 .38451 L
.2509 .40297 L
.25567 .42136 L
.25912 .43968 L
.26121 .45795 L
.2619 .47612 L
s
P
p
.004 w
.02381 .88858 m
.02451 .88778 L
.02659 .88537 L
.03004 .88137 L
.03481 .87583 L
.04085 .86878 L
.04808 .8603 L
.05643 .85044 L
.06579 .8393 L
.07605 .82697 L
.08709 .81354 L
.09879 .79911 L
.11101 .7838 L
.1236 .76772 L
.13641 .75098 L
.1493 .73368 L
.16212 .71593 L
.17471 .69784 L
.18692 .67949 L
.19862 .66096 L
.20967 .64234 L
.21993 .62367 L
.22929 .60502 L
.23763 .58641 L
.24486 .56787 L
.2509 .54941 L
.25567 .53102 L
.25912 .5127 L
.26121 .49443 L
.2619 .47626 L
s
P
P
p
P
p
p
.004 w
.7381 .47612 m
.73879 .45795 L
.74088 .43968 L
.74433 .42136 L
.7491 .40297 L
.75514 .38451 L
.76237 .36597 L
.77071 .34736 L
.78007 .32871 L
.79033 .31004 L
.80138 .29142 L
.81308 .2729 L
.82529 .25454 L
.83788 .23645 L
.8507 .2187 L
.86359 .20141 L
.8764 .18466 L
.88899 .16858 L
.90121 .15327 L
.91291 .13885 L
.92395 .12541 L
.93421 .11308 L
.94357 .10194 L
.95192 .09208 L
.95915 .0836 L
.96519 .07655 L
.96996 .07101 L
.97341 .06701 L
.97549 .0646 L
.97619 .0638 L
s
P
p
.004 w
.7381 .47626 m
.73879 .49443 L
.74088 .5127 L
.74433 .53102 L
.7491 .54941 L
.75514 .56787 L
.76237 .58641 L
.77071 .60502 L
.78007 .62367 L
.79033 .64234 L
.80138 .66096 L
.81308 .67949 L
.82529 .69784 L
.83788 .71593 L
.8507 .73368 L
.86359 .75098 L
.8764 .76772 L
.88899 .7838 L
.90121 .79911 L
.91291 .81354 L
.92395 .82697 L
.93421 .8393 L
.94357 .85044 L
.95192 .8603 L
.95915 .86878 L
.96519 .87583 L
.96996 .88137 L
.97341 .88537 L
.97549 .88778 L
.97619 .88858 L
s
P
P
P
p
p
p
.004 w
.02381 .16122 m
.02416 .16175 L
.0252 .16333 L
.02693 .16595 L
.02931 .1696 L
.03233 .17426 L
.03595 .17989 L
.04012 .18647 L
.0448 .19395 L
.04993 .20231 L
.05545 .21148 L
.0613 .22142 L
.06741 .23209 L
.0737 .24343 L
.08011 .25538 L
.08656 .2679 L
.09296 .28093 L
.09926 .29441 L
.10537 .30831 L
.11121 .32256 L
.11674 .33712 L
.12187 .35196 L
.12655 .36703 L
.13072 .38229 L
.13434 .39771 L
.13736 .41326 L
.13974 .42891 L
.14147 .44463 L
.14251 .4604 L
.14286 .47611 L
s
P
p
.004 w
.02381 .79116 m
.02416 .79063 L
.0252 .78905 L
.02693 .78643 L
.02931 .78278 L
.03233 .77812 L
.03595 .77249 L
.04012 .76591 L
.0448 .75843 L
.04993 .75007 L
.05545 .7409 L
.0613 .73096 L
.06741 .72029 L
.0737 .70895 L
.08011 .697 L
.08656 .68448 L
.09296 .67145 L
.09926 .65797 L
.10537 .64408 L
.11121 .62982 L
.11674 .61526 L
.12187 .60042 L
.12655 .58535 L
.13072 .57009 L
.13434 .55467 L
.13736 .53912 L
.13974 .52347 L
.14147 .50775 L
.14251 .49198 L
.14286 .47627 L
s
P
P
p
P
p
p
.004 w
.85714 .47611 m
.85749 .4604 L
.85853 .44463 L
.86026 .42891 L
.86264 .41326 L
.86566 .39771 L
.86928 .38229 L
.87345 .36703 L
.87813 .35196 L
.88326 .33712 L
.88879 .32256 L
.89463 .30831 L
.90074 .29441 L
.90704 .28093 L
.91344 .2679 L
.91989 .25538 L
.9263 .24343 L
.93259 .23209 L
.9387 .22142 L
.94455 .21148 L
.95007 .20231 L
.9552 .19395 L
.95988 .18647 L
.96405 .17989 L
.96767 .17426 L
.97069 .1696 L
.97307 .16595 L
.9748 .16333 L
.97584 .16175 L
.97619 .16122 L
s
P
p
.004 w
.85714 .47627 m
.85749 .49198 L
.85853 .50775 L
.86026 .52347 L
.86264 .53912 L
.86566 .55467 L
.86928 .57009 L
.87345 .58535 L
.87813 .60042 L
.88326 .61526 L
.88879 .62982 L
.89463 .64408 L
.90074 .65797 L
.90704 .67145 L
.91344 .68448 L
.91989 .697 L
.9263 .70895 L
.93259 .72029 L
.9387 .73096 L
.94455 .7409 L
.95007 .75007 L
.9552 .75843 L
.95988 .76591 L
.96405 .77249 L
.96767 .77812 L
.97069 .78278 L
.97307 .78643 L
.9748 .78905 L
.97584 .79063 L
.97619 .79116 L
s
P
P
P
p
p
p
.004 w
s
s
s
.03893 0 m
.04874 .00949 L
s
.04874 .00949 m
.06782 .02792 L
.09197 .05115 L
.12091 .07885 L
.15429 .11056 L
.19172 .14572 L
.23277 .18364 L
.27695 .22336 L
.32374 .2635 L
.37261 .30183 L
.42296 .33439 L
.47422 .35438 L
.52578 .35438 L
.57704 .33439 L
.62739 .30183 L
.67626 .2635 L
.72305 .22336 L
.76723 .18364 L
.80828 .14572 L
.84571 .11056 L
.87909 .07885 L
.90803 .05115 L
.93218 .02792 L
.95126 .00949 L
s
.96107 0 m
.95126 .00949 L
s
s
s
s
P
p
.004 w
s
s
s
.03893 .95238 m
.04874 .94289 L
s
.04874 .94289 m
.06782 .92447 L
.09197 .90123 L
.12091 .87354 L
.15429 .84183 L
.19172 .80666 L
.23277 .76874 L
.27695 .72902 L
.32374 .68888 L
.37261 .65055 L
.42296 .61799 L
.47422 .598 L
.52578 .598 L
.57704 .61799 L
.62739 .65055 L
.67626 .68888 L
.72305 .72902 L
.76723 .76874 L
.80828 .80666 L
.84571 .84183 L
.87909 .87354 L
.90803 .90123 L
.93218 .92447 L
.95126 .94289 L
s
.96107 .95238 m
.95126 .94289 L
s
s
s
s
P
P
P
p
p
p
.004 w
s
s
s
s
s
.08763 0 m
.09197 .00378 L
s
.09197 .00378 m
.12091 .02853 L
.15429 .05642 L
.19172 .08667 L
.23277 .11828 L
.27695 .14994 L
.32374 .17995 L
.37261 .20616 L
.42296 .22594 L
.47422 .2367 L
.52578 .2367 L
.57704 .22594 L
.62739 .20616 L
.67626 .17995 L
.72305 .14994 L
.76723 .11828 L
.80828 .08667 L
.84571 .05642 L
.87909 .02853 L
.90803 .00378 L
s
.91237 0 m
.90803 .00378 L
s
s
s
s
s
s
P
p
.004 w
s
s
s
s
s
.08763 .95238 m
.09197 .94861 L
s
.09197 .94861 m
.12091 .92385 L
.15429 .89596 L
.19172 .86571 L
.23277 .8341 L
.27695 .80244 L
.32374 .77243 L
.37261 .74623 L
.42296 .72644 L
.47422 .71568 L
.52578 .71568 L
.57704 .72644 L
.62739 .74623 L
.67626 .77243 L
.72305 .80244 L
.76723 .8341 L
.80828 .86571 L
.84571 .89596 L
.87909 .92385 L
.90803 .94861 L
s
.91237 .95238 m
.90803 .94861 L
s
s
s
s
s
s
P
P
P
p
p
p
.004 w
s
s
s
s
s
s
s
s
.1852 0 m
.19172 .0044 L
s
.19172 .0044 m
.23277 .03014 L
.27695 .05512 L
.32374 .07792 L
.37261 .09701 L
.42296 .11083 L
.47422 .11812 L
.52578 .11812 L
.57704 .11083 L
.62739 .09701 L
.67626 .07792 L
.72305 .05512 L
.76723 .03014 L
.80828 .0044 L
s
.8148 0 m
.80828 .0044 L
s
s
s
s
s
s
s
s
s
P
p
.004 w
s
s
s
s
s
s
s
s
.1852 .95238 m
.19172 .94798 L
s
.19172 .94798 m
.23277 .92224 L
.27695 .89726 L
.32374 .87446 L
.37261 .85537 L
.42296 .84155 L
.47422 .83426 L
.52578 .83426 L
.57704 .84155 L
.62739 .85537 L
.67626 .87446 L
.72305 .89726 L
.76723 .92224 L
.80828 .94798 L
s
.8148 .95238 m
.80828 .94798 L
s
s
s
s
s
s
s
s
s
P
P
P
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{223, 211},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCacheValid->False]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Example 3.3"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(cp1 = 
      ContourPlot[Exp[y] - Sin[x], {x, \(-3\), 3}, {y, \(-3\), 3}, 
        Contours \[Rule] 35, PlotPoints \[Rule] 30, 
        ContourShading \[Rule] False]\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% ContourGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.160256 0.5 0.160256 [
[(-3)] .01923 0 0 2 Msboxa
[(-2)] .17949 0 0 2 Msboxa
[(-1)] .33974 0 0 2 Msboxa
[(0)] .5 0 0 2 Msboxa
[(1)] .66026 0 0 2 Msboxa
[(2)] .82051 0 0 2 Msboxa
[(3)] .98077 0 0 2 Msboxa
[(-3)] -0.0125 .01923 1 0 Msboxa
[(-2)] -0.0125 .17949 1 0 Msboxa
[(-1)] -0.0125 .33974 1 0 Msboxa
[(0)] -0.0125 .5 1 0 Msboxa
[(1)] -0.0125 .66026 1 0 Msboxa
[(2)] -0.0125 .82051 1 0 Msboxa
[(3)] -0.0125 .98077 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.01923 0 m
.01923 .00625 L
s
P
[(-3)] .01923 0 0 2 Mshowa
p
.002 w
.17949 0 m
.17949 .00625 L
s
P
[(-2)] .17949 0 0 2 Mshowa
p
.002 w
.33974 0 m
.33974 .00625 L
s
P
[(-1)] .33974 0 0 2 Mshowa
p
.002 w
.5 0 m
.5 .00625 L
s
P
[(0)] .5 0 0 2 Mshowa
p
.002 w
.66026 0 m
.66026 .00625 L
s
P
[(1)] .66026 0 0 2 Mshowa
p
.002 w
.82051 0 m
.82051 .00625 L
s
P
[(2)] .82051 0 0 2 Mshowa
p
.002 w
.98077 0 m
.98077 .00625 L
s
P
[(3)] .98077 0 0 2 Mshowa
p
.001 w
.05128 0 m
.05128 .00375 L
s
P
p
.001 w
.08333 0 m
.08333 .00375 L
s
P
p
.001 w
.11538 0 m
.11538 .00375 L
s
P
p
.001 w
.14744 0 m
.14744 .00375 L
s
P
p
.001 w
.21154 0 m
.21154 .00375 L
s
P
p
.001 w
.24359 0 m
.24359 .00375 L
s
P
p
.001 w
.27564 0 m
.27564 .00375 L
s
P
p
.001 w
.30769 0 m
.30769 .00375 L
s
P
p
.001 w
.37179 0 m
.37179 .00375 L
s
P
p
.001 w
.40385 0 m
.40385 .00375 L
s
P
p
.001 w
.4359 0 m
.4359 .00375 L
s
P
p
.001 w
.46795 0 m
.46795 .00375 L
s
P
p
.001 w
.53205 0 m
.53205 .00375 L
s
P
p
.001 w
.5641 0 m
.5641 .00375 L
s
P
p
.001 w
.59615 0 m
.59615 .00375 L
s
P
p
.001 w
.62821 0 m
.62821 .00375 L
s
P
p
.001 w
.69231 0 m
.69231 .00375 L
s
P
p
.001 w
.72436 0 m
.72436 .00375 L
s
P
p
.001 w
.75641 0 m
.75641 .00375 L
s
P
p
.001 w
.78846 0 m
.78846 .00375 L
s
P
p
.001 w
.85256 0 m
.85256 .00375 L
s
P
p
.001 w
.88462 0 m
.88462 .00375 L
s
P
p
.001 w
.91667 0 m
.91667 .00375 L
s
P
p
.001 w
.94872 0 m
.94872 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01923 m
.00625 .01923 L
s
P
[(-3)] -0.0125 .01923 1 0 Mshowa
p
.002 w
0 .17949 m
.00625 .17949 L
s
P
[(-2)] -0.0125 .17949 1 0 Mshowa
p
.002 w
0 .33974 m
.00625 .33974 L
s
P
[(-1)] -0.0125 .33974 1 0 Mshowa
p
.002 w
0 .5 m
.00625 .5 L
s
P
[(0)] -0.0125 .5 1 0 Mshowa
p
.002 w
0 .66026 m
.00625 .66026 L
s
P
[(1)] -0.0125 .66026 1 0 Mshowa
p
.002 w
0 .82051 m
.00625 .82051 L
s
P
[(2)] -0.0125 .82051 1 0 Mshowa
p
.002 w
0 .98077 m
.00625 .98077 L
s
P
[(3)] -0.0125 .98077 1 0 Mshowa
p
.001 w
0 .05128 m
.00375 .05128 L
s
P
p
.001 w
0 .08333 m
.00375 .08333 L
s
P
p
.001 w
0 .11538 m
.00375 .11538 L
s
P
p
.001 w
0 .14744 m
.00375 .14744 L
s
P
p
.001 w
0 .21154 m
.00375 .21154 L
s
P
p
.001 w
0 .24359 m
.00375 .24359 L
s
P
p
.001 w
0 .27564 m
.00375 .27564 L
s
P
p
.001 w
0 .30769 m
.00375 .30769 L
s
P
p
.001 w
0 .37179 m
.00375 .37179 L
s
P
p
.001 w
0 .40385 m
.00375 .40385 L
s
P
p
.001 w
0 .4359 m
.00375 .4359 L
s
P
p
.001 w
0 .46795 m
.00375 .46795 L
s
P
p
.001 w
0 .53205 m
.00375 .53205 L
s
P
p
.001 w
0 .5641 m
.00375 .5641 L
s
P
p
.001 w
0 .59615 m
.00375 .59615 L
s
P
p
.001 w
0 .62821 m
.00375 .62821 L
s
P
p
.001 w
0 .69231 m
.00375 .69231 L
s
P
p
.001 w
0 .72436 m
.00375 .72436 L
s
P
p
.001 w
0 .75641 m
.00375 .75641 L
s
P
p
.001 w
0 .78846 m
.00375 .78846 L
s
P
p
.001 w
0 .85256 m
.00375 .85256 L
s
P
p
.001 w
0 .88462 m
.00375 .88462 L
s
P
p
.001 w
0 .91667 m
.00375 .91667 L
s
P
p
.001 w
0 .94872 m
.00375 .94872 L
s
P
p
.002 w
0 0 m
0 1 L
s
P
P
p
p
.002 w
.01923 .99375 m
.01923 1 L
s
P
p
.002 w
.17949 .99375 m
.17949 1 L
s
P
p
.002 w
.33974 .99375 m
.33974 1 L
s
P
p
.002 w
.5 .99375 m
.5 1 L
s
P
p
.002 w
.66026 .99375 m
.66026 1 L
s
P
p
.002 w
.82051 .99375 m
.82051 1 L
s
P
p
.002 w
.98077 .99375 m
.98077 1 L
s
P
p
.001 w
.05128 .99625 m
.05128 1 L
s
P
p
.001 w
.08333 .99625 m
.08333 1 L
s
P
p
.001 w
.11538 .99625 m
.11538 1 L
s
P
p
.001 w
.14744 .99625 m
.14744 1 L
s
P
p
.001 w
.21154 .99625 m
.21154 1 L
s
P
p
.001 w
.24359 .99625 m
.24359 1 L
s
P
p
.001 w
.27564 .99625 m
.27564 1 L
s
P
p
.001 w
.30769 .99625 m
.30769 1 L
s
P
p
.001 w
.37179 .99625 m
.37179 1 L
s
P
p
.001 w
.40385 .99625 m
.40385 1 L
s
P
p
.001 w
.4359 .99625 m
.4359 1 L
s
P
p
.001 w
.46795 .99625 m
.46795 1 L
s
P
p
.001 w
.53205 .99625 m
.53205 1 L
s
P
p
.001 w
.5641 .99625 m
.5641 1 L
s
P
p
.001 w
.59615 .99625 m
.59615 1 L
s
P
p
.001 w
.62821 .99625 m
.62821 1 L
s
P
p
.001 w
.69231 .99625 m
.69231 1 L
s
P
p
.001 w
.72436 .99625 m
.72436 1 L
s
P
p
.001 w
.75641 .99625 m
.75641 1 L
s
P
p
.001 w
.78846 .99625 m
.78846 1 L
s
P
p
.001 w
.85256 .99625 m
.85256 1 L
s
P
p
.001 w
.88462 .99625 m
.88462 1 L
s
P
p
.001 w
.91667 .99625 m
.91667 1 L
s
P
p
.001 w
.94872 .99625 m
.94872 1 L
s
P
p
.002 w
0 1 m
1 1 L
s
P
p
.002 w
.99375 .01923 m
1 .01923 L
s
P
p
.002 w
.99375 .17949 m
1 .17949 L
s
P
p
.002 w
.99375 .33974 m
1 .33974 L
s
P
p
.002 w
.99375 .5 m
1 .5 L
s
P
p
.002 w
.99375 .66026 m
1 .66026 L
s
P
p
.002 w
.99375 .82051 m
1 .82051 L
s
P
p
.002 w
.99375 .98077 m
1 .98077 L
s
P
p
.001 w
.99625 .05128 m
1 .05128 L
s
P
p
.001 w
.99625 .08333 m
1 .08333 L
s
P
p
.001 w
.99625 .11538 m
1 .11538 L
s
P
p
.001 w
.99625 .14744 m
1 .14744 L
s
P
p
.001 w
.99625 .21154 m
1 .21154 L
s
P
p
.001 w
.99625 .24359 m
1 .24359 L
s
P
p
.001 w
.99625 .27564 m
1 .27564 L
s
P
p
.001 w
.99625 .30769 m
1 .30769 L
s
P
p
.001 w
.99625 .37179 m
1 .37179 L
s
P
p
.001 w
.99625 .40385 m
1 .40385 L
s
P
p
.001 w
.99625 .4359 m
1 .4359 L
s
P
p
.001 w
.99625 .46795 m
1 .46795 L
s
P
p
.001 w
.99625 .53205 m
1 .53205 L
s
P
p
.001 w
.99625 .5641 m
1 .5641 L
s
P
p
.001 w
.99625 .59615 m
1 .59615 L
s
P
p
.001 w
.99625 .62821 m
1 .62821 L
s
P
p
.001 w
.99625 .69231 m
1 .69231 L
s
P
p
.001 w
.99625 .72436 m
1 .72436 L
s
P
p
.001 w
.99625 .75641 m
1 .75641 L
s
P
p
.001 w
.99625 .78846 m
1 .78846 L
s
P
p
.001 w
.99625 .85256 m
1 .85256 L
s
P
p
.001 w
.99625 .88462 m
1 .88462 L
s
P
p
.001 w
.99625 .91667 m
1 .91667 L
s
P
p
.001 w
.99625 .94872 m
1 .94872 L
s
P
p
.002 w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
p
p
.001 w
.3176 .98077 m
.28448 .98023 L
.25133 .98002 L
.21817 .98016 L
.18501 .98065 L
.17849 .98077 L
s
P
p
.001 w
.45698 .98077 m
.45027 .98044 L
.41711 .9789 L
.38395 .97752 L
.3508 .97636 L
.31764 .97549 L
.28448 .97493 L
.25133 .97472 L
.21817 .97487 L
.18501 .97536 L
.15186 .97618 L
.1187 .97729 L
.08554 .97863 L
.05239 .98015 L
.03963 .98077 L
s
P
p
.001 w
.98077 .97884 m
.94761 .98048 L
.94147 .98077 L
s
P
p
.001 w
.01923 .97652 m
.05239 .97485 L
.08554 .9733 L
.1187 .97192 L
.15186 .97079 L
.18501 .96995 L
.21817 .96944 L
.25133 .96929 L
.28448 .96951 L
.31764 .97008 L
.3508 .97097 L
.38395 .97216 L
.41711 .97357 L
.45027 .97515 L
.48342 .97683 L
.51658 .97853 L
.54973 .98018 L
.56198 .98077 L
s
P
p
.001 w
.01923 .97113 m
.05239 .96942 L
.08554 .96783 L
.1187 .96641 L
.15186 .96524 L
.18501 .96437 L
.21817 .96385 L
.25133 .9637 L
.28448 .96392 L
.31764 .96451 L
.3508 .96543 L
.38395 .96665 L
.41711 .96811 L
.45027 .96973 L
.48342 .97145 L
.51658 .9732 L
.54973 .97489 L
.58289 .97646 L
.61605 .97784 L
.6492 .97899 L
.68236 .97985 L
.71552 .9804 L
.74867 .9806 L
.78183 .98046 L
.81499 .97998 L
.84814 .97917 L
.8813 .97808 L
.91446 .97673 L
.94761 .97519 L
.98077 .97351 L
s
P
p
.001 w
.01923 .9656 m
.05239 .96384 L
.08554 .96219 L
.1187 .96072 L
.15186 .95952 L
.18501 .95862 L
.21817 .95808 L
.25133 .95792 L
.28448 .95815 L
.31764 .95876 L
.3508 .95972 L
.38395 .96098 L
.41711 .96248 L
.45027 .96415 L
.48342 .96593 L
.51658 .96772 L
.54973 .96946 L
.58289 .97107 L
.61605 .97249 L
.6492 .97367 L
.68236 .97455 L
.71552 .97511 L
.74867 .97532 L
.78183 .97517 L
.81499 .97468 L
.84814 .97385 L
.8813 .97273 L
.91446 .97135 L
.94761 .96977 L
.98077 .96805 L
s
P
p
.001 w
.01923 .95988 m
.05239 .95806 L
.08554 .95636 L
.1187 .95484 L
.15186 .95359 L
.18501 .95266 L
.21817 .9521 L
.25133 .95193 L
.28448 .95217 L
.31764 .9528 L
.3508 .9538 L
.38395 .9551 L
.41711 .95666 L
.45027 .95839 L
.48342 .96023 L
.51658 .96208 L
.54973 .96387 L
.58289 .96553 L
.61605 .967 L
.6492 .96821 L
.68236 .96911 L
.71552 .96969 L
.74867 .9699 L
.78183 .96975 L
.81499 .96924 L
.84814 .9684 L
.8813 .96724 L
.91446 .96582 L
.94761 .96419 L
.98077 .96242 L
s
P
p
.001 w
.01923 .95397 m
.05239 .95208 L
.08554 .95031 L
.1187 .94873 L
.14655 .94761 L
.15186 .94743 L
.18501 .94646 L
.21817 .94588 L
.25133 .94571 L
.28448 .94596 L
.31764 .94661 L
.34993 .94761 L
.3508 .94765 L
.38395 .949 L
.41711 .95062 L
.45027 .95242 L
.48342 .95432 L
.51658 .95624 L
.54973 .9581 L
.58289 .95982 L
.61605 .96133 L
.6492 .96258 L
.68236 .96352 L
.71552 .96411 L
.74867 .96433 L
.78183 .96417 L
.81499 .96365 L
.84814 .96278 L
.8813 .96158 L
.91446 .96012 L
.94761 .95843 L
.98077 .95659 L
s
P
p
.001 w
.01923 .94783 m
.02282 .94761 L
.05239 .94586 L
.08554 .94401 L
.1187 .94237 L
.15186 .94101 L
.18501 .94001 L
.21817 .9394 L
.25133 .93922 L
.28448 .93948 L
.31764 .94016 L
.3508 .94124 L
.38395 .94266 L
.41711 .94434 L
.45027 .94622 L
.47377 .94761 L
.48342 .9482 L
.51658 .95019 L
.54973 .95212 L
.58289 .9539 L
.61605 .95547 L
.6492 .95676 L
.68236 .95773 L
.71552 .95834 L
.74867 .95857 L
.78183 .95841 L
.81499 .95787 L
.84814 .95697 L
.8813 .95573 L
.91446 .95421 L
.94761 .95246 L
.98077 .95055 L
s
P
p
.001 w
.01923 .94143 m
.05239 .93938 L
.08554 .93745 L
.1187 .93574 L
.15186 .93432 L
.18501 .93326 L
.21817 .93262 L
.25133 .93244 L
.28448 .93271 L
.31764 .93343 L
.3508 .93455 L
.38395 .93603 L
.41711 .93779 L
.45027 .93975 L
.48342 .94181 L
.51658 .94389 L
.54973 .9459 L
.58016 .94761 L
.58289 .94776 L
.61605 .94939 L
.6492 .95073 L
.68236 .95174 L
.71552 .95237 L
.74867 .95261 L
.78183 .95245 L
.81499 .95188 L
.84814 .95094 L
.8813 .94966 L
.91446 .94808 L
.92332 .94761 L
.94761 .94626 L
.98077 .94427 L
s
P
p
.001 w
.01923 .93475 m
.05239 .9326 L
.08554 .93059 L
.1187 .9288 L
.15186 .92731 L
.18501 .9262 L
.21817 .92554 L
.25133 .92534 L
.28448 .92562 L
.31764 .92638 L
.3508 .92756 L
.38395 .92911 L
.41711 .93095 L
.45027 .93299 L
.48342 .93515 L
.51658 .93732 L
.54973 .93942 L
.58289 .94136 L
.61605 .94306 L
.6492 .94445 L
.68236 .9455 L
.71552 .94616 L
.74867 .94641 L
.78183 .94624 L
.81499 .94565 L
.84814 .94468 L
.8813 .94334 L
.91446 .94169 L
.94761 .93979 L
.98077 .93772 L
s
P
p
.001 w
.01923 .92776 m
.05239 .92552 L
.08554 .9234 L
.1187 .92152 L
.15186 .91997 L
.18501 .91881 L
.21817 .91811 L
.25133 .9179 L
.28448 .9182 L
.31764 .91899 L
.3508 .92023 L
.38395 .92185 L
.41711 .92378 L
.45027 .92592 L
.48342 .92818 L
.51658 .93046 L
.54973 .93265 L
.58289 .93467 L
.61605 .93645 L
.6492 .93791 L
.68236 .939 L
.71552 .93969 L
.74867 .93995 L
.78183 .93977 L
.81499 .93916 L
.84814 .93814 L
.8813 .93674 L
.91446 .93502 L
.94761 .93304 L
.98077 .93087 L
s
P
p
.001 w
.01923 .92044 m
.05239 .91809 L
.08554 .91587 L
.1087 .91446 L
.1187 .9139 L
.15186 .91228 L
.18501 .91107 L
.21817 .91034 L
.25133 .91013 L
.28448 .91044 L
.31764 .91126 L
.3508 .91255 L
.38395 .91424 L
.38778 .91446 L
.41711 .91626 L
.45027 .91851 L
.48342 .92088 L
.51658 .92327 L
.54973 .92556 L
.58289 .92768 L
.61605 .92954 L
.6492 .93107 L
.68236 .93221 L
.71552 .93293 L
.74867 .93321 L
.78183 .93302 L
.81499 .93238 L
.84814 .93131 L
.8813 .92985 L
.91446 .92805 L
.94761 .92597 L
.98077 .9237 L
s
P
p
.001 w
.01923 .91277 m
.05239 .91032 L
.08554 .90801 L
.1187 .90595 L
.15186 .90424 L
.18501 .90297 L
.21817 .9022 L
.25133 .90198 L
.28448 .9023 L
.31764 .90317 L
.3508 .90453 L
.38395 .90631 L
.41711 .90842 L
.45027 .91077 L
.48342 .91323 L
.4997 .91446 L
.51658 .91572 L
.54973 .91814 L
.58289 .92036 L
.61605 .92231 L
.6492 .92391 L
.68236 .92511 L
.71552 .92586 L
.74867 .92615 L
.78183 .92595 L
.81499 .92528 L
.84814 .92416 L
.8813 .92263 L
.91446 .92074 L
.94761 .91856 L
.98077 .91618 L
s
P
p
.001 w
.01923 .90477 m
.05239 .90218 L
.08554 .89974 L
.1187 .89757 L
.15186 .89576 L
.18501 .89441 L
.21817 .8936 L
.25133 .89336 L
.28448 .89371 L
.31764 .89462 L
.3508 .89606 L
.38395 .89794 L
.41711 .90017 L
.45027 .90265 L
.48342 .90525 L
.51658 .90786 L
.54973 .91037 L
.58289 .91269 L
.61144 .91446 L
.61605 .91472 L
.6492 .9164 L
.68236 .91766 L
.71552 .91845 L
.74867 .91875 L
.78183 .91854 L
.81499 .91784 L
.84814 .91666 L
.8813 .91506 L
.89207 .91446 L
.91446 .91309 L
.94761 .91082 L
.98077 .90833 L
s
P
p
.001 w
.01923 .89631 m
.05239 .89357 L
.08554 .89099 L
.1187 .88869 L
.15186 .88677 L
.18501 .88535 L
.21817 .88448 L
.25133 .88423 L
.28448 .8846 L
.31764 .88557 L
.3508 .88709 L
.38395 .88909 L
.41711 .89145 L
.45027 .89407 L
.48342 .89682 L
.51658 .89958 L
.54973 .90223 L
.58289 .90467 L
.61605 .90681 L
.6492 .90856 L
.68236 .90988 L
.71552 .9107 L
.74867 .91101 L
.78183 .9108 L
.81499 .91007 L
.84814 .90884 L
.8813 .90716 L
.91446 .90509 L
.94761 .9027 L
.98077 .90008 L
s
P
p
.001 w
.01923 .88736 m
.05239 .88446 L
.08554 .88172 L
.09089 .8813 L
.1187 .87929 L
.15186 .87728 L
.18501 .87577 L
.21817 .87486 L
.25133 .87459 L
.28448 .87498 L
.31764 .87601 L
.3508 .87761 L
.38395 .87971 L
.40567 .8813 L
.41711 .88221 L
.45027 .88498 L
.48342 .8879 L
.51658 .89082 L
.54973 .89363 L
.58289 .89621 L
.61605 .89847 L
.6492 .90032 L
.68236 .90171 L
.71552 .90258 L
.74867 .90291 L
.78183 .90268 L
.81499 .90191 L
.84814 .90062 L
.8813 .89885 L
.91446 .89666 L
.94761 .89413 L
.98077 .89135 L
s
P
p
.001 w
.01923 .87789 m
.05239 .87484 L
.08554 .87195 L
.1187 .86936 L
.15186 .86721 L
.18501 .8656 L
.21817 .86462 L
.25133 .86434 L
.28448 .86475 L
.31764 .86585 L
.3508 .86757 L
.38395 .86981 L
.41711 .87246 L
.45027 .87539 L
.48342 .87846 L
.51397 .8813 L
.51658 .88154 L
.54973 .88452 L
.58289 .88726 L
.61605 .88965 L
.6492 .89161 L
.68236 .89308 L
.71552 .894 L
.74867 .89434 L
.78183 .8941 L
.81499 .89329 L
.84814 .89192 L
.8813 .89004 L
.91446 .88773 L
.94761 .88505 L
.98077 .8821 L
s
P
p
.001 w
.01923 .86786 m
.05239 .8646 L
.08554 .8615 L
.1187 .85873 L
.15186 .85642 L
.18501 .8547 L
.21817 .85365 L
.25133 .85334 L
.28448 .85379 L
.31764 .85497 L
.3508 .85681 L
.38395 .85921 L
.41711 .86205 L
.45027 .86519 L
.48342 .86847 L
.51658 .87175 L
.54973 .8749 L
.58289 .87778 L
.61605 .8803 L
.63087 .8813 L
.6492 .88238 L
.68236 .88393 L
.71552 .88491 L
.74867 .88527 L
.78183 .88502 L
.81499 .88415 L
.84814 .8827 L
.87258 .8813 L
.8813 .88072 L
.91446 .87828 L
.94761 .87545 L
.98077 .87235 L
s
P
p
.001 w
.01923 .85713 m
.05239 .85362 L
.08554 .8503 L
.10891 .84814 L
.1187 .84732 L
.15186 .84486 L
.18501 .84302 L
.21817 .8419 L
.25133 .84157 L
.28448 .84205 L
.31764 .8433 L
.3508 .84527 L
.38395 .84783 L
.38758 .84814 L
.41711 .85089 L
.45027 .85426 L
.48342 .85778 L
.51658 .8613 L
.54973 .86466 L
.58289 .86775 L
.61605 .87044 L
.6492 .87264 L
.68236 .87428 L
.71552 .87531 L
.74867 .87569 L
.78183 .87543 L
.81499 .87451 L
.84814 .87298 L
.8813 .87088 L
.91446 .86828 L
.94761 .86526 L
.98077 .86193 L
s
P
p
.001 w
.01923 .84561 m
.05239 .84187 L
.08554 .83831 L
.1187 .83511 L
.15186 .83244 L
.18501 .83044 L
.21817 .82922 L
.25133 .82886 L
.28448 .82938 L
.31764 .83075 L
.3508 .83288 L
.38395 .83566 L
.41711 .83894 L
.45027 .84255 L
.48342 .84631 L
.49955 .84814 L
.51658 .85008 L
.54973 .85369 L
.58289 .857 L
.61605 .85989 L
.6492 .86224 L
.68236 .864 L
.71552 .8651 L
.74867 .86551 L
.78183 .86523 L
.81499 .86425 L
.84814 .86261 L
.8813 .86036 L
.91446 .85757 L
.94761 .85433 L
.98077 .85076 L
s
P
p
.001 w
.01923 .83325 m
.05239 .82919 L
.08554 .82532 L
.1187 .82183 L
.15186 .81892 L
.18501 .81673 L
.21817 .8154 L
.25133 .81501 L
.28448 .81558 L
.31764 .81707 L
.3508 .8194 L
.38395 .82244 L
.41711 .82601 L
.45027 .82993 L
.48342 .83401 L
.51658 .83807 L
.54973 .84194 L
.58289 .84548 L
.61123 .84814 L
.61605 .84856 L
.6492 .85109 L
.68236 .85298 L
.71552 .85416 L
.74867 .85461 L
.78183 .8543 L
.81499 .85325 L
.84814 .85149 L
.8813 .84907 L
.89228 .84814 L
.91446 .84608 L
.94761 .84263 L
.98077 .8388 L
s
P
p
.001 w
.01923 .81981 m
.05239 .81536 L
.05525 .81499 L
.08554 .81116 L
.1187 .80738 L
.15186 .8042 L
.18501 .80182 L
.21817 .80037 L
.25133 .79994 L
.28448 .80056 L
.31764 .80219 L
.3508 .80473 L
.38395 .80804 L
.41711 .81191 L
.44131 .81499 L
.45027 .81617 L
.48342 .82063 L
.51658 .82506 L
.54973 .82927 L
.58289 .83311 L
.61605 .83644 L
.6492 .83916 L
.68236 .84118 L
.71552 .84244 L
.74867 .84292 L
.78183 .84259 L
.81499 .84147 L
.84814 .83959 L
.8813 .83699 L
.91446 .83377 L
.94761 .83001 L
.98077 .82586 L
s
P
p
.001 w
.01923 .80517 m
.05239 .80032 L
.08554 .79568 L
.1187 .79148 L
.15186 .78796 L
.18501 .7853 L
.21817 .78369 L
.25133 .78321 L
.28448 .7839 L
.31764 .78572 L
.3508 .78855 L
.38395 .79221 L
.41711 .79651 L
.45027 .80121 L
.48342 .80607 L
.51658 .81089 L
.54622 .81499 L
.54973 .81546 L
.58289 .81965 L
.61605 .82328 L
.6492 .82624 L
.68236 .82844 L
.71552 .82982 L
.74867 .83033 L
.78183 .82998 L
.81499 .82876 L
.84814 .82671 L
.8813 .82388 L
.91446 .82037 L
.94761 .81627 L
.95719 .81499 L
.98077 .81175 L
s
P
p
.001 w
.01923 .78903 m
.05239 .78364 L
.06368 .78183 L
.08554 .77849 L
.1187 .77384 L
.15186 .76991 L
.18501 .76695 L
.21817 .76514 L
.25133 .76461 L
.28448 .76538 L
.31764 .76741 L
.3508 .77057 L
.38395 .77465 L
.41711 .77941 L
.43286 .78183 L
.45027 .78462 L
.48342 .79003 L
.51658 .79537 L
.54973 .80042 L
.58289 .805 L
.61605 .80896 L
.6492 .81217 L
.68236 .81455 L
.68646 .81499 L
.71552 .81605 L
.74867 .81662 L
.78183 .81623 L
.81328 .81499 L
.81499 .8149 L
.84814 .81268 L
.8813 .80961 L
.91446 .80578 L
.94761 .80131 L
.98077 .79633 L
s
P
p
.001 w
.01923 .77111 m
.05239 .76509 L
.08554 .75928 L
.1187 .75399 L
.15186 .74952 L
.15845 .74867 L
.18501 .74616 L
.21817 .7441 L
.25133 .7435 L
.28448 .74438 L
.31764 .74668 L
.33813 .74867 L
.3508 .75027 L
.38395 .75491 L
.41711 .76032 L
.45027 .76619 L
.48342 .77222 L
.51658 .77815 L
.53811 .78183 L
.54973 .78375 L
.58289 .78885 L
.61605 .79324 L
.6492 .7968 L
.68236 .79943 L
.71552 .80107 L
.74867 .80169 L
.78183 .80127 L
.81499 .79981 L
.84814 .79735 L
.8813 .79396 L
.91446 .78971 L
.94761 .78474 L
.96527 .78183 L
.98077 .77921 L
s
P
p
.001 w
.01923 .75089 m
.02994 .74867 L
.05239 .74404 L
.08554 .73743 L
.1187 .73137 L
.15186 .72622 L
.18501 .72231 L
.21817 .71991 L
.25133 .71919 L
.28448 .72022 L
.31764 .72292 L
.3508 .72708 L
.38395 .73243 L
.41711 .73862 L
.45027 .74529 L
.46669 .74867 L
.48342 .75215 L
.51658 .75889 L
.54973 .76522 L
.58289 .7709 L
.61605 .77578 L
.6492 .77972 L
.67127 .78183 L
.68236 .78264 L
.71552 .78448 L
.74867 .78516 L
.78183 .78469 L
.81499 .78307 L
.83254 .78183 L
.84814 .78034 L
.8813 .77658 L
.91446 .77187 L
.94761 .76632 L
.98077 .7601 L
s
P
p
.001 w
.01923 .7278 m
.05239 .71983 L
.07055 .71552 L
.08554 .7121 L
.1187 .70499 L
.15186 .69891 L
.18501 .69427 L
.21817 .69141 L
.25133 .69056 L
.28448 .69179 L
.31764 .695 L
.3508 .69994 L
.38395 .70624 L
.41711 .71348 L
.42597 .71552 L
.45027 .7213 L
.48342 .72926 L
.51658 .73699 L
.54973 .74419 L
.57231 .74867 L
.58289 .75065 L
.61605 .7562 L
.6492 .76068 L
.68236 .76398 L
.71552 .76603 L
.74867 .76679 L
.78183 .76626 L
.81499 .76445 L
.84814 .76138 L
.8813 .75711 L
.91446 .75175 L
.93116 .74867 L
.94761 .74544 L
.98077 .73836 L
s
P
p
.001 w
.01923 .70078 m
.05239 .69132 L
.08424 .68236 L
.08554 .68201 L
.1187 .67341 L
.15186 .66597 L
.18501 .66025 L
.21817 .6567 L
.25133 .65565 L
.28448 .65718 L
.31764 .66115 L
.3508 .66723 L
.38395 .67492 L
.41234 .68236 L
.41711 .68369 L
.45027 .69307 L
.48342 .70251 L
.51658 .71158 L
.53174 .71552 L
.54973 .72 L
.58289 .72752 L
.61605 .73391 L
.6492 .73903 L
.68236 .74278 L
.71552 .74511 L
.74867 .74598 L
.78183 .74538 L
.81499 .74332 L
.84814 .73982 L
.8813 .73495 L
.91446 .72879 L
.94761 .72147 L
.97164 .71552 L
.98077 .71318 L
s
P
p
.001 w
.01923 .66827 m
.05239 .6566 L
.07325 .6492 L
.08554 .64497 L
.1187 .63404 L
.15186 .62445 L
.18501 .61697 L
.19019 .61605 L
.21817 .61234 L
.25133 .61096 L
.28448 .61296 L
.31092 .61605 L
.31764 .61816 L
.3508 .62608 L
.38395 .63597 L
.41711 .64708 L
.42327 .6492 L
.45027 .65877 L
.48342 .67037 L
.51658 .68138 L
.51965 .68236 L
.54973 .69153 L
.58289 .70046 L
.61605 .70798 L
.6492 .71396 L
.65906 .71552 L
.68236 .71835 L
.71552 .72108 L
.74867 .7221 L
.78183 .7214 L
.81499 .71898 L
.84421 .71552 L
.84814 .71489 L
.8813 .7092 L
.91446 .70196 L
.94761 .69327 L
.98077 .68333 L
s
P
p
.001 w
.01923 .62742 m
.04412 .61605 L
.05239 .6122 L
.08554 .59671 L
.11588 .58289 L
.1187 .58168 L
.15186 .56828 L
.18501 .55759 L
.21817 .55079 L
.22726 .54973 L
.25133 .54875 L
.26927 .54973 L
.28448 .5517 L
.31764 .5593 L
.3508 .57059 L
.3807 .58289 L
.38395 .58436 L
.41711 .59956 L
.45027 .61503 L
.45246 .61605 L
.48342 .63014 L
.51658 .64418 L
.52929 .6492 L
.54973 .65685 L
.58289 .66787 L
.61605 .67703 L
.63942 .68236 L
.6492 .68427 L
.68236 .68955 L
.71552 .69281 L
.74867 .69402 L
.78183 .69319 L
.81499 .69031 L
.84814 .68539 L
.86413 .68236 L
.8813 .67851 L
.91446 .6697 L
.94761 .65901 L
.9741 .6492 L
.98077 .64662 L
s
P
p
.001 w
.01923 .57247 m
.05239 .55058 L
.05361 .54973 L
.08554 .52728 L
.10028 .51658 L
.1187 .50353 L
.14798 .48342 L
.15186 .481 L
.18501 .46215 L
.21568 .45027 L
.21817 .44961 L
.25133 .44576 L
.28085 .45027 L
.28448 .45132 L
.31764 .46524 L
.34865 .48342 L
.3508 .48495 L
.38395 .50787 L
.39623 .51658 L
.41711 .53166 L
.44295 .54973 L
.45027 .55476 L
.48342 .57628 L
.49436 .58289 L
.51658 .59564 L
.54973 .61253 L
.55734 .61605 L
.58289 .6269 L
.61605 .63866 L
.6492 .6478 L
.65492 .6492 L
.68236 .65439 L
.71552 .65844 L
.74867 .65994 L
.78183 .65891 L
.81499 .65533 L
.84811 .6492 L
.84814 .6492 L
.8813 .64054 L
.91446 .62927 L
.9461 .61605 L
.94761 .61536 L
.98077 .59895 L
s
P
p
.001 w
.01923 .48817 m
.02366 .48342 L
.05157 .45027 L
.05239 .44922 L
.07559 .41711 L
.08554 .40207 L
.09662 .38395 L
.11541 .3508 L
.1187 .34467 L
.13204 .31764 L
.14755 .28448 L
.15186 .27493 L
.16101 .25133 L
.17437 .21817 L
.18501 .19252 L
.18787 .18501 L
.20056 .15186 L
.21404 .1187 L
.21817 .10957 L
.23163 .08554 L
.25133 .07401 L
.26491 .08554 L
.2825 .1187 L
.28448 .1233 L
.30012 .15186 L
.31273 .18501 L
.31764 .20845 L
.32168 .21817 L
.33544 .25133 L
.34904 .28448 L
.3508 .28878 L
.36445 .31764 L
.38116 .3508 L
.38395 .35611 L
.39992 .38395 L
.41711 .41145 L
.42093 .41711 L
.44499 .45027 L
.45027 .45699 L
.47294 .48342 L
.48342 .49459 L
.50627 .51658 L
.51658 .52562 L
.54782 .54973 L
.54973 .55107 L
.58289 .57175 L
.60456 .58289 L
.61605 .58808 L
.6492 .60053 L
.68236 .60931 L
Mistroke
.71552 .61461 L
.73291 .61605 L
.74867 .61657 L
.77055 .61605 L
.78183 .61522 L
.81499 .61054 L
.84814 .60242 L
.8813 .59066 L
.89893 .58289 L
.91446 .57507 L
.94761 .55524 L
.9556 .54973 L
.98077 .53072 L
Mfstroke
P
p
.001 w
.98077 .40947 m
.9762 .41711 L
.95359 .45027 L
.94761 .45786 L
.92426 .48342 L
.91446 .49256 L
.88325 .51658 L
.8813 .51784 L
.84814 .53601 L
.81499 .54814 L
.80904 .54973 L
.78183 .55504 L
.74867 .55701 L
.71552 .55414 L
.68973 .54973 L
.68236 .54631 L
.6492 .53314 L
.62014 .51658 L
.61605 .51378 L
.58289 .48694 L
.57922 .48342 L
.54984 .45027 L
.54973 .45013 L
.5272 .41711 L
.51658 .39843 L
.50923 .38395 L
.49471 .3508 L
.48342 .31935 L
.48287 .31764 L
.47319 .28448 L
.46524 .25133 L
.45871 .21817 L
.45334 .18501 L
.45027 .16263 L
.44894 .15186 L
.44535 .1187 L
.4424 .08554 L
.43999 .05239 L
.43802 .01923 L
s
P
p
.001 w
.01923 .29947 m
.0234 .28448 L
.03139 .25133 L
.03791 .21817 L
.04325 .18501 L
.04763 .15186 L
.05122 .1187 L
.05239 .10631 L
.05416 .08554 L
.05656 .05239 L
.05853 .01923 L
s
P
p
.001 w
.96037 .01923 m
.95847 .05239 L
.95613 .08554 L
.95324 .1187 L
.94965 .15186 L
.94761 .16802 L
.94521 .18501 L
.93967 .21817 L
.93273 .25133 L
.92397 .28448 L
.91446 .31323 L
.91282 .31764 L
.89849 .3508 L
.8813 .38073 L
.8792 .38395 L
.85179 .41711 L
.84814 .42051 L
.81499 .44459 L
.80326 .45027 L
.78183 .45749 L
.74867 .4611 L
.71552 .45584 L
.69542 .45027 L
.68236 .44109 L
.65156 .41711 L
.6492 .41456 L
.62416 .38395 L
.61605 .37099 L
.60499 .3508 L
.59059 .31764 L
.58289 .29544 L
.57951 .28448 L
.57074 .25133 L
.56378 .21817 L
.55823 .18501 L
.55378 .15186 L
.5502 .1187 L
.54973 .1139 L
.54729 .08554 L
.54493 .05239 L
.54302 .01923 L
s
P
p
.001 w
.82151 .01923 m
.81663 .05239 L
.81499 .06171 L
.81049 .08554 L
.80217 .1187 L
.78964 .15186 L
.78183 .16576 L
.76097 .18501 L
.74867 .18675 L
.74245 .18501 L
.71552 .15529 L
.71307 .15186 L
.69664 .1187 L
.68853 .08554 L
.68449 .05239 L
.6824 .01923 L
s
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 282},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCacheValid->False],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  ContourGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(\(cp2 = 
      ContourPlot[
        Exp[\(-y\)] - Log[Abs[Sec[x] + Tan[x]]], {x, \(-3\), 3}, {y, \(-3\), 
          3}, Contours \[Rule] 20, PlotPoints \[Rule] {100, 50}, 
        ContourShading \[Rule] False]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% ContourGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.160256 0.5 0.160256 [
[(-3)] .01923 0 0 2 Msboxa
[(-2)] .17949 0 0 2 Msboxa
[(-1)] .33974 0 0 2 Msboxa
[(0)] .5 0 0 2 Msboxa
[(1)] .66026 0 0 2 Msboxa
[(2)] .82051 0 0 2 Msboxa
[(3)] .98077 0 0 2 Msboxa
[(-3)] -0.0125 .01923 1 0 Msboxa
[(-2)] -0.0125 .17949 1 0 Msboxa
[(-1)] -0.0125 .33974 1 0 Msboxa
[(0)] -0.0125 .5 1 0 Msboxa
[(1)] -0.0125 .66026 1 0 Msboxa
[(2)] -0.0125 .82051 1 0 Msboxa
[(3)] -0.0125 .98077 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.01923 0 m
.01923 .00625 L
s
P
[(-3)] .01923 0 0 2 Mshowa
p
.002 w
.17949 0 m
.17949 .00625 L
s
P
[(-2)] .17949 0 0 2 Mshowa
p
.002 w
.33974 0 m
.33974 .00625 L
s
P
[(-1)] .33974 0 0 2 Mshowa
p
.002 w
.5 0 m
.5 .00625 L
s
P
[(0)] .5 0 0 2 Mshowa
p
.002 w
.66026 0 m
.66026 .00625 L
s
P
[(1)] .66026 0 0 2 Mshowa
p
.002 w
.82051 0 m
.82051 .00625 L
s
P
[(2)] .82051 0 0 2 Mshowa
p
.002 w
.98077 0 m
.98077 .00625 L
s
P
[(3)] .98077 0 0 2 Mshowa
p
.001 w
.05128 0 m
.05128 .00375 L
s
P
p
.001 w
.08333 0 m
.08333 .00375 L
s
P
p
.001 w
.11538 0 m
.11538 .00375 L
s
P
p
.001 w
.14744 0 m
.14744 .00375 L
s
P
p
.001 w
.21154 0 m
.21154 .00375 L
s
P
p
.001 w
.24359 0 m
.24359 .00375 L
s
P
p
.001 w
.27564 0 m
.27564 .00375 L
s
P
p
.001 w
.30769 0 m
.30769 .00375 L
s
P
p
.001 w
.37179 0 m
.37179 .00375 L
s
P
p
.001 w
.40385 0 m
.40385 .00375 L
s
P
p
.001 w
.4359 0 m
.4359 .00375 L
s
P
p
.001 w
.46795 0 m
.46795 .00375 L
s
P
p
.001 w
.53205 0 m
.53205 .00375 L
s
P
p
.001 w
.5641 0 m
.5641 .00375 L
s
P
p
.001 w
.59615 0 m
.59615 .00375 L
s
P
p
.001 w
.62821 0 m
.62821 .00375 L
s
P
p
.001 w
.69231 0 m
.69231 .00375 L
s
P
p
.001 w
.72436 0 m
.72436 .00375 L
s
P
p
.001 w
.75641 0 m
.75641 .00375 L
s
P
p
.001 w
.78846 0 m
.78846 .00375 L
s
P
p
.001 w
.85256 0 m
.85256 .00375 L
s
P
p
.001 w
.88462 0 m
.88462 .00375 L
s
P
p
.001 w
.91667 0 m
.91667 .00375 L
s
P
p
.001 w
.94872 0 m
.94872 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01923 m
.00625 .01923 L
s
P
[(-3)] -0.0125 .01923 1 0 Mshowa
p
.002 w
0 .17949 m
.00625 .17949 L
s
P
[(-2)] -0.0125 .17949 1 0 Mshowa
p
.002 w
0 .33974 m
.00625 .33974 L
s
P
[(-1)] -0.0125 .33974 1 0 Mshowa
p
.002 w
0 .5 m
.00625 .5 L
s
P
[(0)] -0.0125 .5 1 0 Mshowa
p
.002 w
0 .66026 m
.00625 .66026 L
s
P
[(1)] -0.0125 .66026 1 0 Mshowa
p
.002 w
0 .82051 m
.00625 .82051 L
s
P
[(2)] -0.0125 .82051 1 0 Mshowa
p
.002 w
0 .98077 m
.00625 .98077 L
s
P
[(3)] -0.0125 .98077 1 0 Mshowa
p
.001 w
0 .05128 m
.00375 .05128 L
s
P
p
.001 w
0 .08333 m
.00375 .08333 L
s
P
p
.001 w
0 .11538 m
.00375 .11538 L
s
P
p
.001 w
0 .14744 m
.00375 .14744 L
s
P
p
.001 w
0 .21154 m
.00375 .21154 L
s
P
p
.001 w
0 .24359 m
.00375 .24359 L
s
P
p
.001 w
0 .27564 m
.00375 .27564 L
s
P
p
.001 w
0 .30769 m
.00375 .30769 L
s
P
p
.001 w
0 .37179 m
.00375 .37179 L
s
P
p
.001 w
0 .40385 m
.00375 .40385 L
s
P
p
.001 w
0 .4359 m
.00375 .4359 L
s
P
p
.001 w
0 .46795 m
.00375 .46795 L
s
P
p
.001 w
0 .53205 m
.00375 .53205 L
s
P
p
.001 w
0 .5641 m
.00375 .5641 L
s
P
p
.001 w
0 .59615 m
.00375 .59615 L
s
P
p
.001 w
0 .62821 m
.00375 .62821 L
s
P
p
.001 w
0 .69231 m
.00375 .69231 L
s
P
p
.001 w
0 .72436 m
.00375 .72436 L
s
P
p
.001 w
0 .75641 m
.00375 .75641 L
s
P
p
.001 w
0 .78846 m
.00375 .78846 L
s
P
p
.001 w
0 .85256 m
.00375 .85256 L
s
P
p
.001 w
0 .88462 m
.00375 .88462 L
s
P
p
.001 w
0 .91667 m
.00375 .91667 L
s
P
p
.001 w
0 .94872 m
.00375 .94872 L
s
P
p
.002 w
0 0 m
0 1 L
s
P
P
p
p
.002 w
.01923 .99375 m
.01923 1 L
s
P
p
.002 w
.17949 .99375 m
.17949 1 L
s
P
p
.002 w
.33974 .99375 m
.33974 1 L
s
P
p
.002 w
.5 .99375 m
.5 1 L
s
P
p
.002 w
.66026 .99375 m
.66026 1 L
s
P
p
.002 w
.82051 .99375 m
.82051 1 L
s
P
p
.002 w
.98077 .99375 m
.98077 1 L
s
P
p
.001 w
.05128 .99625 m
.05128 1 L
s
P
p
.001 w
.08333 .99625 m
.08333 1 L
s
P
p
.001 w
.11538 .99625 m
.11538 1 L
s
P
p
.001 w
.14744 .99625 m
.14744 1 L
s
P
p
.001 w
.21154 .99625 m
.21154 1 L
s
P
p
.001 w
.24359 .99625 m
.24359 1 L
s
P
p
.001 w
.27564 .99625 m
.27564 1 L
s
P
p
.001 w
.30769 .99625 m
.30769 1 L
s
P
p
.001 w
.37179 .99625 m
.37179 1 L
s
P
p
.001 w
.40385 .99625 m
.40385 1 L
s
P
p
.001 w
.4359 .99625 m
.4359 1 L
s
P
p
.001 w
.46795 .99625 m
.46795 1 L
s
P
p
.001 w
.53205 .99625 m
.53205 1 L
s
P
p
.001 w
.5641 .99625 m
.5641 1 L
s
P
p
.001 w
.59615 .99625 m
.59615 1 L
s
P
p
.001 w
.62821 .99625 m
.62821 1 L
s
P
p
.001 w
.69231 .99625 m
.69231 1 L
s
P
p
.001 w
.72436 .99625 m
.72436 1 L
s
P
p
.001 w
.75641 .99625 m
.75641 1 L
s
P
p
.001 w
.78846 .99625 m
.78846 1 L
s
P
p
.001 w
.85256 .99625 m
.85256 1 L
s
P
p
.001 w
.88462 .99625 m
.88462 1 L
s
P
p
.001 w
.91667 .99625 m
.91667 1 L
s
P
p
.001 w
.94872 .99625 m
.94872 1 L
s
P
p
.002 w
0 1 m
1 1 L
s
P
p
.002 w
.99375 .01923 m
1 .01923 L
s
P
p
.002 w
.99375 .17949 m
1 .17949 L
s
P
p
.002 w
.99375 .33974 m
1 .33974 L
s
P
p
.002 w
.99375 .5 m
1 .5 L
s
P
p
.002 w
.99375 .66026 m
1 .66026 L
s
P
p
.002 w
.99375 .82051 m
1 .82051 L
s
P
p
.002 w
.99375 .98077 m
1 .98077 L
s
P
p
.001 w
.99625 .05128 m
1 .05128 L
s
P
p
.001 w
.99625 .08333 m
1 .08333 L
s
P
p
.001 w
.99625 .11538 m
1 .11538 L
s
P
p
.001 w
.99625 .14744 m
1 .14744 L
s
P
p
.001 w
.99625 .21154 m
1 .21154 L
s
P
p
.001 w
.99625 .24359 m
1 .24359 L
s
P
p
.001 w
.99625 .27564 m
1 .27564 L
s
P
p
.001 w
.99625 .30769 m
1 .30769 L
s
P
p
.001 w
.99625 .37179 m
1 .37179 L
s
P
p
.001 w
.99625 .40385 m
1 .40385 L
s
P
p
.001 w
.99625 .4359 m
1 .4359 L
s
P
p
.001 w
.99625 .46795 m
1 .46795 L
s
P
p
.001 w
.99625 .53205 m
1 .53205 L
s
P
p
.001 w
.99625 .5641 m
1 .5641 L
s
P
p
.001 w
.99625 .59615 m
1 .59615 L
s
P
p
.001 w
.99625 .62821 m
1 .62821 L
s
P
p
.001 w
.99625 .69231 m
1 .69231 L
s
P
p
.001 w
.99625 .72436 m
1 .72436 L
s
P
p
.001 w
.99625 .75641 m
1 .75641 L
s
P
p
.001 w
.99625 .78846 m
1 .78846 L
s
P
p
.001 w
.99625 .85256 m
1 .85256 L
s
P
p
.001 w
.99625 .88462 m
1 .88462 L
s
P
p
.001 w
.99625 .91667 m
1 .91667 L
s
P
p
.001 w
.99625 .94872 m
1 .94872 L
s
P
p
.002 w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
p
p
.001 w
.25837 .01923 m
.25233 .02509 L
.24262 .02237 L
.23735 .01923 L
s
P
p
.001 w
.28327 .01923 m
.28147 .01966 L
.27176 .02247 L
.26204 .02689 L
.25233 .03745 L
.24262 .03452 L
.23291 .02598 L
.22319 .02194 L
.21348 .01928 L
.21327 .01923 L
s
P
p
.001 w
.38703 .01923 m
.37859 .0198 L
.36888 .02049 L
.35917 .02123 L
.34946 .02203 L
.33974 .02291 L
.33003 .02387 L
.32032 .02496 L
.31061 .02619 L
.30089 .02764 L
.29118 .02939 L
.28147 .03161 L
.27176 .03463 L
.26287 .03885 L
.26204 .03939 L
.25233 .05085 L
.24262 .04767 L
.2334 .03885 L
.23291 .03841 L
.22319 .03406 L
.21348 .0312 L
.20377 .02908 L
.19406 .02739 L
.18434 .02598 L
.17463 .02477 L
.16492 .02371 L
.15521 .02276 L
.14549 .0219 L
.13578 .02111 L
.12607 .02037 L
.11636 .01969 L
.10951 .01923 L
s
P
p
.001 w
.98077 .02348 m
.97106 .02298 L
.96134 .02247 L
.95163 .02195 L
.94192 .02143 L
.93221 .02089 L
.92249 .02034 L
.91278 .01978 L
.90374 .01923 L
s
P
p
.001 w
.01923 .02583 m
.02894 .02634 L
.03866 .02686 L
.04837 .02739 L
.05808 .02794 L
.06779 .02849 L
.07751 .02907 L
.08722 .02967 L
.09693 .03029 L
.10664 .03095 L
.11636 .03164 L
.12607 .03238 L
.13578 .03316 L
.14549 .03401 L
.15521 .03494 L
.16492 .03596 L
.17463 .03711 L
.18434 .03841 L
.18734 .03885 L
.19406 .03993 L
.20377 .04176 L
.21348 .04406 L
.22319 .04716 L
.23291 .05189 L
.23776 .05848 L
.24262 .062 L
.25233 .06548 L
.25803 .05848 L
.26204 .05297 L
.27176 .04778 L
.28147 .0445 L
.29118 .0421 L
.30089 .04021 L
.3092 .03885 L
.31061 .03864 L
.32032 .03731 L
.33003 .03614 L
.33974 .0351 L
.34946 .03416 L
.35917 .0333 L
.36888 .0325 L
.37859 .03176 L
.38831 .03106 L
.39802 .0304 L
.40773 .02977 L
.41744 .02917 L
.42716 .02859 L
.43687 .02803 L
.44658 .02748 L
.45629 .02695 L
Mistroke
.46601 .02643 L
.47572 .02591 L
.48543 .0254 L
.49514 .0249 L
.50486 .0244 L
.51457 .0239 L
.52428 .0234 L
.53399 .0229 L
.54371 .02239 L
.55342 .02187 L
.56313 .02134 L
.57284 .0208 L
.58256 .02025 L
.59227 .01968 L
.59972 .01923 L
Mfstroke
P
p
.001 w
.98077 .03572 m
.97106 .03518 L
.96134 .03463 L
.95163 .03407 L
.94192 .03351 L
.93221 .03293 L
.92249 .03234 L
.91278 .03173 L
.90307 .0311 L
.89336 .03045 L
.88364 .02976 L
.87393 .02904 L
.86422 .02827 L
.85451 .02745 L
.84479 .02657 L
.83508 .0256 L
.82537 .02453 L
.81566 .02333 L
.80594 .02196 L
.79623 .02033 L
.79057 .01923 L
s
P
p
.001 w
.01923 .03825 m
.02894 .0388 L
.02986 .03885 L
.03866 .03936 L
.04837 .03994 L
.05808 .04052 L
.06779 .04113 L
.07751 .04175 L
.08722 .0424 L
.09693 .04308 L
.10664 .04379 L
.11636 .04454 L
.12607 .04533 L
.13578 .04619 L
.14549 .04711 L
.15521 .04812 L
.16492 .04923 L
.17463 .05047 L
.18434 .0519 L
.19406 .05355 L
.20377 .05555 L
.21348 .05806 L
.21486 .05848 L
.22319 .06144 L
.23291 .06662 L
.24262 .07774 L
.243 .0781 L
.25233 .08158 L
.25519 .0781 L
.26204 .0678 L
.27176 .06213 L
.28147 .05854 L
.28168 .05848 L
.29118 .05592 L
.30089 .05385 L
.31061 .05215 L
.32032 .05069 L
.33003 .04942 L
.33974 .04829 L
.34946 .04727 L
.35917 .04633 L
.36888 .04547 L
.37859 .04466 L
.38831 .04391 L
.39802 .04319 L
.40773 .04251 L
.41744 .04186 L
.42716 .04123 L
.43687 .04062 L
.44658 .04003 L
Mistroke
.45629 .03946 L
.46601 .03889 L
.46668 .03885 L
.47572 .03834 L
.48543 .03779 L
.49514 .03725 L
.50486 .03671 L
.51457 .03617 L
.52428 .03563 L
.53399 .03509 L
.54371 .03454 L
.55342 .03398 L
.56313 .03342 L
.57284 .03284 L
.58256 .03225 L
.59227 .03163 L
.60198 .031 L
.61169 .03034 L
.62141 .02965 L
.63112 .02892 L
.64083 .02814 L
.65054 .02731 L
.66026 .02641 L
.66997 .02543 L
.67968 .02435 L
.68939 .02312 L
.69911 .02171 L
.70882 .02004 L
.71289 .01923 L
Mfstroke
P
p
.001 w
.98077 .04897 m
.97106 .04838 L
.96134 .04778 L
.95163 .04718 L
.94192 .04657 L
.93221 .04594 L
.92249 .0453 L
.91278 .04464 L
.90307 .04396 L
.89336 .04325 L
.88364 .0425 L
.87393 .04172 L
.86422 .04089 L
.85451 .04 L
.84479 .03905 L
.84294 .03885 L
.83508 .038 L
.82537 .03685 L
.81566 .03556 L
.80594 .03408 L
.79623 .03233 L
.78652 .0302 L
.77681 .02741 L
.76709 .02334 L
.76344 .01923 L
s
P
p
.001 w
.01923 .05172 m
.02894 .05232 L
.03866 .05293 L
.04837 .05356 L
.05808 .0542 L
.06779 .05486 L
.07751 .05554 L
.08722 .05625 L
.09693 .05699 L
.10664 .05776 L
.11516 .05848 L
.11636 .05858 L
.12607 .05945 L
.13578 .06038 L
.14549 .06139 L
.15521 .06249 L
.16492 .06371 L
.17463 .06507 L
.18434 .06663 L
.19406 .06844 L
.20377 .07064 L
.21348 .0734 L
.22319 .07712 L
.22524 .0781 L
.23291 .08285 L
.24262 .09519 L
.24531 .09772 L
.25233 .09948 L
.25374 .09772 L
.26204 .08415 L
.27131 .0781 L
.27176 .07788 L
.28147 .07392 L
.29118 .07104 L
.30089 .06877 L
.31061 .0669 L
.32032 .06531 L
.33003 .06392 L
.33974 .06268 L
.34946 .06156 L
.35917 .06054 L
.36888 .0596 L
.37859 .05872 L
.38138 .05848 L
.38831 .05789 L
.39802 .05711 L
.40773 .05637 L
.41744 .05565 L
.42716 .05497 L
.43687 .05431 L
Mistroke
.44658 .05366 L
.45629 .05304 L
.46601 .05242 L
.47572 .05182 L
.48543 .05122 L
.49514 .05063 L
.50486 .05004 L
.51457 .04946 L
.52428 .04887 L
.53399 .04828 L
.54371 .04768 L
.55342 .04708 L
.56313 .04646 L
.57284 .04584 L
.58256 .04519 L
.59227 .04453 L
.60198 .04384 L
.61169 .04313 L
.62141 .04238 L
.63112 .04159 L
.64083 .04075 L
.65054 .03985 L
.66026 .03888 L
.66052 .03885 L
.66997 .03782 L
.67968 .03665 L
.68939 .03533 L
.69911 .03381 L
.70882 .03202 L
.71853 .02979 L
.72824 .02686 L
.73796 .02244 L
.74088 .01923 L
Mfstroke
P
p
.001 w
.01923 .06643 m
.02894 .06709 L
.03866 .06776 L
.04837 .06845 L
.05808 .06915 L
.06779 .06987 L
.07751 .07062 L
.08722 .0714 L
.09693 .07221 L
.10664 .07306 L
.11636 .07397 L
.12607 .07493 L
.13578 .07595 L
.14549 .07707 L
.15381 .0781 L
.15521 .07828 L
.16492 .07962 L
.17463 .08113 L
.18434 .08285 L
.19406 .08486 L
.20377 .08729 L
.21348 .09036 L
.22319 .09451 L
.22874 .09772 L
.23291 .1009 L
.24262 .11478 L
.24498 .11735 L
.25233 .11964 L
.25393 .11735 L
.26204 .10236 L
.26779 .09772 L
.27176 .09535 L
.28147 .09094 L
.29118 .08774 L
.30089 .08523 L
.31061 .08316 L
.32032 .0814 L
.33003 .07986 L
.33974 .07849 L
.34273 .0781 L
.34946 .07726 L
.35917 .07613 L
.36888 .07509 L
.37859 .07412 L
.38831 .07321 L
.39802 .07235 L
.40773 .07153 L
.41744 .07075 L
.42716 .07 L
.43687 .06927 L
Mistroke
.44658 .06856 L
.45629 .06787 L
.46601 .0672 L
.47572 .06654 L
.48543 .06589 L
.49514 .06524 L
.50486 .0646 L
.51457 .06396 L
.52428 .06331 L
.53399 .06267 L
.54371 .06202 L
.55342 .06136 L
.56313 .06068 L
.57284 .06 L
.58256 .0593 L
.59227 .05857 L
.59352 .05848 L
.60198 .05782 L
.61169 .05704 L
.62141 .05622 L
.63112 .05536 L
.64083 .05444 L
.65054 .05346 L
.66026 .05241 L
.66997 .05126 L
.67968 .04998 L
.68939 .04854 L
.69911 .04689 L
.70882 .04494 L
.71853 .04254 L
.72824 .03936 L
.72953 .03885 L
.73796 .0346 L
.74767 .02422 L
.75738 .02696 L
.76709 .03556 L
.77392 .03885 L
.77681 .03996 L
.78652 .04297 L
.79623 .04529 L
.80594 .04718 L
.81566 .04879 L
.82537 .0502 L
.83508 .05145 L
.84479 .05259 L
.85451 .05363 L
.86422 .0546 L
.87393 .0555 L
.88364 .05636 L
.89336 .05717 L
Mistroke
.90307 .05795 L
.90994 .05848 L
.91278 .05869 L
.92249 .05941 L
.93221 .06011 L
.94192 .0608 L
.95163 .06146 L
.96134 .06212 L
.97106 .06277 L
.98077 .06342 L
Mfstroke
P
p
.001 w
.01923 .08264 m
.02894 .08337 L
.03866 .08411 L
.04837 .08487 L
.05808 .08565 L
.06779 .08645 L
.07751 .08728 L
.08722 .08814 L
.09693 .08904 L
.10664 .08999 L
.11636 .09099 L
.12607 .09206 L
.13578 .0932 L
.14549 .09444 L
.15521 .0958 L
.16492 .0973 L
.1675 .09772 L
.17463 .09898 L
.18434 .1009 L
.19406 .10316 L
.20377 .10588 L
.21348 .10933 L
.22319 .11401 L
.22834 .11735 L
.23291 .12125 L
.24246 .13697 L
.24262 .1371 L
.25233 .14269 L
.25551 .13697 L
.26204 .1229 L
.26819 .11735 L
.27176 .11496 L
.28147 .10999 L
.29118 .10639 L
.30089 .10357 L
.31061 .10125 L
.32032 .09928 L
.32904 .09772 L
.33003 .09756 L
.33974 .09603 L
.34946 .09465 L
.35917 .0934 L
.36888 .09224 L
.37859 .09116 L
.38831 .09015 L
.39802 .08919 L
.40773 .08828 L
.41744 .08742 L
.42716 .08658 L
.43687 .08578 L
Mistroke
.44658 .08499 L
.45629 .08423 L
.46601 .08349 L
.47572 .08275 L
.48543 .08203 L
.49514 .08132 L
.50486 .08061 L
.51457 .0799 L
.52428 .07919 L
.53399 .07848 L
.53909 .0781 L
.54371 .07776 L
.55342 .07703 L
.56313 .07629 L
.57284 .07553 L
.58256 .07476 L
.59227 .07396 L
.60198 .07313 L
.61169 .07227 L
.62141 .07137 L
.63112 .07042 L
.64083 .06942 L
.65054 .06835 L
.66026 .06719 L
.66997 .06592 L
.67968 .06453 L
.68939 .06296 L
.69911 .06115 L
.70882 .05902 L
.71104 .05848 L
.71853 .0564 L
.72824 .05293 L
.73796 .04775 L
.74512 .03885 L
.74767 .03651 L
.75653 .03885 L
.75738 .03947 L
.76709 .04879 L
.77681 .05358 L
.78652 .05687 L
.79242 .05848 L
.79623 .0594 L
.80594 .06147 L
.81566 .06323 L
.82537 .06477 L
.83508 .06614 L
.84479 .06738 L
.85451 .06853 L
.86422 .06959 L
.87393 .07058 L
Mistroke
.88364 .07152 L
.89336 .07241 L
.90307 .07327 L
.91278 .07409 L
.92249 .07488 L
.93221 .07566 L
.94192 .07641 L
.95163 .07715 L
.96134 .07788 L
.96437 .0781 L
.97106 .07859 L
.98077 .07931 L
Mfstroke
P
p
.001 w
.01923 .10066 m
.02894 .10148 L
.03866 .10231 L
.04837 .10316 L
.05808 .10404 L
.06779 .10493 L
.07751 .10587 L
.08722 .10683 L
.09693 .10785 L
.10664 .10891 L
.11636 .11004 L
.12607 .11124 L
.13578 .11253 L
.14549 .11393 L
.15521 .11546 L
.16492 .11716 L
.16592 .11735 L
.17463 .11907 L
.18434 .12125 L
.19406 .12381 L
.20377 .12691 L
.21348 .13085 L
.22319 .13621 L
.22431 .13697 L
.23291 .14455 L
.23781 .15659 L
.24262 .16304 L
.25233 .16964 L
.25799 .15659 L
.26204 .14647 L
.27176 .13731 L
.27223 .13697 L
.28147 .13161 L
.29118 .12749 L
.30089 .12428 L
.31061 .12164 L
.32032 .1194 L
.33003 .11746 L
.33062 .11735 L
.33974 .11573 L
.34946 .11417 L
.35917 .11275 L
.36888 .11145 L
.37859 .11023 L
.38831 .10909 L
.39802 .10802 L
.40773 .107 L
.41744 .10602 L
.42716 .10508 L
.43687 .10418 L
Mistroke
.44658 .1033 L
.45629 .10245 L
.46601 .10162 L
.47572 .1008 L
.48543 .09999 L
.49514 .09919 L
.50486 .0984 L
.5131 .09772 L
.51457 .0976 L
.52428 .09681 L
.53399 .09601 L
.54371 .09521 L
.55342 .0944 L
.56313 .09357 L
.57284 .09273 L
.58256 .09187 L
.59227 .09098 L
.60198 .09006 L
.61169 .08911 L
.62141 .08811 L
.63112 .08706 L
.64083 .08594 L
.65054 .08475 L
.66026 .08347 L
.66997 .08207 L
.67968 .08053 L
.68939 .0788 L
.69296 .0781 L
.69911 .07681 L
.70882 .07446 L
.71853 .07156 L
.72824 .06776 L
.73796 .06209 L
.74054 .05848 L
.74767 .04983 L
.75738 .05305 L
.76375 .05848 L
.76709 .06323 L
.77681 .06847 L
.78652 .07209 L
.79623 .07487 L
.80594 .07715 L
.8105 .0781 L
.81566 .0791 L
.82537 .08079 L
.83508 .08231 L
.84479 .08369 L
.85451 .08495 L
.86422 .08613 L
.87393 .08723 L
Mistroke
.88364 .08827 L
.89336 .08927 L
.90307 .09021 L
.91278 .09113 L
.92249 .09201 L
.93221 .09287 L
.94192 .09371 L
.95163 .09453 L
.96134 .09534 L
.97106 .09614 L
.98077 .09694 L
Mfstroke
P
p
.001 w
.01923 .12098 m
.02894 .12191 L
.03866 .12285 L
.04837 .12382 L
.05808 .12481 L
.06779 .12584 L
.07751 .1269 L
.08722 .128 L
.09693 .12916 L
.10664 .13038 L
.11636 .13167 L
.12607 .13304 L
.13578 .13452 L
.14549 .13613 L
.15025 .13697 L
.15521 .13789 L
.16492 .13984 L
.17463 .14204 L
.18434 .14456 L
.19406 .14753 L
.20377 .15113 L
.21348 .15572 L
.21505 .15659 L
.22319 .162 L
.23291 .17184 L
.23468 .17622 L
.24262 .194 L
.24358 .19584 L
.25233 .20205 L
.25481 .19584 L
.26129 .17622 L
.26204 .17412 L
.27176 .16328 L
.28147 .1566 L
.28149 .15659 L
.29118 .1518 L
.30089 .14807 L
.31061 .14501 L
.32032 .14242 L
.33003 .14018 L
.33974 .13819 L
.34629 .13697 L
.34946 .13641 L
.35917 .13478 L
.36888 .13328 L
.37859 .13189 L
.38831 .13058 L
.39802 .12935 L
.40773 .12819 L
.41744 .12707 L
Mistroke
.42716 .12601 L
.43687 .12498 L
.44658 .12398 L
.45629 .12301 L
.46601 .12206 L
.47572 .12113 L
.48543 .12021 L
.49514 .1193 L
.50486 .11841 L
.51457 .11751 L
.51633 .11735 L
.52428 .11661 L
.53399 .11571 L
.54371 .1148 L
.55342 .11388 L
.56313 .11295 L
.57284 .112 L
.58256 .11103 L
.59227 .11003 L
.60198 .10899 L
.61169 .10792 L
.62141 .1068 L
.63112 .10562 L
.64083 .10437 L
.65054 .10304 L
.66026 .1016 L
.66997 .10003 L
.67968 .09831 L
.68275 .09772 L
.68939 .09637 L
.69911 .09415 L
.70882 .09153 L
.71853 .08832 L
.72824 .08411 L
.73765 .0781 L
.73796 .07784 L
.74767 .06436 L
.75738 .06789 L
.76626 .0781 L
.76709 .0791 L
.77681 .08489 L
.78652 .0889 L
.79623 .092 L
.80594 .09454 L
.81566 .09671 L
.82071 .09772 L
.82537 .0986 L
.83508 .1003 L
.84479 .10184 L
.85451 .10326 L
Mistroke
.86422 .10458 L
.87393 .10582 L
.88364 .10699 L
.89336 .1081 L
.90307 .10917 L
.91278 .11019 L
.92249 .11119 L
.93221 .11216 L
.94192 .11311 L
.95163 .11404 L
.96134 .11495 L
.97106 .11586 L
.98077 .11676 L
Mfstroke
P
p
.001 w
.01923 .14424 m
.02894 .14532 L
.03866 .14641 L
.04837 .14754 L
.05808 .14869 L
.06779 .14988 L
.07751 .15111 L
.08722 .1524 L
.09693 .15375 L
.10664 .15517 L
.11584 .15659 L
.11636 .15668 L
.12607 .15828 L
.13578 .16001 L
.14549 .1619 L
.15521 .16396 L
.16492 .16626 L
.17463 .16886 L
.18434 .17185 L
.19406 .17538 L
.19612 .17622 L
.20377 .17967 L
.21348 .18516 L
.22319 .19274 L
.22626 .19584 L
.23291 .20475 L
.23593 .21546 L
.24262 .23242 L
.24372 .23509 L
.25233 .24272 L
.25472 .23509 L
.25983 .21546 L
.26204 .20755 L
.27028 .19584 L
.27176 .1943 L
.28147 .18623 L
.29118 .18047 L
.30042 .17622 L
.30089 .17602 L
.31061 .17239 L
.32032 .16932 L
.33003 .16667 L
.33974 .16432 L
.34946 .16222 L
.35917 .16031 L
.36888 .15856 L
.37859 .15693 L
.3807 .15659 L
.38831 .15541 L
.39802 .15397 L
Mistroke
.40773 .15261 L
.41744 .15132 L
.42716 .15008 L
.43687 .14888 L
.44658 .14772 L
.45629 .1466 L
.46601 .1455 L
.47572 .14442 L
.48543 .14336 L
.49514 .14231 L
.50486 .14127 L
.51457 .14024 L
.52428 .13921 L
.53399 .13817 L
.54371 .13713 L
.54518 .13697 L
.55342 .13607 L
.56313 .135 L
.57284 .13391 L
.58256 .1328 L
.59227 .13165 L
.60198 .13047 L
.61169 .12924 L
.62141 .12796 L
.63112 .12661 L
.64083 .12519 L
.65054 .12367 L
.66026 .12204 L
.66997 .12026 L
.67968 .11831 L
.68409 .11735 L
.68939 .11611 L
.69911 .11361 L
.70882 .11065 L
.71853 .10704 L
.72824 .10231 L
.73516 .09772 L
.73796 .0953 L
.74767 .08035 L
.75738 .08425 L
.76709 .09671 L
.76832 .09772 L
.77681 .10319 L
.78652 .10769 L
.79623 .11117 L
.80594 .11404 L
.81566 .11649 L
.81937 .11735 L
.82537 .11864 L
.83508 .12057 L
Mistroke
.84479 .12232 L
.85451 .12393 L
.86422 .12543 L
.87393 .12684 L
.88364 .12817 L
.89336 .12945 L
.90307 .13067 L
.91278 .13184 L
.92249 .13298 L
.93221 .13409 L
.94192 .13518 L
.95163 .13625 L
.95828 .13697 L
.96134 .1373 L
.97106 .13834 L
.98077 .13938 L
Mfstroke
P
p
.001 w
.01923 .17148 m
.02894 .17275 L
.03866 .17405 L
.04837 .17539 L
.05427 .17622 L
.05808 .17676 L
.06779 .17818 L
.07751 .17965 L
.08722 .18118 L
.09693 .1828 L
.10664 .1845 L
.11636 .18631 L
.12607 .18825 L
.13578 .19034 L
.14549 .19262 L
.15521 .19513 L
.15777 .19584 L
.16492 .19793 L
.17463 .2011 L
.18434 .20476 L
.19406 .2091 L
.20377 .21442 L
.20543 .21546 L
.21348 .22127 L
.22319 .23082 L
.2265 .23509 L
.23291 .24621 L
.23497 .25471 L
.2391 .27433 L
.24262 .28305 L
.24635 .29396 L
.25233 .29735 L
.25317 .29396 L
.25712 .27433 L
.26097 .25471 L
.26204 .24985 L
.27005 .23509 L
.27176 .2328 L
.28147 .2226 L
.29111 .21546 L
.29118 .21542 L
.30089 .20989 L
.31061 .20542 L
.32032 .20166 L
.33003 .19842 L
.33877 .19584 L
.33974 .19557 L
.34946 .19302 L
.35917 .1907 L
.36888 .18858 L
Mistroke
.37859 .18662 L
.38831 .18479 L
.39802 .18307 L
.40773 .18144 L
.41744 .17989 L
.42716 .17841 L
.43687 .17699 L
.44227 .17622 L
.44658 .17561 L
.45629 .17427 L
.46601 .17296 L
.47572 .17168 L
.48543 .17043 L
.49514 .16919 L
.50486 .16796 L
.51457 .16674 L
.52428 .16552 L
.53399 .1643 L
.54371 .16307 L
.55342 .16183 L
.56313 .16058 L
.57284 .1593 L
.58256 .158 L
.59227 .15666 L
.59275 .15659 L
.60198 .15528 L
.61169 .15384 L
.62141 .15235 L
.63112 .15078 L
.64083 .14913 L
.65054 .14737 L
.66026 .14547 L
.66997 .14342 L
.67968 .14116 L
.68939 .13864 L
.69518 .13697 L
.69911 .13575 L
.70882 .13237 L
.71853 .12823 L
.72824 .12285 L
.73549 .11735 L
.73796 .1149 L
.74767 .09811 L
.75738 .10247 L
.76709 .1165 L
.76799 .11735 L
.77681 .12385 L
.78652 .12898 L
.79623 .13297 L
.80594 .13626 L
Mistroke
.80828 .13697 L
.81566 .13907 L
.82537 .14155 L
.83508 .14377 L
.84479 .14579 L
.85451 .14766 L
.86422 .14941 L
.87393 .15105 L
.88364 .1526 L
.89336 .15408 L
.90307 .15551 L
.91072 .15659 L
.91278 .15688 L
.92249 .15821 L
.93221 .15951 L
.94192 .16078 L
.95163 .16204 L
.96134 .16327 L
.97106 .1645 L
.98077 .16572 L
Mfstroke
P
p
.001 w
.01923 .2043 m
.02894 .20586 L
.03866 .20746 L
.04837 .20911 L
.05808 .2108 L
.06779 .21256 L
.07751 .21439 L
.083 .21546 L
.08722 .2163 L
.09693 .21831 L
.10664 .22044 L
.11636 .22271 L
.12607 .22515 L
.13578 .22778 L
.14549 .23067 L
.15521 .23386 L
.15868 .23509 L
.16492 .23743 L
.17463 .24149 L
.18434 .24622 L
.19406 .25186 L
.19829 .25471 L
.20377 .25885 L
.21348 .26795 L
.21878 .27433 L
.22319 .28086 L
.22985 .29396 L
.23291 .30228 L
.23485 .31358 L
.23727 .3332 L
.24125 .35283 L
.24262 .3575 L
.24565 .37245 L
.25233 .38089 L
.25355 .37245 L
.25602 .35283 L
.25844 .3332 L
.2611 .31358 L
.26204 .30747 L
.26668 .29396 L
.27176 .28357 L
.27776 .27433 L
.28147 .26974 L
.29118 .26016 L
.29825 .25471 L
.30089 .2529 L
.31061 .24707 L
.32032 .24221 L
.33003 .23805 L
.33786 .23509 L
Mistroke
.33974 .23441 L
.34946 .23117 L
.35917 .22824 L
.36888 .22556 L
.37859 .2231 L
.38831 .2208 L
.39802 .21865 L
.40773 .21662 L
.41353 .21546 L
.41744 .2147 L
.42716 .21286 L
.43687 .21109 L
.44658 .20938 L
.45629 .20773 L
.46601 .20612 L
.47572 .20455 L
.48543 .20301 L
.49514 .20149 L
.50486 .19999 L
.51457 .1985 L
.52428 .19702 L
.53202 .19584 L
.53399 .19554 L
.54371 .19405 L
.55342 .19254 L
.56313 .19102 L
.57284 .18948 L
.58256 .18791 L
.59227 .18629 L
.60198 .18463 L
.61169 .18291 L
.62141 .18113 L
.63112 .17926 L
.64083 .17728 L
.64585 .17622 L
.65054 .17519 L
.66026 .17294 L
.66997 .1705 L
.67968 .16782 L
.68939 .16484 L
.69911 .16146 L
.70882 .1575 L
.7108 .15659 L
.71853 .15267 L
.72824 .14641 L
.73796 .13724 L
.73808 .13697 L
.74767 .11808 L
.75738 .12304 L
.76593 .13697 L
Mistroke
.76709 .13908 L
.77681 .14757 L
.78652 .15354 L
.79266 .15659 L
.79623 .15819 L
.80594 .16204 L
.81566 .16536 L
.82537 .16828 L
.83508 .17091 L
.84479 .17332 L
.85451 .17554 L
.85761 .17622 L
.86422 .17761 L
.87393 .17957 L
.88364 .18143 L
.89336 .1832 L
.90307 .18491 L
.91278 .18656 L
.92249 .18817 L
.93221 .18974 L
.94192 .19127 L
.95163 .19279 L
.96134 .19429 L
.97106 .19578 L
.97144 .19584 L
.98077 .19726 L
Mfstroke
P
p
.001 w
.01923 .24562 m
.02894 .24765 L
.03866 .24974 L
.04837 .25188 L
.05808 .2541 L
.06069 .25471 L
.06779 .2564 L
.07751 .25881 L
.08722 .26133 L
.09693 .264 L
.10664 .26684 L
.11636 .26988 L
.12607 .27316 L
.12935 .27433 L
.13578 .27673 L
.14549 .28065 L
.15521 .28502 L
.16492 .28996 L
.1719 .29396 L
.17463 .29563 L
.18434 .3023 L
.19406 .31037 L
.1974 .31358 L
.20377 .32053 L
.21293 .3332 L
.21348 .3341 L
.22272 .35283 L
.22319 .35402 L
.22914 .37245 L
.23291 .38929 L
.23326 .39207 L
.23502 .4117 L
.23625 .43132 L
.23756 .45094 L
.23922 .47057 L
.24131 .49019 L
.24262 .50087 L
.24328 .50981 L
.24478 .52943 L
.24643 .54906 L
.25233 .5656 L
.25313 .54906 L
.25406 .52943 L
.25501 .50981 L
.25599 .49019 L
.25704 .47057 L
.25819 .45094 L
.25946 .43132 L
.2609 .4117 L
.26204 .39833 L
Mistroke
.2631 .39207 L
.26739 .37245 L
.27176 .35832 L
.27381 .35283 L
.28147 .3368 L
.2836 .3332 L
.29118 .32246 L
.29914 .31358 L
.30089 .31187 L
.31061 .30351 L
.32032 .29665 L
.32464 .29396 L
.33003 .29083 L
.33974 .28579 L
.34946 .28134 L
.35917 .27735 L
.36719 .27433 L
.36888 .27373 L
.37859 .2704 L
.38831 .26732 L
.39802 .26446 L
.40773 .26176 L
.41744 .25921 L
.42716 .25679 L
.43585 .25471 L
.43687 .25447 L
.44658 .25224 L
.45629 .25008 L
.46601 .24799 L
.47572 .24595 L
.48543 .24396 L
.49514 .242 L
.50486 .24007 L
.51457 .23816 L
.52428 .23627 L
.53034 .23509 L
.53399 .23437 L
.54371 .23248 L
.55342 .23057 L
.56313 .22864 L
.57284 .2267 L
.58256 .22471 L
.59227 .22269 L
.60198 .22061 L
.61169 .21846 L
.62141 .21623 L
.62467 .21546 L
.63112 .2139 L
.64083 .21145 L
.65054 .20886 L
Mistroke
.66026 .20609 L
.66997 .2031 L
.67968 .19983 L
.68939 .1962 L
.69031 .19584 L
.69911 .19209 L
.70882 .1873 L
.71853 .18151 L
.72572 .17622 L
.72824 .17405 L
.73796 .16321 L
.7405 .15659 L
.74767 .14089 L
.75738 .14663 L
.76378 .15659 L
.76709 .16536 L
.77681 .17543 L
.77775 .17622 L
.78652 .18255 L
.79623 .18814 L
.80594 .1928 L
.81315 .19584 L
.81566 .19683 L
.82537 .20039 L
.83508 .20361 L
.84479 .20656 L
.85451 .2093 L
.86422 .21186 L
.87393 .21429 L
.8788 .21546 L
.88364 .2166 L
.89336 .21882 L
.90307 .22095 L
.91278 .22302 L
.92249 .22504 L
.93221 .22702 L
.94192 .22896 L
.95163 .23088 L
.96134 .23279 L
.97106 .23468 L
.97312 .23509 L
.98077 .23658 L
Mfstroke
P
p
.001 w
.98077 .28878 m
.97106 .28616 L
.96134 .28355 L
.95163 .28095 L
.94192 .27833 L
.93221 .27569 L
.92724 .27433 L
.92249 .27302 L
.91278 .2703 L
.90307 .26752 L
.89336 .26467 L
.88364 .26173 L
.87393 .25868 L
.86422 .25549 L
.86192 .25471 L
.85451 .25212 L
.84479 .24855 L
.83508 .24473 L
.82537 .24058 L
.81566 .23602 L
.8138 .23509 L
.80594 .2309 L
.79623 .22501 L
.78652 .218 L
.78345 .21546 L
.77681 .20916 L
.76709 .19683 L
.76668 .19584 L
.75907 .17622 L
.75738 .17431 L
.74767 .16751 L
.74384 .17622 L
.73796 .19421 L
.73701 .19584 L
.72824 .20746 L
.72001 .21546 L
.71853 .21671 L
.70882 .22395 L
.69911 .22999 L
.68966 .23509 L
.68939 .23522 L
.67968 .23987 L
.66997 .24407 L
.66026 .24795 L
.65054 .25156 L
.64154 .25471 L
.64083 .25495 L
.63112 .25816 L
.62141 .26124 L
.61169 .2642 L
Mistroke
.60198 .26706 L
.59227 .26985 L
.58256 .27258 L
.57622 .27433 L
.57284 .27526 L
.56313 .2779 L
.55342 .28052 L
.54371 .28313 L
.53399 .28573 L
.52428 .28835 L
.51457 .29099 L
.50486 .29365 L
.50375 .29396 L
.49514 .29635 L
.48543 .2991 L
.47572 .30192 L
.46601 .30482 L
.45629 .30781 L
.44658 .31091 L
.43851 .31358 L
.43687 .31413 L
.42716 .31751 L
.41744 .32106 L
.40773 .32483 L
.39802 .32884 L
.38831 .33315 L
.38819 .3332 L
.37859 .33781 L
.36888 .34289 L
.35917 .34851 L
.35236 .35283 L
.34946 .35477 L
.33974 .36187 L
.33003 .37006 L
.32746 .37245 L
.32032 .3797 L
.31061 .39141 L
.31011 .39207 L
.30089 .40614 L
.29782 .4117 L
.29118 .42578 L
.28895 .43132 L
.28241 .45094 L
.28147 .45429 L
.27748 .47057 L
.27372 .49019 L
.27176 .50289 L
.2708 .50981 L
.26847 .52943 L
.26661 .54906 L
Mistroke
.26512 .56868 L
.26391 .5883 L
.26291 .60793 L
.2621 .62755 L
.26204 .62893 L
.26167 .64717 L
.26133 .6668 L
.26102 .68642 L
.26076 .70604 L
.26052 .72567 L
.26032 .74529 L
.26014 .76491 L
.25998 .78454 L
.25984 .80416 L
.25971 .82378 L
.2596 .84341 L
.25951 .86303 L
.25942 .88265 L
.25935 .90228 L
.25928 .9219 L
.25922 .94152 L
.25917 .96115 L
.25912 .98077 L
Mfstroke
P
p
.001 w
.01923 .30146 m
.02894 .30434 L
.03866 .30731 L
.04837 .31039 L
.05803 .31358 L
.05808 .3136 L
.06779 .31694 L
.07751 .32047 L
.08722 .32419 L
.09693 .32816 L
.10664 .33242 L
.10835 .3332 L
.11636 .33702 L
.12607 .34203 L
.13578 .34755 L
.14418 .35283 L
.14549 .3537 L
.15521 .36064 L
.16492 .36863 L
.16907 .37245 L
.17463 .378 L
.18434 .38931 L
.18643 .39207 L
.19406 .40346 L
.19872 .4117 L
.20377 .4221 L
.20759 .43132 L
.21348 .44871 L
.21413 .45094 L
.21905 .47057 L
.22281 .49019 L
.22319 .4925 L
.22575 .50981 L
.22807 .52943 L
.22992 .54906 L
.2314 .56868 L
.23261 .5883 L
.23291 .59386 L
.23338 .60793 L
.2339 .62755 L
.23431 .64717 L
.23464 .6668 L
.23492 .68642 L
.23515 .70604 L
.23535 .72567 L
.23552 .74529 L
.23567 .76491 L
.2358 .78454 L
.23592 .80416 L
.23603 .82378 L
Mistroke
.23612 .84341 L
.23621 .86303 L
.23628 .88265 L
.23635 .90228 L
.23641 .9219 L
.23647 .94152 L
.23652 .96115 L
.23656 .98077 L
Mfstroke
P
p
.001 w
.98077 .36671 m
.97106 .36247 L
.96134 .35829 L
.95163 .35416 L
.94848 .35283 L
.94192 .35004 L
.93221 .34593 L
.92249 .34181 L
.91278 .33765 L
.90307 .33345 L
.9025 .3332 L
.89336 .32916 L
.88364 .32478 L
.87393 .32028 L
.86422 .31561 L
.86011 .31358 L
.85451 .31074 L
.84479 .30562 L
.83508 .30019 L
.82537 .29436 L
.82472 .29396 L
.81566 .288 L
.80594 .28096 L
.79778 .27433 L
.79623 .27298 L
.78652 .26359 L
.77888 .25471 L
.77681 .25195 L
.76709 .23603 L
.76678 .23509 L
.76173 .21546 L
.75738 .20778 L
.74767 .19945 L
.74235 .21546 L
.73796 .23268 L
.73685 .23509 L
.72824 .24972 L
.72458 .25471 L
.71853 .26187 L
.70882 .27155 L
.70568 .27433 L
.69911 .27973 L
.68939 .2869 L
.67968 .29336 L
.67874 .29396 L
.66997 .29926 L
.66026 .30476 L
.65054 .30992 L
.64335 .31358 L
.64083 .31483 L
Mistroke
.63112 .31952 L
.62141 .32405 L
.61169 .32845 L
.60198 .33275 L
.60096 .3332 L
.59227 .33697 L
.58256 .34113 L
.57284 .34526 L
.56313 .34937 L
.55498 .35283 L
.55342 .35349 L
.54371 .35761 L
.53399 .36178 L
.52428 .36601 L
.51457 .37031 L
.50981 .37245 L
.50486 .3747 L
.49514 .37921 L
.48543 .38385 L
.47572 .38867 L
.46907 .39207 L
.46601 .39368 L
.45629 .39891 L
.44658 .40442 L
.43687 .41026 L
.43456 .4117 L
.42716 .41646 L
.41744 .42312 L
.40773 .43031 L
.40644 .43132 L
.39802 .43815 L
.38831 .44678 L
.38397 .45094 L
.37859 .4564 L
.36888 .46725 L
.36616 .47057 L
.35917 .47971 L
.35203 .49019 L
.34946 .49429 L
.34075 .50981 L
.33974 .5118 L
.3317 .52943 L
.33003 .53354 L
.32436 .54906 L
.32032 .56188 L
.31838 .56868 L
.31345 .5883 L
.31061 .60157 L
.30936 .60793 L
.30595 .62755 L
Mistroke
.30309 .64717 L
.30089 .66484 L
.30067 .6668 L
.29861 .68642 L
.29686 .70604 L
.29536 .72567 L
.29407 .74529 L
.29296 .76491 L
.29199 .78454 L
.29118 .80357 L
.29116 .80416 L
.29043 .82378 L
.2898 .84341 L
.28925 .86303 L
.28876 .88265 L
.28834 .90228 L
.28797 .9219 L
.28765 .94152 L
.28736 .96115 L
.28711 .98077 L
Mfstroke
P
p
.001 w
.01923 .38787 m
.02747 .39207 L
.02894 .39284 L
.03866 .39804 L
.04837 .4035 L
.05808 .40928 L
.06198 .4117 L
.06779 .41542 L
.07751 .42199 L
.08722 .42909 L
.0901 .43132 L
.09693 .43682 L
.10664 .44531 L
.11257 .45094 L
.11636 .45475 L
.12607 .46538 L
.13038 .47057 L
.13578 .47754 L
.14451 .49019 L
.14549 .49173 L
.15521 .50868 L
.15579 .50981 L
.16484 .52943 L
.16492 .52962 L
.17218 .54906 L
.17463 .55663 L
.17816 .56868 L
.18309 .5883 L
.18434 .59395 L
.18718 .60793 L
.19059 .62755 L
.19345 .64717 L
.19406 .65179 L
.19587 .6668 L
.19793 .68642 L
.19968 .70604 L
.20118 .72567 L
.20247 .74529 L
.20358 .76491 L
.20377 .76846 L
.20455 .78454 L
.20538 .80416 L
.20611 .82378 L
.20674 .84341 L
.20729 .86303 L
.20778 .88265 L
.2082 .90228 L
.20857 .9219 L
.20889 .94152 L
.20918 .96115 L
Mistroke
.20943 .98077 L
Mfstroke
P
p
.001 w
.98077 .52442 m
.97106 .51333 L
.96786 .50981 L
.96134 .50283 L
.95163 .49282 L
.949 .49019 L
.94192 .48321 L
.93221 .47393 L
.92861 .47057 L
.92249 .4649 L
.91278 .45608 L
.90705 .45094 L
.90307 .44739 L
.89336 .43879 L
.88488 .43132 L
.88364 .43023 L
.87393 .42163 L
.86422 .41296 L
.86281 .4117 L
.85451 .40413 L
.84479 .39508 L
.84164 .39207 L
.83508 .3857 L
.82537 .37588 L
.8221 .37245 L
.81566 .36545 L
.80594 .35419 L
.80483 .35283 L
.79623 .34174 L
.79021 .3332 L
.78652 .32754 L
.7784 .31358 L
.77681 .31049 L
.76931 .29396 L
.76709 .28802 L
.76452 .27433 L
.75975 .25471 L
.75738 .25014 L
.74767 .23937 L
.74351 .25471 L
.73964 .27433 L
.73796 .28341 L
.73416 .29396 L
.72824 .30729 L
.72506 .31358 L
.71853 .32499 L
.71325 .3332 L
.70882 .33956 L
.69911 .35224 L
.69863 .35283 L
Mistroke
.68939 .36367 L
.68136 .37245 L
.67968 .37422 L
.66997 .38412 L
.66182 .39207 L
.66026 .39357 L
.65054 .40267 L
.64083 .41153 L
.64065 .4117 L
.63112 .42022 L
.62141 .42882 L
.61858 .43132 L
.61169 .43739 L
.60198 .44598 L
.59641 .45094 L
.59227 .45465 L
.58256 .46345 L
.57485 .47057 L
.57284 .47244 L
.56313 .48167 L
.55446 .49019 L
.55342 .49123 L
.54371 .50116 L
.5356 .50981 L
.53399 .51157 L
.52428 .52256 L
.51849 .52943 L
.51457 .53424 L
.50486 .54677 L
.50316 .54906 L
.49514 .56033 L
.48957 .56868 L
.48543 .57518 L
.4776 .5883 L
.47572 .59164 L
.46712 .60793 L
.46601 .61017 L
.45796 .62755 L
.45629 .63141 L
.44997 .64717 L
.44658 .65637 L
.443 .6668 L
.43693 .68642 L
.43687 .68664 L
.43164 .70604 L
.42716 .72505 L
.42702 .72567 L
.42299 .74529 L
.41947 .76491 L
.41744 .77749 L
Mistroke
.41638 .78454 L
.41368 .80416 L
.41132 .82378 L
.40924 .84341 L
.40773 .85951 L
.40742 .86303 L
.40582 .88265 L
.40441 .90228 L
.40318 .9219 L
.40209 .94152 L
.40113 .96115 L
.40028 .98077 L
Mfstroke
P
p
.001 w
.01923 .58882 m
.02894 .60697 L
.02942 .60793 L
.03858 .62755 L
.03866 .62772 L
.04657 .64717 L
.04837 .65197 L
.05354 .6668 L
.05808 .68122 L
.05961 .68642 L
.0649 .70604 L
.06779 .71802 L
.06952 .72567 L
.07355 .74529 L
.07707 .76491 L
.07751 .76751 L
.08016 .78454 L
.08285 .80416 L
.08522 .82378 L
.08722 .84263 L
.0873 .84341 L
.08912 .86303 L
.09072 .88265 L
.09213 .90228 L
.09336 .9219 L
.09445 .94152 L
.09541 .96115 L
.09626 .98077 L
s
P
p
.001 w
.89049 .98077 m
.8897 .96115 L
.88881 .94152 L
.88781 .9219 L
.88669 .90228 L
.88543 .88265 L
.88401 .86303 L
.88364 .85827 L
.88243 .84341 L
.88065 .82378 L
.87867 .80416 L
.87646 .78454 L
.874 .76491 L
.87393 .76443 L
.87126 .74529 L
.86822 .72567 L
.86487 .70604 L
.86422 .70243 L
.86118 .68642 L
.85713 .6668 L
.85451 .65497 L
.8527 .64717 L
.8479 .62755 L
.84479 .61565 L
.8427 .60793 L
.83714 .5883 L
.83508 .58135 L
.83122 .56868 L
.82537 .55024 L
.82499 .54906 L
.81849 .52943 L
.81566 .52107 L
.8118 .50981 L
.80594 .49289 L
.80501 .49019 L
.79822 .47057 L
.79623 .46476 L
.79156 .45094 L
.78652 .43559 L
.78515 .43132 L
.77912 .4117 L
.77681 .40368 L
.77358 .39207 L
.76866 .37245 L
.76709 .36547 L
.76545 .35283 L
.76337 .3332 L
.75948 .31358 L
.75738 .30789 L
.7526 .29396 L
Mistroke
.74767 .29267 L
.74733 .29396 L
.74364 .31358 L
.74095 .3332 L
.73857 .35283 L
.73796 .35807 L
.73482 .37245 L
.72987 .39207 L
.72824 .39801 L
.72434 .4117 L
.71853 .43062 L
.71831 .43132 L
.7119 .45094 L
.70882 .46009 L
.70524 .47057 L
.69911 .48831 L
.69845 .49019 L
.69166 .50981 L
.68939 .51641 L
.68497 .52943 L
.67968 .54536 L
.67847 .54906 L
.67224 .56868 L
.66997 .57607 L
.66632 .5883 L
.66076 .60793 L
.66026 .60975 L
.65557 .62755 L
.65076 .64717 L
.65054 .64809 L
.64633 .6668 L
.64228 .68642 L
.64083 .6939 L
.63859 .70604 L
.63524 .72567 L
.6322 .74529 L
.63112 .75281 L
.62946 .76491 L
.627 .78454 L
.62479 .80416 L
.62281 .82378 L
.62141 .83909 L
.62103 .84341 L
.61945 .86303 L
.61803 .88265 L
.61677 .90228 L
.61565 .9219 L
.61465 .94152 L
.61376 .96115 L
.61297 .98077 L
Mistroke
Mfstroke
P
p
.001 w
.78673 .98077 m
.78652 .96187 L
.78651 .96115 L
.78626 .94152 L
.78597 .9219 L
.78566 .90228 L
.7853 .88265 L
.7849 .86303 L
.78446 .84341 L
.78397 .82378 L
.78342 .80416 L
.78281 .78454 L
.78213 .76491 L
.78139 .74529 L
.78057 .72567 L
.77967 .70604 L
.77869 .68642 L
.77762 .6668 L
.77681 .65284 L
.77646 .64717 L
.7752 .62755 L
.77386 .60793 L
.77243 .5883 L
.77093 .56868 L
.76938 .54906 L
.76778 .52943 L
.76709 .52112 L
.76646 .50981 L
.76547 .49019 L
.76458 .47057 L
.76361 .45094 L
.76224 .43132 L
.75989 .4117 L
.75738 .39906 L
.75633 .39207 L
.74767 .37308 L
.74525 .39207 L
.74344 .4117 L
.74197 .43132 L
.7407 .45094 L
.73957 .47057 L
.73855 .49019 L
.73796 .50227 L
.73733 .50981 L
.73571 .52943 L
.7341 .54906 L
.73253 .56868 L
.73103 .5883 L
.72959 .60793 L
.72825 .62755 L
Mistroke
.72824 .62759 L
.727 .64717 L
.72585 .6668 L
.72478 .68642 L
.72379 .70604 L
.72289 .72567 L
.72207 .74529 L
.72133 .76491 L
.72065 .78454 L
.72004 .80416 L
.71949 .82378 L
.719 .84341 L
.71855 .86303 L
.71853 .86402 L
.71816 .88265 L
.7178 .90228 L
.71749 .9219 L
.7172 .94152 L
.71695 .96115 L
.71673 .98077 L
Mfstroke
P
p
.001 w
.76265 .98077 m
.7626 .96115 L
.76253 .94152 L
.76246 .9219 L
.76238 .90228 L
.76229 .88265 L
.76218 .86303 L
.76205 .84341 L
.7619 .82378 L
.76172 .80416 L
.76151 .78454 L
.76126 .76491 L
.76097 .74529 L
.76061 .72567 L
.76017 .70604 L
.75964 .68642 L
.75898 .6668 L
.75816 .64717 L
.75738 .63206 L
.75723 .62755 L
.75649 .60793 L
.75559 .5883 L
.75441 .56868 L
.75269 .54906 L
.74767 .54207 L
.74729 .54906 L
.74642 .56868 L
.74572 .5883 L
.74514 .60793 L
.74465 .62755 L
.74424 .64717 L
.74388 .6668 L
.74356 .68642 L
.74329 .70604 L
.74305 .72567 L
.74284 .74529 L
.74266 .76491 L
.7425 .78454 L
.74236 .80416 L
.74223 .82378 L
.74212 .84341 L
.74202 .86303 L
.74193 .88265 L
.74186 .90228 L
.74179 .9219 L
.74173 .94152 L
.74168 .96115 L
.74163 .98077 L
s
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 282},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCacheValid->False]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(\(Show[cp1, cp2]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.5 0.15873 [
[(-3)] .02381 0 0 2 Msboxa
[(-2)] .18254 0 0 2 Msboxa
[(-1)] .34127 0 0 2 Msboxa
[(0)] .5 0 0 2 Msboxa
[(1)] .65873 0 0 2 Msboxa
[(2)] .81746 0 0 2 Msboxa
[(3)] .97619 0 0 2 Msboxa
[(-3)] -0.0125 .02381 1 0 Msboxa
[(-2)] -0.0125 .18254 1 0 Msboxa
[(-1)] -0.0125 .34127 1 0 Msboxa
[(0)] -0.0125 .5 1 0 Msboxa
[(1)] -0.0125 .65873 1 0 Msboxa
[(2)] -0.0125 .81746 1 0 Msboxa
[(3)] -0.0125 .97619 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(-3)] .02381 0 0 2 Mshowa
p
.002 w
.18254 0 m
.18254 .00625 L
s
P
[(-2)] .18254 0 0 2 Mshowa
p
.002 w
.34127 0 m
.34127 .00625 L
s
P
[(-1)] .34127 0 0 2 Mshowa
p
.002 w
.5 0 m
.5 .00625 L
s
P
[(0)] .5 0 0 2 Mshowa
p
.002 w
.65873 0 m
.65873 .00625 L
s
P
[(1)] .65873 0 0 2 Mshowa
p
.002 w
.81746 0 m
.81746 .00625 L
s
P
[(2)] .81746 0 0 2 Mshowa
p
.002 w
.97619 0 m
.97619 .00625 L
s
P
[(3)] .97619 0 0 2 Mshowa
p
.001 w
.05556 0 m
.05556 .00375 L
s
P
p
.001 w
.0873 0 m
.0873 .00375 L
s
P
p
.001 w
.11905 0 m
.11905 .00375 L
s
P
p
.001 w
.15079 0 m
.15079 .00375 L
s
P
p
.001 w
.21429 0 m
.21429 .00375 L
s
P
p
.001 w
.24603 0 m
.24603 .00375 L
s
P
p
.001 w
.27778 0 m
.27778 .00375 L
s
P
p
.001 w
.30952 0 m
.30952 .00375 L
s
P
p
.001 w
.37302 0 m
.37302 .00375 L
s
P
p
.001 w
.40476 0 m
.40476 .00375 L
s
P
p
.001 w
.43651 0 m
.43651 .00375 L
s
P
p
.001 w
.46825 0 m
.46825 .00375 L
s
P
p
.001 w
.53175 0 m
.53175 .00375 L
s
P
p
.001 w
.56349 0 m
.56349 .00375 L
s
P
p
.001 w
.59524 0 m
.59524 .00375 L
s
P
p
.001 w
.62698 0 m
.62698 .00375 L
s
P
p
.001 w
.69048 0 m
.69048 .00375 L
s
P
p
.001 w
.72222 0 m
.72222 .00375 L
s
P
p
.001 w
.75397 0 m
.75397 .00375 L
s
P
p
.001 w
.78571 0 m
.78571 .00375 L
s
P
p
.001 w
.84921 0 m
.84921 .00375 L
s
P
p
.001 w
.88095 0 m
.88095 .00375 L
s
P
p
.001 w
.9127 0 m
.9127 .00375 L
s
P
p
.001 w
.94444 0 m
.94444 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .02381 m
.00625 .02381 L
s
P
[(-3)] -0.0125 .02381 1 0 Mshowa
p
.002 w
0 .18254 m
.00625 .18254 L
s
P
[(-2)] -0.0125 .18254 1 0 Mshowa
p
.002 w
0 .34127 m
.00625 .34127 L
s
P
[(-1)] -0.0125 .34127 1 0 Mshowa
p
.002 w
0 .5 m
.00625 .5 L
s
P
[(0)] -0.0125 .5 1 0 Mshowa
p
.002 w
0 .65873 m
.00625 .65873 L
s
P
[(1)] -0.0125 .65873 1 0 Mshowa
p
.002 w
0 .81746 m
.00625 .81746 L
s
P
[(2)] -0.0125 .81746 1 0 Mshowa
p
.002 w
0 .97619 m
.00625 .97619 L
s
P
[(3)] -0.0125 .97619 1 0 Mshowa
p
.001 w
0 .05556 m
.00375 .05556 L
s
P
p
.001 w
0 .0873 m
.00375 .0873 L
s
P
p
.001 w
0 .11905 m
.00375 .11905 L
s
P
p
.001 w
0 .15079 m
.00375 .15079 L
s
P
p
.001 w
0 .21429 m
.00375 .21429 L
s
P
p
.001 w
0 .24603 m
.00375 .24603 L
s
P
p
.001 w
0 .27778 m
.00375 .27778 L
s
P
p
.001 w
0 .30952 m
.00375 .30952 L
s
P
p
.001 w
0 .37302 m
.00375 .37302 L
s
P
p
.001 w
0 .40476 m
.00375 .40476 L
s
P
p
.001 w
0 .43651 m
.00375 .43651 L
s
P
p
.001 w
0 .46825 m
.00375 .46825 L
s
P
p
.001 w
0 .53175 m
.00375 .53175 L
s
P
p
.001 w
0 .56349 m
.00375 .56349 L
s
P
p
.001 w
0 .59524 m
.00375 .59524 L
s
P
p
.001 w
0 .62698 m
.00375 .62698 L
s
P
p
.001 w
0 .69048 m
.00375 .69048 L
s
P
p
.001 w
0 .72222 m
.00375 .72222 L
s
P
p
.001 w
0 .75397 m
.00375 .75397 L
s
P
p
.001 w
0 .78571 m
.00375 .78571 L
s
P
p
.001 w
0 .84921 m
.00375 .84921 L
s
P
p
.001 w
0 .88095 m
.00375 .88095 L
s
P
p
.001 w
0 .9127 m
.00375 .9127 L
s
P
p
.001 w
0 .94444 m
.00375 .94444 L
s
P
p
.002 w
0 0 m
0 1 L
s
P
P
p
p
.002 w
.02381 .99375 m
.02381 1 L
s
P
p
.002 w
.18254 .99375 m
.18254 1 L
s
P
p
.002 w
.34127 .99375 m
.34127 1 L
s
P
p
.002 w
.5 .99375 m
.5 1 L
s
P
p
.002 w
.65873 .99375 m
.65873 1 L
s
P
p
.002 w
.81746 .99375 m
.81746 1 L
s
P
p
.002 w
.97619 .99375 m
.97619 1 L
s
P
p
.001 w
.05556 .99625 m
.05556 1 L
s
P
p
.001 w
.0873 .99625 m
.0873 1 L
s
P
p
.001 w
.11905 .99625 m
.11905 1 L
s
P
p
.001 w
.15079 .99625 m
.15079 1 L
s
P
p
.001 w
.21429 .99625 m
.21429 1 L
s
P
p
.001 w
.24603 .99625 m
.24603 1 L
s
P
p
.001 w
.27778 .99625 m
.27778 1 L
s
P
p
.001 w
.30952 .99625 m
.30952 1 L
s
P
p
.001 w
.37302 .99625 m
.37302 1 L
s
P
p
.001 w
.40476 .99625 m
.40476 1 L
s
P
p
.001 w
.43651 .99625 m
.43651 1 L
s
P
p
.001 w
.46825 .99625 m
.46825 1 L
s
P
p
.001 w
.53175 .99625 m
.53175 1 L
s
P
p
.001 w
.56349 .99625 m
.56349 1 L
s
P
p
.001 w
.59524 .99625 m
.59524 1 L
s
P
p
.001 w
.62698 .99625 m
.62698 1 L
s
P
p
.001 w
.69048 .99625 m
.69048 1 L
s
P
p
.001 w
.72222 .99625 m
.72222 1 L
s
P
p
.001 w
.75397 .99625 m
.75397 1 L
s
P
p
.001 w
.78571 .99625 m
.78571 1 L
s
P
p
.001 w
.84921 .99625 m
.84921 1 L
s
P
p
.001 w
.88095 .99625 m
.88095 1 L
s
P
p
.001 w
.9127 .99625 m
.9127 1 L
s
P
p
.001 w
.94444 .99625 m
.94444 1 L
s
P
p
.002 w
0 1 m
1 1 L
s
P
p
.002 w
.99375 .02381 m
1 .02381 L
s
P
p
.002 w
.99375 .18254 m
1 .18254 L
s
P
p
.002 w
.99375 .34127 m
1 .34127 L
s
P
p
.002 w
.99375 .5 m
1 .5 L
s
P
p
.002 w
.99375 .65873 m
1 .65873 L
s
P
p
.002 w
.99375 .81746 m
1 .81746 L
s
P
p
.002 w
.99375 .97619 m
1 .97619 L
s
P
p
.001 w
.99625 .05556 m
1 .05556 L
s
P
p
.001 w
.99625 .0873 m
1 .0873 L
s
P
p
.001 w
.99625 .11905 m
1 .11905 L
s
P
p
.001 w
.99625 .15079 m
1 .15079 L
s
P
p
.001 w
.99625 .21429 m
1 .21429 L
s
P
p
.001 w
.99625 .24603 m
1 .24603 L
s
P
p
.001 w
.99625 .27778 m
1 .27778 L
s
P
p
.001 w
.99625 .30952 m
1 .30952 L
s
P
p
.001 w
.99625 .37302 m
1 .37302 L
s
P
p
.001 w
.99625 .40476 m
1 .40476 L
s
P
p
.001 w
.99625 .43651 m
1 .43651 L
s
P
p
.001 w
.99625 .46825 m
1 .46825 L
s
P
p
.001 w
.99625 .53175 m
1 .53175 L
s
P
p
.001 w
.99625 .56349 m
1 .56349 L
s
P
p
.001 w
.99625 .59524 m
1 .59524 L
s
P
p
.001 w
.99625 .62698 m
1 .62698 L
s
P
p
.001 w
.99625 .69048 m
1 .69048 L
s
P
p
.001 w
.99625 .72222 m
1 .72222 L
s
P
p
.001 w
.99625 .75397 m
1 .75397 L
s
P
p
.001 w
.99625 .78571 m
1 .78571 L
s
P
p
.001 w
.99625 .84921 m
1 .84921 L
s
P
p
.001 w
.99625 .88095 m
1 .88095 L
s
P
p
.001 w
.99625 .9127 m
1 .9127 L
s
P
p
.001 w
.99625 .94444 m
1 .94444 L
s
P
p
.002 w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
p
p
p
.001 w
.31934 .97619 m
.28654 .97565 L
.25369 .97545 L
.22085 .97559 L
.18801 .97607 L
.18155 .97619 L
s
P
p
.001 w
.45739 .97619 m
.45074 .97587 L
.4179 .97434 L
.38506 .97297 L
.35222 .97183 L
.31938 .97096 L
.28654 .97041 L
.25369 .9702 L
.22085 .97034 L
.18801 .97083 L
.15517 .97164 L
.12233 .97274 L
.08949 .97407 L
.05665 .97558 L
.04401 .97619 L
s
P
p
.001 w
.97619 .97428 m
.94335 .9759 L
.93726 .97619 L
s
P
p
.001 w
.02381 .97198 m
.05665 .97033 L
.08949 .96879 L
.12233 .96743 L
.15517 .9663 L
.18801 .96547 L
.22085 .96497 L
.25369 .96482 L
.28654 .96503 L
.31938 .9656 L
.35222 .96649 L
.38506 .96766 L
.4179 .96906 L
.45074 .97063 L
.48358 .97229 L
.51642 .97397 L
.54926 .97561 L
.56139 .97619 L
s
P
p
.001 w
.02381 .96664 m
.05665 .96495 L
.08949 .96337 L
.12233 .96197 L
.15517 .96081 L
.18801 .95995 L
.22085 .95943 L
.25369 .95928 L
.28654 .9595 L
.31938 .96008 L
.35222 .961 L
.38506 .96221 L
.4179 .96365 L
.45074 .96526 L
.48358 .96696 L
.51642 .96869 L
.54926 .97036 L
.5821 .97192 L
.61494 .97329 L
.64778 .97443 L
.68062 .97528 L
.71346 .97582 L
.74631 .97603 L
.77915 .97589 L
.81199 .97541 L
.84483 .97461 L
.87767 .97352 L
.91051 .97219 L
.94335 .97066 L
.97619 .969 L
s
P
p
.001 w
.02381 .96116 m
.05665 .95942 L
.08949 .95779 L
.12233 .95634 L
.15517 .95514 L
.18801 .95425 L
.22085 .95372 L
.25369 .95356 L
.28654 .95379 L
.31938 .95439 L
.35222 .95534 L
.38506 .95659 L
.4179 .95807 L
.45074 .95973 L
.48358 .96149 L
.51642 .96327 L
.54926 .96499 L
.5821 .96658 L
.61494 .96799 L
.64778 .96916 L
.68062 .97003 L
.71346 .97058 L
.74631 .97079 L
.77915 .97065 L
.81199 .97016 L
.84483 .96934 L
.87767 .96823 L
.91051 .96686 L
.94335 .96529 L
.97619 .96359 L
s
P
p
.001 w
.02381 .9555 m
.05665 .9537 L
.08949 .95201 L
.12233 .95051 L
.15517 .94927 L
.18801 .94835 L
.22085 .94779 L
.25369 .94763 L
.28654 .94786 L
.31938 .94849 L
.35222 .94948 L
.38506 .95077 L
.4179 .95231 L
.45074 .95403 L
.48358 .95584 L
.51642 .95768 L
.54926 .95945 L
.5821 .9611 L
.61494 .96255 L
.64778 .96375 L
.68062 .96465 L
.71346 .96521 L
.74631 .96543 L
.77915 .96528 L
.81199 .96478 L
.84483 .96394 L
.87767 .96279 L
.91051 .96138 L
.94335 .95977 L
.97619 .95801 L
s
P
p
.001 w
.02381 .94965 m
.05665 .94777 L
.08949 .94602 L
.12233 .94446 L
.14992 .94335 L
.15517 .94317 L
.18801 .94221 L
.22085 .94163 L
.25369 .94146 L
.28654 .94171 L
.31938 .94236 L
.35136 .94335 L
.35222 .94338 L
.38506 .94473 L
.4179 .94633 L
.45074 .94811 L
.48358 .95 L
.51642 .9519 L
.54926 .95374 L
.5821 .95544 L
.61494 .95694 L
.64778 .95817 L
.68062 .9591 L
.71346 .95969 L
.74631 .95991 L
.77915 .95975 L
.81199 .95924 L
.84483 .95837 L
.87767 .95719 L
.91051 .95573 L
.94335 .95406 L
.97619 .95225 L
s
P
p
.001 w
.02381 .94356 m
.02736 .94335 L
.05665 .94161 L
.08949 .93979 L
.12233 .93816 L
.15517 .93681 L
.18801 .93581 L
.22085 .93521 L
.25369 .93503 L
.28654 .93529 L
.31938 .93597 L
.35222 .93704 L
.38506 .93844 L
.4179 .94011 L
.45074 .94197 L
.47402 .94335 L
.48358 .94393 L
.51642 .9459 L
.54926 .94781 L
.5821 .94958 L
.61494 .95113 L
.64778 .95241 L
.68062 .95337 L
.71346 .95398 L
.74631 .95421 L
.77915 .95405 L
.81199 .95351 L
.84483 .95262 L
.87767 .95139 L
.91051 .94988 L
.94335 .94815 L
.97619 .94626 L
s
P
p
.001 w
.02381 .93722 m
.05665 .93519 L
.08949 .93328 L
.12233 .93159 L
.15517 .93018 L
.18801 .92914 L
.22085 .9285 L
.25369 .92832 L
.28654 .92859 L
.31938 .9293 L
.35222 .93041 L
.38506 .93188 L
.4179 .93362 L
.45074 .93556 L
.48358 .9376 L
.51642 .93967 L
.54926 .94165 L
.5794 .94335 L
.5821 .94349 L
.61494 .94511 L
.64778 .94644 L
.68062 .94743 L
.71346 .94806 L
.74631 .9483 L
.77915 .94814 L
.81199 .94758 L
.84483 .94665 L
.87767 .94538 L
.91051 .94381 L
.91929 .94335 L
.94335 .94201 L
.97619 .94004 L
s
P
p
.001 w
.02381 .93061 m
.05665 .92848 L
.08949 .92649 L
.12233 .92471 L
.15517 .92324 L
.18801 .92215 L
.22085 .92148 L
.25369 .92129 L
.28654 .92157 L
.31938 .92232 L
.35222 .92348 L
.38506 .92502 L
.4179 .92684 L
.45074 .92887 L
.48358 .93101 L
.51642 .93316 L
.54926 .93524 L
.5821 .93715 L
.61494 .93884 L
.64778 .94022 L
.68062 .94126 L
.71346 .94191 L
.74631 .94216 L
.77915 .94199 L
.81199 .94141 L
.84483 .94044 L
.87767 .93912 L
.91051 .93748 L
.94335 .9356 L
.97619 .93355 L
s
P
p
.001 w
.02381 .92369 m
.05665 .92146 L
.08949 .91937 L
.12233 .91751 L
.15517 .91597 L
.18801 .91482 L
.22085 .91413 L
.25369 .91392 L
.28654 .91422 L
.31938 .915 L
.35222 .91622 L
.38506 .91783 L
.4179 .91974 L
.45074 .92187 L
.48358 .9241 L
.51642 .92636 L
.54926 .92853 L
.5821 .93053 L
.61494 .93229 L
.64778 .93374 L
.68062 .93482 L
.71346 .93551 L
.74631 .93576 L
.77915 .93559 L
.81199 .93498 L
.84483 .93397 L
.87767 .93258 L
.91051 .93088 L
.94335 .92891 L
.97619 .92677 L
s
P
p
.001 w
.02381 .91644 m
.05665 .9141 L
.08949 .91191 L
.11243 .91051 L
.12233 .90996 L
.15517 .90835 L
.18801 .90716 L
.22085 .90644 L
.25369 .90622 L
.28654 .90653 L
.31938 .90735 L
.35222 .90862 L
.38506 .9103 L
.38885 .91051 L
.4179 .9123 L
.45074 .91453 L
.48358 .91687 L
.51642 .91923 L
.54926 .92151 L
.5821 .92361 L
.61494 .92545 L
.64778 .92696 L
.68062 .9281 L
.71346 .92881 L
.74631 .92908 L
.77915 .92889 L
.81199 .92826 L
.84483 .9272 L
.87767 .92576 L
.91051 .92397 L
.94335 .92191 L
.97619 .91966 L
s
P
p
.001 w
.02381 .90884 m
.05665 .90641 L
.08949 .90413 L
.12233 .90209 L
.15517 .90039 L
.18801 .89913 L
.22085 .89837 L
.25369 .89815 L
.28654 .89847 L
.31938 .89933 L
.35222 .90068 L
.38506 .90244 L
.4179 .90453 L
.45074 .90686 L
.48358 .9093 L
.49971 .91051 L
.51642 .91177 L
.54926 .91415 L
.5821 .91635 L
.61494 .91828 L
.64778 .91987 L
.68062 .92106 L
.71346 .92181 L
.74631 .92209 L
.77915 .92189 L
.81199 .92123 L
.84483 .92012 L
.87767 .9186 L
.91051 .91673 L
.94335 .91458 L
.97619 .91222 L
s
P
p
.001 w
.02381 .90091 m
.05665 .89835 L
.08949 .89593 L
.12233 .89378 L
.15517 .89199 L
.18801 .89066 L
.22085 .88985 L
.25369 .88961 L
.28654 .88996 L
.31938 .89086 L
.35222 .89229 L
.38506 .89415 L
.4179 .89636 L
.45074 .89881 L
.48358 .90139 L
.51642 .90398 L
.54926 .90647 L
.5821 .90876 L
.61037 .91051 L
.61494 .91077 L
.64778 .91243 L
.68062 .91368 L
.71346 .91446 L
.74631 .91476 L
.77915 .91456 L
.81199 .91386 L
.84483 .9127 L
.87767 .9111 L
.88834 .91051 L
.91051 .90915 L
.94335 .90691 L
.97619 .90445 L
s
P
p
.001 w
.02381 .89253 m
.05665 .88983 L
.08949 .88727 L
.12233 .88499 L
.15517 .88309 L
.18801 .88168 L
.22085 .88082 L
.25369 .88057 L
.28654 .88094 L
.31938 .8819 L
.35222 .88341 L
.38506 .88538 L
.4179 .88772 L
.45074 .89032 L
.48358 .89304 L
.51642 .89577 L
.54926 .8984 L
.5821 .90082 L
.61494 .90294 L
.64778 .90467 L
.68062 .90597 L
.71346 .90679 L
.74631 .9071 L
.77915 .90688 L
.81199 .90616 L
.84483 .90495 L
.87767 .90329 L
.91051 .90124 L
.94335 .89887 L
.97619 .89627 L
s
P
p
.001 w
.02381 .88367 m
.05665 .8808 L
.08949 .87809 L
.09479 .87767 L
.12233 .87568 L
.15517 .87368 L
.18801 .8722 L
.22085 .87129 L
.25369 .87103 L
.28654 .87141 L
.31938 .87243 L
.35222 .87402 L
.38506 .8761 L
.40657 .87767 L
.4179 .87857 L
.45074 .88132 L
.48358 .88421 L
.51642 .8871 L
.54926 .88988 L
.5821 .89244 L
.61494 .89468 L
.64778 .89651 L
.68062 .89788 L
.71346 .89874 L
.74631 .89907 L
.77915 .89884 L
.81199 .89808 L
.84483 .8968 L
.87767 .89505 L
.91051 .89288 L
.94335 .89037 L
.97619 .88763 L
s
P
p
.001 w
.02381 .87429 m
.05665 .87127 L
.08949 .8684 L
.12233 .86584 L
.15517 .86371 L
.18801 .86212 L
.22085 .86115 L
.25369 .86087 L
.28654 .86128 L
.31938 .86237 L
.35222 .86406 L
.38506 .86629 L
.4179 .86891 L
.45074 .87182 L
.48358 .87486 L
.51384 .87767 L
.51642 .87791 L
.54926 .88086 L
.5821 .88357 L
.61494 .88594 L
.64778 .88788 L
.68062 .88933 L
.71346 .89024 L
.74631 .89059 L
.77915 .89035 L
.81199 .88954 L
.84483 .88819 L
.87767 .88633 L
.91051 .88403 L
.94335 .88138 L
.97619 .87846 L
s
P
p
.001 w
.02381 .86436 m
.05665 .86112 L
.08949 .85806 L
.12233 .85531 L
.15517 .85303 L
.18801 .85132 L
.22085 .85028 L
.25369 .84998 L
.28654 .85042 L
.31938 .85158 L
.35222 .85341 L
.38506 .85579 L
.4179 .8586 L
.45074 .86171 L
.48358 .86496 L
.51642 .86821 L
.54926 .87133 L
.5821 .87419 L
.61494 .87668 L
.62963 .87767 L
.64778 .87873 L
.68062 .88027 L
.71346 .88124 L
.74631 .8816 L
.77915 .88135 L
.81199 .8805 L
.84483 .87906 L
.86903 .87767 L
.87767 .87709 L
.91051 .87468 L
.94335 .87188 L
.97619 .8688 L
s
P
p
.001 w
.02381 .85372 m
.05665 .85025 L
.08949 .84696 L
.11263 .84483 L
.12233 .84401 L
.15517 .84157 L
.18801 .83975 L
.22085 .83864 L
.25369 .83832 L
.28654 .83879 L
.31938 .84003 L
.35222 .84198 L
.38506 .84452 L
.38865 .84483 L
.4179 .84755 L
.45074 .85088 L
.48358 .85437 L
.51642 .85786 L
.54926 .86119 L
.5821 .86425 L
.61494 .86691 L
.64778 .86909 L
.68062 .87071 L
.71346 .87173 L
.74631 .87212 L
.77915 .87185 L
.81199 .87095 L
.84483 .86943 L
.87767 .86735 L
.91051 .86477 L
.94335 .86178 L
.97619 .85849 L
s
P
p
.001 w
.02381 .84232 m
.05665 .83861 L
.08949 .83509 L
.12233 .83192 L
.15517 .82927 L
.18801 .82729 L
.22085 .82609 L
.25369 .82573 L
.28654 .82625 L
.31938 .8276 L
.35222 .82971 L
.38506 .83247 L
.4179 .83571 L
.45074 .83928 L
.48358 .84301 L
.49955 .84483 L
.51642 .84674 L
.54926 .85032 L
.5821 .8536 L
.61494 .85646 L
.64778 .85879 L
.68062 .86053 L
.71346 .86162 L
.74631 .86203 L
.77915 .86175 L
.81199 .86078 L
.84483 .85916 L
.87767 .85693 L
.91051 .85416 L
.94335 .85096 L
.97619 .84742 L
s
P
p
.001 w
.02381 .83008 m
.05665 .82605 L
.08949 .82222 L
.12233 .81877 L
.15517 .81588 L
.18801 .81372 L
.22085 .8124 L
.25369 .81201 L
.28654 .81257 L
.31938 .81405 L
.35222 .81636 L
.38506 .81937 L
.4179 .8229 L
.45074 .82679 L
.48358 .83083 L
.51642 .83485 L
.54926 .83869 L
.5821 .84219 L
.61017 .84483 L
.61494 .84524 L
.64778 .84775 L
.68062 .84962 L
.71346 .85079 L
.74631 .85123 L
.77915 .85092 L
.81199 .84989 L
.84483 .84814 L
.87767 .84574 L
.88854 .84483 L
.91051 .84279 L
.94335 .83936 L
.97619 .83558 L
s
P
p
.001 w
.02381 .81676 m
.05665 .81236 L
.05948 .81199 L
.08949 .8082 L
.12233 .80445 L
.15517 .8013 L
.18801 .79894 L
.22085 .7975 L
.25369 .79708 L
.28654 .7977 L
.31938 .79931 L
.35222 .80183 L
.38506 .8051 L
.4179 .80894 L
.44187 .81199 L
.45074 .81316 L
.48358 .81758 L
.51642 .82196 L
.54926 .82614 L
.5821 .82994 L
.61494 .83324 L
.64778 .83593 L
.68062 .83793 L
.71346 .83918 L
.74631 .83965 L
.77915 .83933 L
.81199 .83822 L
.84483 .83635 L
.87767 .83378 L
.91051 .83059 L
.94335 .82687 L
.97619 .82275 L
s
P
p
.001 w
.02381 .80227 m
.05665 .79746 L
.08949 .79287 L
.12233 .78871 L
.15517 .78521 L
.18801 .78258 L
.22085 .78098 L
.25369 .78051 L
.28654 .7812 L
.31938 .783 L
.35222 .7858 L
.38506 .78943 L
.4179 .79369 L
.45074 .79834 L
.48358 .80316 L
.51642 .80792 L
.54578 .81199 L
.54926 .81245 L
.5821 .81661 L
.61494 .82021 L
.64778 .82314 L
.68062 .82531 L
.71346 .82667 L
.74631 .82719 L
.77915 .82683 L
.81199 .82563 L
.84483 .8236 L
.87767 .8208 L
.91051 .81732 L
.94335 .81326 L
.95284 .81199 L
.97619 .80878 L
s
P
p
.001 w
.02381 .78628 m
.05665 .78094 L
.06784 .77915 L
.08949 .77584 L
.12233 .77123 L
.15517 .76734 L
.18801 .76441 L
.22085 .76262 L
.25369 .76209 L
.28654 .76285 L
.31938 .76487 L
.35222 .76799 L
.38506 .77203 L
.4179 .77675 L
.4335 .77915 L
.45074 .78191 L
.48358 .78727 L
.51642 .79256 L
.54926 .79756 L
.5821 .8021 L
.61494 .80602 L
.64778 .8092 L
.68062 .81156 L
.68468 .81199 L
.71346 .81304 L
.74631 .8136 L
.77915 .81322 L
.8103 .81199 L
.81199 .8119 L
.84483 .8097 L
.87767 .80666 L
.91051 .80287 L
.94335 .79844 L
.97619 .79351 L
s
P
p
.001 w
.02381 .76853 m
.05665 .76256 L
.08949 .75681 L
.12233 .75157 L
.15517 .74714 L
.1617 .74631 L
.18801 .74381 L
.22085 .74178 L
.25369 .74118 L
.28654 .74205 L
.31938 .74433 L
.33968 .74631 L
.35222 .74788 L
.38506 .75248 L
.4179 .75784 L
.45074 .76366 L
.48358 .76963 L
.51642 .7755 L
.53775 .77915 L
.54926 .78105 L
.5821 .7861 L
.61494 .79044 L
.64778 .79397 L
.68062 .79658 L
.71346 .79821 L
.74631 .79882 L
.77915 .7984 L
.81199 .79695 L
.84483 .79452 L
.87767 .79116 L
.91051 .78695 L
.94335 .78202 L
.96083 .77915 L
.97619 .77655 L
s
P
p
.001 w
.02381 .7485 m
.03442 .74631 L
.05665 .74172 L
.08949 .73517 L
.12233 .72917 L
.15517 .72406 L
.18801 .72019 L
.22085 .71781 L
.25369 .71711 L
.28654 .71813 L
.31938 .7208 L
.35222 .72492 L
.38506 .73022 L
.4179 .73635 L
.45074 .74296 L
.467 .74631 L
.48358 .74975 L
.51642 .75643 L
.54926 .76269 L
.5821 .76832 L
.61494 .77316 L
.64778 .77706 L
.66964 .77915 L
.68062 .77995 L
.71346 .78177 L
.74631 .78245 L
.77915 .78198 L
.81199 .78037 L
.82937 .77915 L
.84483 .77767 L
.87767 .77395 L
.91051 .76928 L
.94335 .76378 L
.97619 .75762 L
s
P
p
.001 w
.02381 .72563 m
.05665 .71774 L
.07464 .71346 L
.08949 .71008 L
.12233 .70304 L
.15517 .69702 L
.18801 .69242 L
.22085 .68959 L
.25369 .68875 L
.28654 .68996 L
.31938 .69314 L
.35222 .69803 L
.38506 .70427 L
.4179 .71145 L
.42668 .71346 L
.45074 .71919 L
.48358 .72708 L
.51642 .73473 L
.54926 .74186 L
.57162 .74631 L
.5821 .74826 L
.61494 .75376 L
.64778 .7582 L
.68062 .76146 L
.71346 .76349 L
.74631 .76425 L
.77915 .76373 L
.81199 .76193 L
.84483 .75889 L
.87767 .75467 L
.91051 .74935 L
.92706 .74631 L
.94335 .7431 L
.97619 .73609 L
s
P
p
.001 w
.02381 .69887 m
.05665 .6895 L
.0882 .68062 L
.08949 .68027 L
.12233 .67175 L
.15517 .66439 L
.18801 .65872 L
.22085 .65521 L
.25369 .65417 L
.28654 .65568 L
.31938 .65962 L
.35222 .66564 L
.38506 .67325 L
.41317 .68062 L
.4179 .68194 L
.45074 .69123 L
.48358 .70058 L
.51642 .70956 L
.53144 .71346 L
.54926 .71791 L
.5821 .72536 L
.61494 .73168 L
.64778 .73675 L
.68062 .74047 L
.71346 .74277 L
.74631 .74363 L
.77915 .74304 L
.81199 .741 L
.84483 .73754 L
.87767 .73272 L
.91051 .72661 L
.94335 .71936 L
.96715 .71346 L
.97619 .71115 L
s
P
p
.001 w
.02381 .66666 m
.05665 .65511 L
.07732 .64778 L
.08949 .64359 L
.12233 .63276 L
.15517 .62326 L
.18801 .61586 L
.19314 .61494 L
.22085 .61127 L
.25369 .6099 L
.28654 .61188 L
.31272 .61494 L
.31938 .61703 L
.35222 .62488 L
.38506 .63468 L
.4179 .64567 L
.424 .64778 L
.45074 .65725 L
.48358 .66875 L
.51642 .67966 L
.51946 .68062 L
.54926 .6897 L
.5821 .69855 L
.61494 .706 L
.64778 .71192 L
.65754 .71346 L
.68062 .71627 L
.71346 .71897 L
.74631 .71998 L
.77915 .71929 L
.81199 .7169 L
.84093 .71346 L
.84483 .71284 L
.87767 .70721 L
.91051 .70003 L
.94335 .69143 L
.97619 .68158 L
s
P
p
.001 w
.02381 .6262 m
.04846 .61494 L
.05665 .61113 L
.08949 .59579 L
.11954 .5821 L
.12233 .5809 L
.15517 .56763 L
.18801 .55704 L
.22085 .55031 L
.22985 .54926 L
.25369 .54828 L
.27147 .54926 L
.28654 .55121 L
.31938 .55874 L
.35222 .56991 L
.38184 .5821 L
.38506 .58356 L
.4179 .59861 L
.45074 .61394 L
.45292 .61494 L
.48358 .6289 L
.51642 .64281 L
.52901 .64778 L
.54926 .65536 L
.5821 .66627 L
.61494 .67534 L
.63809 .68062 L
.64778 .68251 L
.68062 .68775 L
.71346 .69097 L
.74631 .69218 L
.77915 .69135 L
.81199 .6885 L
.84483 .68363 L
.86066 .68062 L
.87767 .67681 L
.91051 .66808 L
.94335 .6575 L
.96958 .64778 L
.97619 .64523 L
s
P
p
.001 w
.02381 .57178 m
.05665 .5501 L
.05786 .54926 L
.08949 .52702 L
.10409 .51642 L
.12233 .50349 L
.15134 .48358 L
.15517 .48118 L
.18801 .46251 L
.21839 .45074 L
.22085 .45009 L
.25369 .44627 L
.28294 .45074 L
.28654 .45178 L
.31938 .46557 L
.35009 .48358 L
.35222 .4851 L
.38506 .50779 L
.39722 .51642 L
.4179 .53136 L
.44349 .54926 L
.45074 .55424 L
.48358 .57555 L
.49441 .5821 L
.51642 .59473 L
.54926 .61146 L
.5568 .61494 L
.5821 .62569 L
.61494 .63734 L
.64778 .64639 L
.65344 .64778 L
.68062 .65292 L
.71346 .65693 L
.74631 .65842 L
.77915 .6574 L
.81199 .65385 L
.84479 .64778 L
.84483 .64777 L
.87767 .6392 L
.91051 .62804 L
.94185 .61494 L
.94335 .61426 L
.97619 .59801 L
s
P
p
.001 w
.02381 .48829 m
.0282 .48358 L
.05585 .45074 L
.05665 .4497 L
.07963 .4179 L
.08949 .403 L
.10046 .38506 L
.11907 .35222 L
.12233 .34615 L
.13555 .31938 L
.1509 .28654 L
.15517 .27708 L
.16424 .25369 L
.17747 .22085 L
.18801 .19545 L
.19084 .18801 L
.20342 .15517 L
.21677 .12233 L
.22085 .11329 L
.23419 .08949 L
.25369 .07807 L
.26715 .08949 L
.28457 .12233 L
.28654 .12689 L
.30202 .15517 L
.31451 .18801 L
.31938 .21123 L
.32338 .22085 L
.33701 .25369 L
.35048 .28654 L
.35222 .29079 L
.36574 .31938 L
.38229 .35222 L
.38506 .35748 L
.40087 .38506 L
.4179 .41229 L
.42168 .4179 L
.44551 .45074 L
.45074 .4574 L
.47319 .48358 L
.48358 .49464 L
.50621 .51642 L
.51642 .52538 L
.54737 .54926 L
.54926 .55058 L
.5821 .57107 L
.60356 .5821 L
.61494 .58724 L
.64778 .59958 L
.68062 .60827 L
Mistroke
.71346 .61352 L
.7307 .61494 L
.74631 .61546 L
.76798 .61494 L
.77915 .61412 L
.81199 .60949 L
.84483 .60144 L
.87767 .5898 L
.89513 .5821 L
.91051 .57435 L
.94335 .55471 L
.95126 .54926 L
.97619 .53043 L
Mfstroke
P
p
.001 w
.97619 .41033 m
.97167 .4179 L
.94927 .45074 L
.94335 .45826 L
.92022 .48358 L
.91051 .49263 L
.8796 .51642 L
.87767 .51767 L
.84483 .53566 L
.81199 .54768 L
.8061 .54926 L
.77915 .55451 L
.74631 .55647 L
.71346 .55362 L
.68793 .54926 L
.68062 .54587 L
.64778 .53283 L
.61899 .51642 L
.61494 .51364 L
.5821 .48706 L
.57847 .48358 L
.54937 .45074 L
.54926 .4506 L
.52694 .4179 L
.51642 .3994 L
.50914 .38506 L
.49476 .35222 L
.48358 .32107 L
.48303 .31938 L
.47344 .28654 L
.46557 .25369 L
.4591 .22085 L
.45378 .18801 L
.45074 .16584 L
.44943 .15517 L
.44587 .12233 L
.44295 .08949 L
.44056 .05665 L
.43861 .02381 L
s
P
p
.001 w
.02381 .30138 m
.02794 .28654 L
.03585 .25369 L
.04231 .22085 L
.0476 .18801 L
.05194 .15517 L
.05549 .12233 L
.05665 .11006 L
.0584 .08949 L
.06079 .05665 L
.06274 .02381 L
s
P
p
.001 w
.95599 .02381 m
.95411 .05665 L
.95179 .08949 L
.94892 .12233 L
.94537 .15517 L
.94335 .17118 L
.94097 .18801 L
.93548 .22085 L
.92861 .25369 L
.91994 .28654 L
.91051 .31501 L
.90889 .31938 L
.8947 .35222 L
.87767 .38187 L
.87559 .38506 L
.84844 .4179 L
.84483 .42127 L
.81199 .44512 L
.80037 .45074 L
.77915 .4579 L
.74631 .46147 L
.71346 .45626 L
.69356 .45074 L
.68062 .44165 L
.65012 .4179 L
.64778 .41538 L
.62297 .38506 L
.61494 .37222 L
.60399 .35222 L
.58973 .31938 L
.5821 .29739 L
.57875 .28654 L
.57006 .25369 L
.56318 .22085 L
.55768 .18801 L
.55327 .15517 L
.54972 .12233 L
.54926 .11758 L
.54684 .08949 L
.5445 .05665 L
.54261 .02381 L
s
P
p
.001 w
.81845 .02381 m
.81361 .05665 L
.81199 .06589 L
.80753 .08949 L
.7993 .12233 L
.78688 .15517 L
.77915 .16894 L
.75848 .18801 L
.74631 .18973 L
.74014 .18801 L
.71346 .15857 L
.71104 .15517 L
.69476 .12233 L
.68673 .08949 L
.68273 .05665 L
.68066 .02381 L
s
P
P
p
p
.001 w
.26067 .02381 m
.25469 .02961 L
.24507 .02692 L
.23985 .02381 L
s
P
p
.001 w
.28534 .02381 m
.28355 .02423 L
.27393 .02702 L
.26431 .0314 L
.25469 .04185 L
.24507 .03896 L
.23545 .03049 L
.22583 .02649 L
.21621 .02386 L
.216 .02381 L
s
P
p
.001 w
.3881 .02381 m
.37975 .02437 L
.37013 .02506 L
.36051 .02579 L
.35089 .02658 L
.34127 .02745 L
.33165 .02841 L
.32203 .02948 L
.31241 .03071 L
.30279 .03214 L
.29317 .03387 L
.28355 .03607 L
.27393 .03906 L
.26513 .04325 L
.26431 .04378 L
.25469 .05512 L
.24507 .05197 L
.23594 .04325 L
.23545 .0428 L
.22583 .03849 L
.21621 .03567 L
.20659 .03356 L
.19697 .03189 L
.18735 .03049 L
.17773 .0293 L
.16811 .02824 L
.15849 .0273 L
.14887 .02645 L
.13925 .02567 L
.12963 .02494 L
.12001 .02426 L
.11323 .02381 L
s
P
p
.001 w
.97619 .02802 m
.96657 .02752 L
.95695 .02702 L
.94733 .02651 L
.93771 .02599 L
.92809 .02546 L
.91847 .02491 L
.90885 .02435 L
.89989 .02381 L
s
P
p
.001 w
.02381 .03034 m
.03343 .03085 L
.04305 .03137 L
.05267 .03189 L
.06229 .03243 L
.07191 .03298 L
.08153 .03356 L
.09115 .03415 L
.10077 .03477 L
.11039 .03542 L
.12001 .0361 L
.12963 .03683 L
.13925 .03761 L
.14887 .03845 L
.15849 .03937 L
.16811 .04038 L
.17773 .04151 L
.18735 .04281 L
.19032 .04325 L
.19697 .04431 L
.20659 .04613 L
.21621 .0484 L
.22583 .05147 L
.23545 .05616 L
.24026 .06268 L
.24507 .06617 L
.25469 .06961 L
.26033 .06268 L
.26431 .05723 L
.27393 .05209 L
.28355 .04884 L
.29317 .04646 L
.30279 .04459 L
.31102 .04325 L
.31241 .04304 L
.32203 .04171 L
.33165 .04056 L
.34127 .03953 L
.35089 .03859 L
.36051 .03774 L
.37013 .03695 L
.37975 .03622 L
.38937 .03553 L
.39899 .03487 L
.40861 .03425 L
.41823 .03365 L
.42785 .03308 L
.43747 .03252 L
.44709 .03198 L
.45671 .03145 L
Mistroke
.46633 .03094 L
.47595 .03043 L
.48557 .02992 L
.49519 .02943 L
.50481 .02893 L
.51443 .02844 L
.52405 .02794 L
.53367 .02744 L
.54329 .02693 L
.55291 .02642 L
.56253 .0259 L
.57215 .02537 L
.58177 .02482 L
.59139 .02426 L
.59877 .02381 L
Mfstroke
P
p
.001 w
.97619 .04014 m
.96657 .0396 L
.95695 .03906 L
.94733 .03851 L
.93771 .03795 L
.92809 .03738 L
.91847 .0368 L
.90885 .03619 L
.89923 .03557 L
.88961 .03492 L
.87999 .03424 L
.87037 .03352 L
.86075 .03277 L
.85113 .03195 L
.84151 .03108 L
.83189 .03012 L
.82227 .02906 L
.81265 .02787 L
.80303 .02651 L
.79341 .0249 L
.78781 .02381 L
s
P
p
.001 w
.02381 .04265 m
.03343 .04319 L
.03433 .04325 L
.04305 .04375 L
.05267 .04432 L
.06229 .0449 L
.07191 .0455 L
.08153 .04612 L
.09115 .04676 L
.10077 .04743 L
.11039 .04813 L
.12001 .04887 L
.12963 .04966 L
.13925 .05051 L
.14887 .05142 L
.15849 .05242 L
.16811 .05352 L
.17773 .05476 L
.18735 .05616 L
.19697 .05781 L
.20659 .05978 L
.21621 .06227 L
.21758 .06268 L
.22583 .06562 L
.23545 .07075 L
.24507 .08176 L
.24545 .08212 L
.25469 .08556 L
.25752 .08212 L
.26431 .07192 L
.27393 .0663 L
.28355 .06275 L
.28376 .06268 L
.29317 .06015 L
.30279 .0581 L
.31241 .05641 L
.32203 .05497 L
.33165 .05371 L
.34127 .05259 L
.35089 .05158 L
.36051 .05065 L
.37013 .0498 L
.37975 .049 L
.38937 .04825 L
.39899 .04754 L
.40861 .04687 L
.41823 .04622 L
.42785 .0456 L
.43747 .045 L
.44709 .04441 L
Mistroke
.45671 .04384 L
.46633 .04328 L
.467 .04325 L
.47595 .04274 L
.48557 .04219 L
.49519 .04166 L
.50481 .04112 L
.51443 .04059 L
.52405 .04005 L
.53367 .03951 L
.54329 .03897 L
.55291 .03842 L
.56253 .03786 L
.57215 .03729 L
.58177 .0367 L
.59139 .03609 L
.60101 .03547 L
.61063 .03481 L
.62025 .03413 L
.62987 .0334 L
.63949 .03264 L
.64911 .03181 L
.65873 .03093 L
.66835 .02995 L
.67797 .02888 L
.68759 .02766 L
.69721 .02627 L
.70683 .02461 L
.71086 .02381 L
Mfstroke
P
p
.001 w
.97619 .05326 m
.96657 .05268 L
.95695 .05209 L
.94733 .05149 L
.93771 .05088 L
.92809 .05026 L
.91847 .04963 L
.90885 .04898 L
.89923 .0483 L
.88961 .0476 L
.87999 .04686 L
.87037 .04608 L
.86075 .04526 L
.85113 .04438 L
.84151 .04344 L
.83968 .04325 L
.83189 .0424 L
.82227 .04126 L
.81265 .03998 L
.80303 .03852 L
.79341 .03679 L
.78379 .03467 L
.77417 .03191 L
.76455 .02788 L
.76093 .02381 L
s
P
p
.001 w
.02381 .05599 m
.03343 .05659 L
.04305 .05719 L
.05267 .05781 L
.06229 .05845 L
.07191 .0591 L
.08153 .05977 L
.09115 .06047 L
.10077 .06121 L
.11039 .06197 L
.11883 .06268 L
.12001 .06278 L
.12963 .06365 L
.13925 .06457 L
.14887 .06557 L
.15849 .06666 L
.16811 .06786 L
.17773 .06921 L
.18735 .07075 L
.19697 .07255 L
.20659 .07472 L
.21621 .07746 L
.22583 .08115 L
.22786 .08212 L
.23545 .08682 L
.24507 .09904 L
.24773 .10155 L
.25469 .1033 L
.25609 .10155 L
.26431 .08811 L
.27349 .08212 L
.27393 .0819 L
.28355 .07798 L
.29317 .07513 L
.30279 .07288 L
.31241 .07103 L
.32203 .06945 L
.33165 .06807 L
.34127 .06685 L
.35089 .06574 L
.36051 .06473 L
.37013 .06379 L
.37975 .06292 L
.38251 .06268 L
.38937 .0621 L
.39899 .06133 L
.40861 .06059 L
.41823 .05989 L
.42785 .05921 L
.43747 .05855 L
Mistroke
.44709 .05791 L
.45671 .05729 L
.46633 .05668 L
.47595 .05609 L
.48557 .0555 L
.49519 .05491 L
.50481 .05433 L
.51443 .05375 L
.52405 .05317 L
.53367 .05258 L
.54329 .05199 L
.55291 .05139 L
.56253 .05078 L
.57215 .05016 L
.58177 .04952 L
.59139 .04887 L
.60101 .04819 L
.61063 .04748 L
.62025 .04673 L
.62987 .04595 L
.63949 .04512 L
.64911 .04423 L
.65873 .04327 L
.65899 .04325 L
.66835 .04222 L
.67797 .04106 L
.68759 .03976 L
.69721 .03825 L
.70683 .03647 L
.71645 .03427 L
.72607 .03136 L
.73569 .02699 L
.73858 .02381 L
Mfstroke
P
p
.001 w
.02381 .07056 m
.03343 .07122 L
.04305 .07188 L
.05267 .07256 L
.06229 .07326 L
.07191 .07397 L
.08153 .07471 L
.09115 .07548 L
.10077 .07629 L
.11039 .07713 L
.12001 .07802 L
.12963 .07897 L
.13925 .07999 L
.14887 .08109 L
.15711 .08212 L
.15849 .0823 L
.16811 .08363 L
.17773 .08512 L
.18735 .08682 L
.19697 .08882 L
.20659 .09122 L
.21621 .09426 L
.22583 .09837 L
.23133 .10155 L
.23545 .1047 L
.24507 .11845 L
.24741 .12099 L
.25469 .12326 L
.25628 .12099 L
.26431 .10615 L
.27 .10155 L
.27393 .0992 L
.28355 .09484 L
.29317 .09167 L
.30279 .08918 L
.31241 .08713 L
.32203 .08538 L
.33165 .08386 L
.34127 .08251 L
.34422 .08212 L
.35089 .08128 L
.36051 .08017 L
.37013 .07914 L
.37975 .07817 L
.38937 .07727 L
.39899 .07642 L
.40861 .07561 L
.41823 .07484 L
.42785 .07409 L
.43747 .07337 L
Mistroke
.44709 .07267 L
.45671 .07199 L
.46633 .07132 L
.47595 .07067 L
.48557 .07002 L
.49519 .06938 L
.50481 .06874 L
.51443 .06811 L
.52405 .06747 L
.53367 .06683 L
.54329 .06619 L
.55291 .06553 L
.56253 .06487 L
.57215 .06419 L
.58177 .06349 L
.59139 .06278 L
.59263 .06268 L
.60101 .06203 L
.61063 .06126 L
.62025 .06045 L
.62987 .05959 L
.63949 .05869 L
.64911 .05772 L
.65873 .05667 L
.66835 .05553 L
.67797 .05426 L
.68759 .05284 L
.69721 .05121 L
.70683 .04928 L
.71645 .04689 L
.72607 .04375 L
.72735 .04325 L
.73569 .03903 L
.74531 .02875 L
.75493 .03147 L
.76455 .03998 L
.77131 .04325 L
.77417 .04434 L
.78379 .04732 L
.79341 .04962 L
.80303 .05149 L
.81265 .05309 L
.82227 .05448 L
.83189 .05572 L
.84151 .05685 L
.85113 .05788 L
.86075 .05884 L
.87037 .05974 L
.87999 .06058 L
.88961 .06139 L
Mistroke
.89923 .06216 L
.90604 .06268 L
.90885 .0629 L
.91847 .06361 L
.92809 .0643 L
.93771 .06498 L
.94733 .06564 L
.95695 .06629 L
.96657 .06694 L
.97619 .06758 L
Mfstroke
P
p
.001 w
.02381 .08661 m
.03343 .08733 L
.04305 .08807 L
.05267 .08882 L
.06229 .08959 L
.07191 .09039 L
.08153 .09121 L
.09115 .09206 L
.10077 .09295 L
.11039 .09389 L
.12001 .09489 L
.12963 .09594 L
.13925 .09708 L
.14887 .0983 L
.15849 .09965 L
.16811 .10113 L
.17066 .10155 L
.17773 .1028 L
.18735 .1047 L
.19697 .10694 L
.20659 .10963 L
.21621 .11305 L
.22583 .11768 L
.23093 .12099 L
.23545 .12485 L
.24491 .14043 L
.24507 .14056 L
.25469 .1461 L
.25784 .14043 L
.26431 .12649 L
.2704 .12099 L
.27393 .11862 L
.28355 .1137 L
.29317 .11014 L
.30279 .10734 L
.31241 .10504 L
.32203 .10309 L
.33067 .10155 L
.33165 .10139 L
.34127 .09988 L
.35089 .09851 L
.36051 .09727 L
.37013 .09612 L
.37975 .09505 L
.38937 .09405 L
.39899 .0931 L
.40861 .09221 L
.41823 .09135 L
.42785 .09052 L
.43747 .08972 L
Mistroke
.44709 .08895 L
.45671 .08819 L
.46633 .08745 L
.47595 .08673 L
.48557 .08601 L
.49519 .08531 L
.50481 .0846 L
.51443 .0839 L
.52405 .0832 L
.53367 .08249 L
.53872 .08212 L
.54329 .08178 L
.55291 .08106 L
.56253 .08032 L
.57215 .07957 L
.58177 .07881 L
.59139 .07801 L
.60101 .0772 L
.61063 .07634 L
.62025 .07545 L
.62987 .07452 L
.63949 .07352 L
.64911 .07246 L
.65873 .07131 L
.66835 .07006 L
.67797 .06867 L
.68759 .06712 L
.69721 .06533 L
.70683 .06322 L
.70903 .06268 L
.71645 .06062 L
.72607 .05719 L
.73569 .05206 L
.74278 .04325 L
.74531 .04093 L
.75409 .04325 L
.75493 .04386 L
.76455 .05309 L
.77417 .05783 L
.78379 .06109 L
.78964 .06268 L
.79341 .0636 L
.80303 .06565 L
.81265 .06739 L
.82227 .06891 L
.83189 .07027 L
.84151 .0715 L
.85113 .07264 L
.86075 .07369 L
.87037 .07467 L
Mistroke
.87999 .0756 L
.88961 .07649 L
.89923 .07733 L
.90885 .07815 L
.91847 .07893 L
.92809 .0797 L
.93771 .08044 L
.94733 .08118 L
.95695 .0819 L
.95994 .08212 L
.96657 .08261 L
.97619 .08331 L
Mfstroke
P
p
.001 w
.02381 .10447 m
.03343 .10528 L
.04305 .1061 L
.05267 .10694 L
.06229 .10781 L
.07191 .1087 L
.08153 .10962 L
.09115 .11058 L
.10077 .11158 L
.11039 .11264 L
.12001 .11375 L
.12963 .11494 L
.13925 .11622 L
.14887 .11761 L
.15849 .11913 L
.16811 .12081 L
.1691 .12099 L
.17773 .12269 L
.18735 .12486 L
.19697 .12739 L
.20659 .13047 L
.21621 .13436 L
.22583 .13968 L
.22694 .14043 L
.23545 .14794 L
.24031 .15986 L
.24507 .16624 L
.25469 .17278 L
.26029 .15986 L
.26431 .14984 L
.27393 .14076 L
.2744 .14043 L
.28355 .13511 L
.29317 .13104 L
.30279 .12786 L
.31241 .12524 L
.32203 .12303 L
.33165 .1211 L
.33223 .12099 L
.34127 .11939 L
.35089 .11785 L
.36051 .11644 L
.37013 .11515 L
.37975 .11394 L
.38937 .11282 L
.39899 .11175 L
.40861 .11074 L
.41823 .10977 L
.42785 .10885 L
.43747 .10795 L
Mistroke
.44709 .10708 L
.45671 .10624 L
.46633 .10541 L
.47595 .1046 L
.48557 .1038 L
.49519 .10301 L
.50481 .10222 L
.51298 .10155 L
.51443 .10144 L
.52405 .10065 L
.53367 .09986 L
.54329 .09907 L
.55291 .09826 L
.56253 .09744 L
.57215 .09661 L
.58177 .09575 L
.59139 .09487 L
.60101 .09397 L
.61063 .09302 L
.62025 .09203 L
.62987 .09099 L
.63949 .08989 L
.64911 .08871 L
.65873 .08744 L
.66835 .08605 L
.67797 .08453 L
.68759 .08281 L
.69112 .08212 L
.69721 .08084 L
.70683 .07851 L
.71645 .07564 L
.72607 .07188 L
.73569 .06626 L
.73825 .06268 L
.74531 .05412 L
.75493 .05731 L
.76124 .06268 L
.76455 .06739 L
.77417 .07258 L
.78379 .07616 L
.79341 .07892 L
.80303 .08118 L
.80754 .08212 L
.81265 .0831 L
.82227 .08479 L
.83189 .08629 L
.84151 .08765 L
.85113 .08891 L
.86075 .09007 L
.87037 .09116 L
Mistroke
.87999 .0922 L
.88961 .09318 L
.89923 .09412 L
.90885 .09502 L
.91847 .0959 L
.92809 .09675 L
.93771 .09758 L
.94733 .09839 L
.95695 .0992 L
.96657 .09999 L
.97619 .10078 L
Mfstroke
P
p
.001 w
.02381 .12459 m
.03343 .12551 L
.04305 .12644 L
.05267 .1274 L
.06229 .12838 L
.07191 .1294 L
.08153 .13045 L
.09115 .13154 L
.10077 .13269 L
.11039 .1339 L
.12001 .13517 L
.12963 .13654 L
.13925 .138 L
.14887 .13959 L
.15358 .14043 L
.15849 .14134 L
.16811 .14327 L
.17773 .14545 L
.18735 .14794 L
.19697 .15088 L
.20659 .15445 L
.21621 .159 L
.21777 .15986 L
.22583 .16521 L
.23545 .17497 L
.2372 .1793 L
.24507 .19692 L
.24602 .19874 L
.25469 .20488 L
.25715 .19874 L
.26356 .1793 L
.26431 .17723 L
.27393 .16649 L
.28355 .15988 L
.28357 .15986 L
.29317 .15512 L
.30279 .15142 L
.31241 .14839 L
.32203 .14583 L
.33165 .14361 L
.34127 .14164 L
.34775 .14043 L
.35089 .13987 L
.36051 .13826 L
.37013 .13677 L
.37975 .13539 L
.38937 .1341 L
.39899 .13288 L
.40861 .13173 L
.41823 .13063 L
Mistroke
.42785 .12957 L
.43747 .12855 L
.44709 .12756 L
.45671 .1266 L
.46633 .12566 L
.47595 .12474 L
.48557 .12383 L
.49519 .12293 L
.50481 .12204 L
.51443 .12115 L
.51617 .12099 L
.52405 .12026 L
.53367 .11937 L
.54329 .11847 L
.55291 .11756 L
.56253 .11664 L
.57215 .1157 L
.58177 .11473 L
.59139 .11374 L
.60101 .11272 L
.61063 .11165 L
.62025 .11054 L
.62987 .10937 L
.63949 .10814 L
.64911 .10682 L
.65873 .10539 L
.66835 .10384 L
.67797 .10213 L
.68101 .10155 L
.68759 .10022 L
.69721 .09802 L
.70683 .09542 L
.71645 .09224 L
.72607 .08807 L
.73538 .08212 L
.73569 .08186 L
.74531 .06851 L
.75493 .07201 L
.76372 .08212 L
.76455 .08311 L
.77417 .08885 L
.78379 .09282 L
.79341 .09588 L
.80303 .0984 L
.81265 .10055 L
.81766 .10155 L
.82227 .10243 L
.83189 .10411 L
.84151 .10563 L
.85113 .10704 L
Mistroke
.86075 .10834 L
.87037 .10957 L
.87999 .11073 L
.88961 .11183 L
.89923 .11289 L
.90885 .11391 L
.91847 .11489 L
.92809 .11585 L
.93771 .11679 L
.94733 .11771 L
.95695 .11862 L
.96657 .11952 L
.97619 .12041 L
Mfstroke
P
p
.001 w
.02381 .14763 m
.03343 .1487 L
.04305 .14978 L
.05267 .15089 L
.06229 .15203 L
.07191 .15321 L
.08153 .15443 L
.09115 .15571 L
.10077 .15704 L
.11039 .15845 L
.1195 .15986 L
.12001 .15995 L
.12963 .16154 L
.13925 .16325 L
.14887 .16512 L
.15849 .16716 L
.16811 .16944 L
.17773 .17201 L
.18735 .17498 L
.19697 .17847 L
.19902 .1793 L
.20659 .18272 L
.21621 .18816 L
.22583 .19567 L
.22887 .19874 L
.23545 .20756 L
.23844 .21817 L
.24507 .23497 L
.24616 .23761 L
.25469 .24517 L
.25706 .23761 L
.26212 .21817 L
.26431 .21034 L
.27247 .19874 L
.27393 .19721 L
.28355 .18922 L
.29317 .18352 L
.30232 .1793 L
.30279 .17911 L
.31241 .17551 L
.32203 .17247 L
.33165 .16984 L
.34127 .16752 L
.35089 .16544 L
.36051 .16355 L
.37013 .16181 L
.37975 .1602 L
.38183 .15986 L
.38937 .15869 L
.39899 .15727 L
Mistroke
.40861 .15592 L
.41823 .15464 L
.42785 .15341 L
.43747 .15222 L
.44709 .15108 L
.45671 .14996 L
.46633 .14887 L
.47595 .14781 L
.48557 .14676 L
.49519 .14572 L
.50481 .14469 L
.51443 .14367 L
.52405 .14264 L
.53367 .14162 L
.54329 .14058 L
.54475 .14043 L
.55291 .13954 L
.56253 .13848 L
.57215 .1374 L
.58177 .1363 L
.59139 .13516 L
.60101 .13399 L
.61063 .13277 L
.62025 .1315 L
.62987 .13017 L
.63949 .12876 L
.64911 .12726 L
.65873 .12564 L
.66835 .12388 L
.67797 .12194 L
.68233 .12099 L
.68759 .11977 L
.69721 .11729 L
.70683 .11436 L
.71645 .11078 L
.72607 .1061 L
.73292 .10155 L
.73569 .09915 L
.74531 .08434 L
.75493 .08821 L
.76455 .10055 L
.76577 .10155 L
.77417 .10697 L
.78379 .11143 L
.79341 .11488 L
.80303 .11772 L
.81265 .12015 L
.81633 .12099 L
.82227 .12227 L
.83189 .12418 L
Mistroke
.84151 .12591 L
.85113 .12751 L
.86075 .129 L
.87037 .13039 L
.87999 .13172 L
.88961 .13298 L
.89923 .13418 L
.90885 .13535 L
.91847 .13648 L
.92809 .13758 L
.93771 .13866 L
.94733 .13971 L
.95392 .14043 L
.95695 .14075 L
.96657 .14179 L
.97619 .14281 L
Mfstroke
P
p
.001 w
.02381 .1746 m
.03343 .17587 L
.04305 .17716 L
.05267 .17848 L
.05852 .1793 L
.06229 .17984 L
.07191 .18124 L
.08153 .1827 L
.09115 .18422 L
.10077 .18582 L
.11039 .18751 L
.12001 .1893 L
.12963 .19122 L
.13925 .19329 L
.14887 .19555 L
.15849 .19804 L
.16103 .19874 L
.16811 .20081 L
.17773 .20394 L
.18735 .20757 L
.19697 .21187 L
.20659 .21714 L
.20823 .21817 L
.21621 .22393 L
.22583 .23338 L
.2291 .23761 L
.23545 .24863 L
.23749 .25705 L
.24159 .27648 L
.24507 .28512 L
.24877 .29592 L
.25469 .29928 L
.25552 .29592 L
.25943 .27648 L
.26325 .25705 L
.26431 .25223 L
.27224 .23761 L
.27393 .23534 L
.28355 .22524 L
.2931 .21817 L
.29317 .21813 L
.30279 .21265 L
.31241 .20822 L
.32203 .2045 L
.33165 .20129 L
.34031 .19874 L
.34127 .19847 L
.35089 .19594 L
.36051 .19365 L
.37013 .19155 L
Mistroke
.37975 .1896 L
.38937 .18779 L
.39899 .18609 L
.40861 .18448 L
.41823 .18294 L
.42785 .18148 L
.43747 .18006 L
.44282 .1793 L
.44709 .1787 L
.45671 .17737 L
.46633 .17608 L
.47595 .17481 L
.48557 .17356 L
.49519 .17234 L
.50481 .17112 L
.51443 .16991 L
.52405 .1687 L
.53367 .16749 L
.54329 .16628 L
.55291 .16505 L
.56253 .16381 L
.57215 .16255 L
.58177 .16126 L
.59139 .15993 L
.59186 .15986 L
.60101 .15856 L
.61063 .15714 L
.62025 .15566 L
.62987 .15411 L
.63949 .15247 L
.64911 .15072 L
.65873 .14885 L
.66835 .14682 L
.67797 .14458 L
.68759 .14208 L
.69332 .14043 L
.69721 .13922 L
.70683 .13587 L
.71645 .13177 L
.72607 .12644 L
.73325 .12099 L
.73569 .11857 L
.74531 .10193 L
.75493 .10626 L
.76455 .12015 L
.76544 .12099 L
.77417 .12743 L
.78379 .13251 L
.79341 .13646 L
.80303 .13972 L
Mistroke
.80534 .14043 L
.81265 .14251 L
.82227 .14496 L
.83189 .14716 L
.84151 .14917 L
.85113 .15102 L
.86075 .15274 L
.87037 .15437 L
.87999 .15591 L
.88961 .15738 L
.89923 .15879 L
.9068 .15986 L
.90885 .16015 L
.91847 .16147 L
.92809 .16276 L
.93771 .16402 L
.94733 .16525 L
.95695 .16648 L
.96657 .16769 L
.97619 .1689 L
Mfstroke
P
p
.001 w
.02381 .20711 m
.03343 .20867 L
.04305 .21025 L
.05267 .21188 L
.06229 .21356 L
.07191 .2153 L
.08153 .21711 L
.08698 .21817 L
.09115 .21901 L
.10077 .221 L
.11039 .2231 L
.12001 .22535 L
.12963 .22776 L
.13925 .23038 L
.14887 .23323 L
.15849 .23639 L
.16193 .23761 L
.16811 .23993 L
.17773 .24395 L
.18735 .24864 L
.19697 .25423 L
.20116 .25705 L
.20659 .26114 L
.21621 .27016 L
.22145 .27648 L
.22583 .28295 L
.23242 .29592 L
.23545 .30417 L
.23737 .31535 L
.23977 .33479 L
.24371 .35423 L
.24507 .35885 L
.24808 .37366 L
.25469 .38202 L
.25589 .37366 L
.25834 .35423 L
.26074 .33479 L
.26338 .31535 L
.26431 .30931 L
.2689 .29592 L
.27393 .28563 L
.27988 .27648 L
.28355 .27193 L
.29317 .26245 L
.30017 .25705 L
.30279 .25526 L
.31241 .24948 L
.32203 .24467 L
.33165 .24055 L
.3394 .23761 L
Mistroke
.34127 .23694 L
.35089 .23373 L
.36051 .23083 L
.37013 .22818 L
.37975 .22573 L
.38937 .22346 L
.39899 .22133 L
.40861 .21932 L
.41436 .21817 L
.41823 .21742 L
.42785 .21559 L
.43747 .21384 L
.44709 .21215 L
.45671 .21051 L
.46633 .20892 L
.47595 .20737 L
.48557 .20584 L
.49519 .20434 L
.50481 .20285 L
.51443 .20138 L
.52405 .19991 L
.53172 .19874 L
.53367 .19844 L
.54329 .19696 L
.55291 .19547 L
.56253 .19397 L
.57215 .19244 L
.58177 .19088 L
.59139 .18928 L
.60101 .18764 L
.61063 .18593 L
.62025 .18416 L
.62987 .18231 L
.63949 .18036 L
.64446 .1793 L
.64911 .17828 L
.65873 .17605 L
.66835 .17364 L
.67797 .17099 L
.68759 .16804 L
.69721 .16468 L
.70683 .16076 L
.7088 .15986 L
.71645 .15598 L
.72607 .14978 L
.73569 .1407 L
.73582 .14043 L
.74531 .12171 L
.75493 .12663 L
.7634 .14043 L
Mistroke
.76455 .14251 L
.77417 .15093 L
.78379 .15684 L
.78987 .15986 L
.79341 .16145 L
.80303 .16526 L
.81265 .16854 L
.82227 .17144 L
.83189 .17405 L
.84151 .17643 L
.85113 .17863 L
.8542 .1793 L
.86075 .18068 L
.87037 .18262 L
.87999 .18446 L
.88961 .18622 L
.89923 .18791 L
.90885 .18955 L
.91847 .19114 L
.92809 .19269 L
.93771 .19422 L
.94733 .19572 L
.95695 .1972 L
.96657 .19868 L
.96695 .19874 L
.97619 .20015 L
Mfstroke
P
p
.001 w
.02381 .24805 m
.03343 .25006 L
.04305 .25212 L
.05267 .25424 L
.06229 .25644 L
.06488 .25705 L
.07191 .25872 L
.08153 .2611 L
.09115 .26361 L
.10077 .26625 L
.11039 .26906 L
.12001 .27207 L
.12963 .27532 L
.13288 .27648 L
.13925 .27886 L
.14887 .28274 L
.15849 .28707 L
.16811 .29196 L
.17503 .29592 L
.17773 .29758 L
.18735 .30418 L
.19697 .31217 L
.20028 .31535 L
.20659 .32223 L
.21567 .33479 L
.21621 .33568 L
.22536 .35423 L
.22583 .35541 L
.23172 .37366 L
.23545 .39035 L
.2358 .3931 L
.23754 .41254 L
.23877 .43197 L
.24006 .45141 L
.24171 .47085 L
.24377 .49028 L
.24507 .50086 L
.24573 .50972 L
.24721 .52915 L
.24884 .54859 L
.25469 .56498 L
.25548 .54859 L
.2564 .52915 L
.25734 .50972 L
.25832 .49028 L
.25936 .47085 L
.26049 .45141 L
.26175 .43197 L
.26318 .41254 L
.26431 .39929 L
Mistroke
.26535 .3931 L
.26961 .37366 L
.27393 .35967 L
.27596 .35423 L
.28355 .33835 L
.28567 .33479 L
.29317 .32415 L
.30106 .31535 L
.30279 .31366 L
.31241 .30538 L
.32203 .29859 L
.32631 .29592 L
.33165 .29283 L
.34127 .28783 L
.35089 .28342 L
.36051 .27947 L
.36846 .27648 L
.37013 .27588 L
.37975 .27259 L
.38937 .26954 L
.39899 .2667 L
.40861 .26403 L
.41823 .2615 L
.42785 .2591 L
.43646 .25705 L
.43747 .25681 L
.44709 .2546 L
.45671 .25246 L
.46633 .25039 L
.47595 .24837 L
.48557 .2464 L
.49519 .24446 L
.50481 .24255 L
.51443 .24066 L
.52405 .23878 L
.53005 .23761 L
.53367 .2369 L
.54329 .23502 L
.55291 .23314 L
.56253 .23123 L
.57215 .2293 L
.58177 .22733 L
.59139 .22533 L
.60101 .22327 L
.61063 .22114 L
.62025 .21893 L
.62348 .21817 L
.62987 .21663 L
.63949 .2142 L
.64911 .21163 L
Mistroke
.65873 .20889 L
.66835 .20593 L
.67797 .20269 L
.68759 .1991 L
.6885 .19874 L
.69721 .19502 L
.70683 .19028 L
.71645 .18454 L
.72357 .1793 L
.72607 .17715 L
.73569 .16641 L
.73821 .15986 L
.74531 .14431 L
.75493 .14999 L
.76127 .15986 L
.76455 .16855 L
.77417 .17852 L
.7751 .1793 L
.78379 .18557 L
.79341 .19111 L
.80303 .19573 L
.81017 .19874 L
.81265 .19971 L
.82227 .20324 L
.83189 .20643 L
.84151 .20935 L
.85113 .21207 L
.86075 .21461 L
.87037 .21701 L
.87519 .21817 L
.87999 .2193 L
.88961 .22149 L
.89923 .22361 L
.90885 .22566 L
.91847 .22766 L
.92809 .22962 L
.93771 .23154 L
.94733 .23345 L
.95695 .23533 L
.96657 .23721 L
.96861 .23761 L
.97619 .23909 L
Mfstroke
P
p
.001 w
.97619 .29079 m
.96657 .2882 L
.95695 .28561 L
.94733 .28303 L
.93771 .28044 L
.92809 .27783 L
.92318 .27648 L
.91847 .27518 L
.90885 .27249 L
.89923 .26974 L
.88961 .26691 L
.87999 .264 L
.87037 .26098 L
.86075 .25782 L
.85848 .25705 L
.85113 .25449 L
.84151 .25095 L
.83189 .24716 L
.82227 .24305 L
.81265 .23853 L
.81081 .23761 L
.80303 .23346 L
.79341 .22763 L
.78379 .22068 L
.78075 .21817 L
.77417 .21193 L
.76455 .19972 L
.76414 .19874 L
.7566 .1793 L
.75493 .17741 L
.74531 .17068 L
.74152 .1793 L
.73569 .19712 L
.73475 .19874 L
.72607 .21024 L
.71791 .21817 L
.71645 .2194 L
.70683 .22658 L
.69721 .23256 L
.68786 .23761 L
.68759 .23774 L
.67797 .24234 L
.66835 .24651 L
.65873 .25035 L
.64911 .25392 L
.64019 .25705 L
.63949 .25728 L
.62987 .26047 L
.62025 .26351 L
.61063 .26644 L
Mistroke
.60101 .26928 L
.59139 .27204 L
.58177 .27474 L
.57549 .27648 L
.57215 .2774 L
.56253 .28001 L
.55291 .28261 L
.54329 .28519 L
.53367 .28777 L
.52405 .29037 L
.51443 .29298 L
.50481 .29562 L
.50372 .29592 L
.49519 .29829 L
.48557 .30102 L
.47595 .30381 L
.46633 .30668 L
.45671 .30964 L
.44709 .31271 L
.4391 .31535 L
.43747 .3159 L
.42785 .31925 L
.41823 .32277 L
.40861 .3265 L
.39899 .33047 L
.38937 .33474 L
.38926 .33479 L
.37975 .33935 L
.37013 .34439 L
.36051 .34995 L
.35376 .35423 L
.35089 .35616 L
.34127 .36319 L
.33165 .3713 L
.32911 .37366 L
.32203 .38085 L
.31241 .39244 L
.31192 .3931 L
.30279 .40704 L
.29975 .41254 L
.29317 .42648 L
.29096 .43197 L
.28448 .45141 L
.28355 .45473 L
.2796 .47085 L
.27588 .49028 L
.27393 .50286 L
.27298 .50972 L
.27067 .52915 L
.26883 .54859 L
Mistroke
.26736 .56803 L
.26616 .58746 L
.26517 .6069 L
.26436 .62634 L
.26431 .6277 L
.26394 .64577 L
.2636 .66521 L
.2633 .68465 L
.26304 .70408 L
.26281 .72352 L
.2626 .74295 L
.26242 .76239 L
.26227 .78183 L
.26213 .80126 L
.262 .8207 L
.26189 .84014 L
.2618 .85957 L
.26171 .87901 L
.26164 .89845 L
.26157 .91788 L
.26151 .93732 L
.26146 .95675 L
.26142 .97619 L
Mfstroke
P
p
.001 w
.02381 .30335 m
.03343 .3062 L
.04305 .30915 L
.05267 .3122 L
.06224 .31535 L
.06229 .31537 L
.07191 .31869 L
.08153 .32218 L
.09115 .32587 L
.10077 .3298 L
.11039 .33402 L
.11208 .33479 L
.12001 .33857 L
.12963 .34353 L
.13925 .349 L
.14757 .35423 L
.14887 .35509 L
.15849 .36197 L
.16811 .36988 L
.17223 .37366 L
.17773 .37917 L
.18735 .39037 L
.18941 .3931 L
.19697 .40438 L
.20158 .41254 L
.20659 .42284 L
.21038 .43197 L
.21621 .4492 L
.21685 .45141 L
.22173 .47085 L
.22545 .49028 L
.22583 .49257 L
.22836 .50972 L
.23066 .52915 L
.23249 .54859 L
.23396 .56803 L
.23515 .58746 L
.23545 .59297 L
.23592 .6069 L
.23644 .62634 L
.23684 .64577 L
.23717 .66521 L
.23744 .68465 L
.23767 .70408 L
.23787 .72352 L
.23804 .74295 L
.23819 .76239 L
.23832 .78183 L
.23844 .80126 L
.23854 .8207 L
Mistroke
.23864 .84014 L
.23872 .85957 L
.2388 .87901 L
.23886 .89845 L
.23892 .91788 L
.23898 .93732 L
.23903 .95675 L
.23907 .97619 L
Mfstroke
P
p
.001 w
.97619 .36798 m
.96657 .36378 L
.95695 .35964 L
.94733 .35555 L
.94421 .35423 L
.93771 .35147 L
.92809 .3474 L
.91847 .34331 L
.90885 .3392 L
.89923 .33504 L
.89867 .33479 L
.88961 .33079 L
.87999 .32645 L
.87037 .32199 L
.86075 .31737 L
.85668 .31535 L
.85113 .31255 L
.84151 .30747 L
.83189 .30209 L
.82227 .29632 L
.82163 .29592 L
.81265 .29002 L
.80303 .28305 L
.79495 .27648 L
.79341 .27514 L
.78379 .26584 L
.77623 .25705 L
.77417 .25431 L
.76455 .23854 L
.76424 .23761 L
.75924 .21817 L
.75493 .21056 L
.74531 .20231 L
.74004 .21817 L
.73569 .23523 L
.73459 .23761 L
.72607 .25211 L
.72244 .25705 L
.71645 .26413 L
.70683 .27373 L
.70372 .27648 L
.69721 .28183 L
.68759 .28893 L
.67797 .29533 L
.67703 .29592 L
.66835 .30118 L
.65873 .30662 L
.64911 .31173 L
.64199 .31535 L
.63949 .31659 L
Mistroke
.62987 .32124 L
.62025 .32573 L
.61063 .33009 L
.60101 .33435 L
.59999 .33479 L
.59139 .33852 L
.58177 .34264 L
.57215 .34673 L
.56253 .3508 L
.55445 .35423 L
.55291 .35488 L
.54329 .35897 L
.53367 .3631 L
.52405 .36728 L
.51443 .37154 L
.50972 .37366 L
.50481 .37589 L
.49519 .38036 L
.48557 .38496 L
.47595 .38973 L
.46937 .3931 L
.46633 .39469 L
.45671 .39987 L
.44709 .40533 L
.43747 .41111 L
.43518 .41254 L
.42785 .41726 L
.41823 .42385 L
.40861 .43098 L
.40733 .43197 L
.39899 .43874 L
.38937 .44729 L
.38508 .45141 L
.37975 .45681 L
.37013 .46757 L
.36744 .47085 L
.36051 .4799 L
.35343 .49028 L
.35089 .49434 L
.34227 .50972 L
.34127 .51168 L
.3333 .52915 L
.33165 .53322 L
.32604 .54859 L
.32203 .56129 L
.32011 .56803 L
.31523 .58746 L
.31241 .6006 L
.31118 .6069 L
.3078 .62634 L
Mistroke
.30497 .64577 L
.30279 .66327 L
.30257 .66521 L
.30053 .68465 L
.2988 .70408 L
.29731 .72352 L
.29603 .74295 L
.29493 .76239 L
.29397 .78183 L
.29317 .80068 L
.29315 .80126 L
.29243 .8207 L
.2918 .84014 L
.29125 .85957 L
.29078 .87901 L
.29036 .89845 L
.28999 .91788 L
.28967 .93732 L
.28939 .95675 L
.28914 .97619 L
Mfstroke
P
p
.001 w
.02381 .38893 m
.03197 .3931 L
.03343 .39386 L
.04305 .39901 L
.05267 .40442 L
.06229 .41014 L
.06615 .41254 L
.07191 .41622 L
.08153 .42273 L
.09115 .42977 L
.09401 .43197 L
.10077 .43742 L
.11039 .44583 L
.11626 .45141 L
.12001 .45518 L
.12963 .46571 L
.1339 .47085 L
.13925 .47775 L
.1479 .49028 L
.14887 .49181 L
.15849 .5086 L
.15907 .50972 L
.16804 .52915 L
.16811 .52933 L
.1753 .54859 L
.17773 .55609 L
.18123 .56803 L
.18611 .58746 L
.18735 .59305 L
.19015 .6069 L
.19353 .62634 L
.19637 .64577 L
.19697 .65034 L
.19877 .66521 L
.2008 .68465 L
.20254 .70408 L
.20403 .72352 L
.2053 .74295 L
.20641 .76239 L
.20659 .76591 L
.20736 .78183 L
.20819 .80126 L
.20891 .8207 L
.20953 .84014 L
.21008 .85957 L
.21056 .87901 L
.21098 .89845 L
.21134 .91788 L
.21166 .93732 L
.21195 .95675 L
Mistroke
.21219 .97619 L
Mfstroke
P
p
.001 w
.97619 .52418 m
.96657 .5132 L
.9634 .50972 L
.95695 .5028 L
.94733 .49289 L
.94473 .49028 L
.93771 .48337 L
.92809 .47418 L
.92453 .47085 L
.91847 .46524 L
.90885 .4565 L
.90317 .45141 L
.89923 .44789 L
.88961 .43937 L
.88122 .43197 L
.87999 .43089 L
.87037 .42238 L
.86075 .41379 L
.85936 .41254 L
.85113 .40504 L
.84151 .39608 L
.83838 .3931 L
.83189 .38679 L
.82227 .37706 L
.81903 .37366 L
.81265 .36673 L
.80303 .35558 L
.80192 .35423 L
.79341 .34325 L
.78744 .33479 L
.78379 .32918 L
.77575 .31535 L
.77417 .3123 L
.76675 .29592 L
.76455 .29004 L
.762 .27648 L
.75728 .25705 L
.75493 .25252 L
.74531 .24186 L
.74119 .25705 L
.73736 .27648 L
.73569 .28547 L
.73193 .29592 L
.72607 .30913 L
.72292 .31535 L
.71645 .32665 L
.71122 .33479 L
.70683 .34108 L
.69721 .35365 L
.69674 .35423 L
Mistroke
.68759 .36497 L
.67963 .37366 L
.67797 .37542 L
.66835 .38523 L
.66028 .3931 L
.65873 .39458 L
.64911 .40359 L
.63949 .41237 L
.63931 .41254 L
.62987 .42098 L
.62025 .4295 L
.61745 .43197 L
.61063 .43798 L
.60101 .44649 L
.59549 .45141 L
.59139 .45508 L
.58177 .4638 L
.57414 .47085 L
.57215 .4727 L
.56253 .48185 L
.55394 .49028 L
.55291 .49131 L
.54329 .50115 L
.53527 .50972 L
.53367 .51146 L
.52405 .52234 L
.51831 .52915 L
.51443 .53391 L
.50481 .54632 L
.50313 .54859 L
.49519 .55975 L
.48967 .56803 L
.48557 .57446 L
.47781 .58746 L
.47595 .59076 L
.46743 .6069 L
.46633 .60912 L
.45836 .62634 L
.45671 .63016 L
.45044 .64577 L
.44709 .65488 L
.44354 .66521 L
.43753 .68465 L
.43747 .68486 L
.43229 .70408 L
.42785 .72291 L
.42772 .72352 L
.42372 .74295 L
.42023 .76239 L
.41823 .77484 L
Mistroke
.41718 .78183 L
.41451 .80126 L
.41216 .8207 L
.41011 .84014 L
.40861 .85609 L
.4083 .85957 L
.40672 .87901 L
.40532 .89845 L
.4041 .91788 L
.40302 .93732 L
.40207 .95675 L
.40123 .97619 L
Mfstroke
P
p
.001 w
.02381 .58797 m
.03343 .60595 L
.03391 .6069 L
.04298 .62634 L
.04305 .6265 L
.05089 .64577 L
.05267 .65053 L
.05779 .66521 L
.06229 .67949 L
.0638 .68465 L
.06904 .70408 L
.07191 .71594 L
.07362 .72352 L
.07761 .74295 L
.0811 .76239 L
.08153 .76496 L
.08415 .78183 L
.08683 .80126 L
.08917 .8207 L
.09115 .83936 L
.09123 .84014 L
.09303 .85957 L
.09462 .87901 L
.09601 .89845 L
.09724 .91788 L
.09832 .93732 L
.09927 .95675 L
.10011 .97619 L
s
P
p
.001 w
.88677 .97619 m
.88599 .95675 L
.88511 .93732 L
.88412 .91788 L
.883 .89845 L
.88176 .87901 L
.88035 .85957 L
.87999 .85486 L
.87878 .84014 L
.87703 .8207 L
.87506 .80126 L
.87287 .78183 L
.87043 .76239 L
.87037 .76191 L
.86772 .74295 L
.86472 .72352 L
.8614 .70408 L
.86075 .70051 L
.85774 .68465 L
.85373 .66521 L
.85113 .65349 L
.84934 .64577 L
.84458 .62634 L
.84151 .61455 L
.83944 .6069 L
.83393 .58746 L
.83189 .58057 L
.82807 .56803 L
.82227 .54976 L
.82189 .54859 L
.81545 .52915 L
.81265 .52087 L
.80883 .50972 L
.80303 .49296 L
.8021 .49028 L
.79538 .47085 L
.79341 .4651 L
.78878 .45141 L
.78379 .4362 L
.78243 .43197 L
.77646 .41254 L
.77417 .4046 L
.77098 .3931 L
.7661 .37366 L
.76455 .36675 L
.76292 .35423 L
.76086 .33479 L
.757 .31535 L
.75493 .30972 L
.75019 .29592 L
Mistroke
.74531 .29465 L
.74498 .29592 L
.74132 .31535 L
.73865 .33479 L
.7363 .35423 L
.73569 .35942 L
.73258 .37366 L
.72768 .3931 L
.72607 .39898 L
.72221 .41254 L
.71645 .43128 L
.71623 .43197 L
.70989 .45141 L
.70683 .46047 L
.70329 .47085 L
.69721 .48842 L
.69656 .49028 L
.68984 .50972 L
.68759 .51626 L
.68321 .52915 L
.67797 .54492 L
.67677 .54859 L
.6706 .56803 L
.66835 .57535 L
.66474 .58746 L
.65923 .6069 L
.65873 .60871 L
.65408 .62634 L
.64932 .64577 L
.64911 .64668 L
.64494 .66521 L
.64093 .68465 L
.63949 .69206 L
.63727 .70408 L
.63395 .72352 L
.63094 .74295 L
.62987 .7504 L
.62823 .76239 L
.62579 .78183 L
.6236 .80126 L
.62164 .8207 L
.62025 .83586 L
.61988 .84014 L
.61831 .85957 L
.61691 .87901 L
.61566 .89845 L
.61455 .91788 L
.61356 .93732 L
.61268 .95675 L
.6119 .97619 L
Mistroke
Mfstroke
P
p
.001 w
.784 .97619 m
.78379 .95747 L
.78378 .95675 L
.78353 .93732 L
.78325 .91788 L
.78294 .89845 L
.78258 .87901 L
.78219 .85957 L
.78175 .84014 L
.78126 .8207 L
.78072 .80126 L
.78012 .78183 L
.77945 .76239 L
.77871 .74295 L
.7779 .72352 L
.77701 .70408 L
.77603 .68465 L
.77498 .66521 L
.77417 .65139 L
.77383 .64577 L
.77258 .62634 L
.77125 .6069 L
.76984 .58746 L
.76835 .56803 L
.76681 .54859 L
.76523 .52915 L
.76455 .52092 L
.76392 .50972 L
.76295 .49028 L
.76206 .47085 L
.7611 .45141 L
.75975 .43197 L
.75741 .41254 L
.75493 .40002 L
.75389 .3931 L
.74531 .37429 L
.74291 .3931 L
.74112 .41254 L
.73966 .43197 L
.73841 .45141 L
.73729 .47085 L
.73627 .49028 L
.73569 .50225 L
.73507 .50972 L
.73346 .52915 L
.73187 .54859 L
.73032 .56803 L
.72883 .58746 L
.72741 .6069 L
.72607 .62634 L
Mistroke
.72607 .62638 L
.72484 .64577 L
.72369 .66521 L
.72264 .68465 L
.72166 .70408 L
.72077 .72352 L
.71996 .74295 L
.71922 .76239 L
.71855 .78183 L
.71794 .80126 L
.7174 .8207 L
.71691 .84014 L
.71647 .85957 L
.71645 .86055 L
.71608 .87901 L
.71573 .89845 L
.71541 .91788 L
.71513 .93732 L
.71489 .95675 L
.71466 .97619 L
Mfstroke
P
p
.001 w
.76015 .97619 m
.7601 .95675 L
.76003 .93732 L
.75996 .91788 L
.75988 .89845 L
.75979 .87901 L
.75968 .85957 L
.75955 .84014 L
.7594 .8207 L
.75923 .80126 L
.75902 .78183 L
.75878 .76239 L
.75848 .74295 L
.75813 .72352 L
.7577 .70408 L
.75717 .68465 L
.75652 .66521 L
.7557 .64577 L
.75493 .6308 L
.75478 .62634 L
.75405 .6069 L
.75315 .58746 L
.75199 .56803 L
.75029 .54859 L
.74531 .54167 L
.74494 .54859 L
.74407 .56803 L
.74338 .58746 L
.74281 .6069 L
.74232 .62634 L
.74191 .64577 L
.74155 .66521 L
.74124 .68465 L
.74097 .70408 L
.74074 .72352 L
.74053 .74295 L
.74035 .76239 L
.74019 .78183 L
.74005 .80126 L
.73992 .8207 L
.73981 .84014 L
.73972 .85957 L
.73963 .87901 L
.73955 .89845 L
.73949 .91788 L
.73943 .93732 L
.73938 .95675 L
.73933 .97619 L
s
P
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{237, 237},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCacheValid->False],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]]}, Open]]}, Open]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 640}, {0, 460}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 365},
WindowMargins->{{52, Automatic}, {Automatic, -2}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 101, 2, 70, "Subtitle"],
Cell[1835, 55, 92, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[1950, 59, 114, 2, 27, "Input"],
Cell[2067, 63, 784, 12, 70, "Print"]
}, Closed]],

Cell[CellGroupData[{
Cell[2883, 77, 88, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[2994, 81, 113, 2, 70, "Input"],
Cell[3110, 85, 279, 6, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3421, 93, 115, 2, 70, "Input"],
Cell[3539, 97, 207, 4, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3778, 103, 88, 2, 70, "Input"],
Cell[3869, 107, 409, 7, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4310, 116, 137, 3, 70, "Input"],
Cell[4450, 121, 11168, 1080, 70, 11010, 1075, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15659, 1203, 88, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[15770, 1207, 154, 3, 70, "Input"],
Cell[15927, 1212, 170, 4, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[16129, 1218, 176, 4, 70, "Input"],
Cell[16308, 1224, 8507, 913, 70, 8349, 908, "GraphicsData", 
"PostScript", "Graphics"],
Cell[24818, 2139, 178, 5, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[25028, 2146, 101, 2, 70, "Input"],
Cell[25132, 2150, 161, 4, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[25325, 2156, 101, 2, 70, "Input"],
Cell[25429, 2160, 158, 4, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[25619, 2166, 84, 2, 70, "Input"],
Cell[25706, 2170, 237, 5, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[25975, 2177, 181, 4, 70, "Input"],
Cell[26159, 2183, 14181, 1259, 70, 14023, 1254, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]],

Cell[CellGroupData[{
Cell[40372, 3444, 79, 2, 70, "Input"],
Cell[40454, 3448, 18781, 1743, 70, 18623, 1738, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[59276, 5193, 88, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[59387, 5197, 224, 5, 70, "Input"],
Cell[59614, 5204, 24692, 2113, 70, 24534, 2108, "GraphicsData", 
"PostScript", "Graphics"],
Cell[84309, 7319, 185, 5, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[84526, 7326, 272, 6, 70, "Input"],
Cell[84801, 7334, 38654, 2959, 70, 38496, 2954, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]],

Cell[CellGroupData[{
Cell[123487, 10295, 79, 2, 70, "Input"],
Cell[123569, 10299, 57048, 4239, 70, 56890, 4234, "GraphicsData", 
"PostScript", "Graphics"],
Cell[180620, 14540, 178, 5, 70, "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
